#ifndef STATEMACHINE_H
#define STATEMACHINE_H
#include "LM75B.h"
#include "C12832.h"
#include <vector>
#include <string>
#include "mbed.h"

enum State {INIT,RECEIVE,TRANSMIT,CERROR};

class StateMachine
{

private:
    void actionInit();
    void actionReceive();
    void actionTransmit();

    bool containsID();

private:
    State currentState;
    C12832* lcd;
    LM75B* tempSensor;
    AnalogIn* pot1;

    std::vector<char> srbuffer;
    char ownID = 0x14;

public:
    StateMachine();     // Constructor
    ~StateMachine();    // Destructor
    void start();

};


#endif