#include "mbed.h"
#include "LM75B.h"
#include "C12832.h"
#include "EthernetInterface.h"
#include "StateMachine.h"
#include <vector>
#include <string>

StateMachine::StateMachine()
{
    lcd = new C12832 (D11, D13, D12, D7, D10);
    tempSensor = new LM75B (D14,D15);
    pot1 = new AnalogIn (A0);
    currentState = INIT;
}

StateMachine::~StateMachine()
{
    delete lcd;
    delete tempSensor;
    delete pot1;
}

void StateMachine::start()
{
    while(!containsID()) {
        switch(currentState) {
            case INIT:
                actionInit();
                break;
            case RECEIVE:
                actionReceive();
                currentState = TRANSMIT;
                break;
            case TRANSMIT:
                actionTransmit();
                currentState = RECEIVE;
                break;
            default:
                currentState = CERROR;
                break;
        }
    }
}

void StateMachine::actionInit()
{
    do {
        uint8_t PWM = pot1.read();
        if (PWM == 1.0) {
            currentState = RECEIVE;
        } else if (PWM == 0.0) {
            currentState = TRANSMIT;
        }
    } while (currentState == INIT);
}

void StateMachine::actionReceive()
{
    printf("Server:\n\r");

    EthernetInterface eth;
    eth.set_network("192.168.0.20","255.255.255.0","192.168.0.1");
    eth.connect();

    printf("The Server IP address is '%s'\n\r", eth.get_ip_address());

    TCPServer srv(&eth);
    srv.bind(4000);
    srv.listen();

    while(true) {
        TCPSocket client;
        SocketAddress client_addr;
        char *buffer = "Hello TCP client!\r\n";

        srv.accept(&client, &client_addr);
        printf("Accepted %s:%d\n\r", client_addr.get_ip_address(), client_addr.get_port());

        client.send(buffer, 256);

        client.recv(srbuffer, sizeof srbuffer);

        uint8_t upper = srbuffer[0];
        uint8_t lower = srbuffer[1];
        uint8_t PWM = srbuffer[2];


        float temp = ((upper << 8) | lower) / 256.00;

        printf("Temperature is %f\n", temp);
        printf("%d\n",PWM);
        for (uint8_t i = 3; i < 127; i++) {
            if (srbuffer[i] != '0') {
                printf("%d\n", srbuffer[i]);
            }

        }
        client.close();
    }
}

void StateMachine::actionTransmit()
{

    EthernetInterface eth;
    eth.set_network("192.168.0.20","255.255.255.0","192.168.0.1");
    eth.connect();

    printf("The client IP address is '%s'\n\r", eth.get_ip_address());

    TCPSocket socket;
    socket.open(&eth);
    socket.connect("192.168.0.28",4000);

    if (srbuffer.size() == 0) {
        uint16_t temperature =(tempSensor.read());
        char upperbyte = (temperature >> 8) & 0x00FF;
        char lowerbyte = temperature & 0x00FF;
        char pwm = (char)(pot1);

        srbuffer.push(upperbyte);
        srbuffer.push(lowerbyte);
        srbuffer.push(pwm);
        srbuffer.push(ownID));

        // print hex value of temperature on lcd
        lcd.printf("Temp %.1x\n", tempSensor.read());
    } else {
        srbuffer.push(ownID);
    }


    printf(srbuffer);
    socket.send(srbuffer, srbuffer.size());
    socket.close();
}

bool StateMachine::containsID()
{
    if(srbuffer.size() >= 3) {
        for (uint8_t i = 3; i < srbuffer.size() - 1; i++) {
            if (srbuffer[i] == ownID) {
                return true;
            }
        }
    }
    return false;
}