#ifndef DEFINES_PINS_H
#define DEFINES_PINS_H

#define FF_DRIVER_VERSION_1_0   0
#define FF_DRIVER_VERSION_2_0   1
#define FF_DRIVER_VERSION_2_1   2

#define FF_DRIVER_VERSION       FF_DRIVER_VERSION_2_1       // Set driver version here

#if (FF_DRIVER_VERSION == FF_DRIVER_VERSION_1_0)

#define PIN_THR1    p12         // Thruster pins
#define PIN_THR2    p11
#define PIN_THR3    p8
#define PIN_THR4    p7
#define PIN_THR5    p6
#define PIN_THR6    p5
#define PIN_THR7    p30
#define PIN_THR8    p29
#define PIN_WMPWM   p21         // Wheel motor
#define PIN_WMA     p27
#define PIN_WMB     p28
#define PIN_WENCA   p17         // Wheel encoder
#define PIN_WENCB   p18
#define PIN_I2CSDA  p28
#define PIN_I2CSCL  p27

#elif (FF_DRIVER_VERSION == FF_DRIVER_VERSION_2_0)

#define PIN_THR1    p5          // Thruster pins
#define PIN_THR2    p6
#define PIN_THR3    p7
#define PIN_THR4    p8
#define PIN_THR5    p9
#define PIN_THR6    p10
#define PIN_THR7    p11
#define PIN_THR8    p12
#define PIN_WMPWM   p26         // Wheel motor
#define PIN_WMA     p30
#define PIN_WMB     p29
#define PIN_WENCA   p25         // Wheel encoder
#define PIN_WENCB   p24
#define PIN_I2CSDA  p28         // RGB LED
#define PIN_I2CSCL  p27


#elif (FF_DRIVER_VERSION == FF_DRIVER_VERSION_2_1)

#define PIN_THR1    p23         // Thruster pins
#define PIN_THR2    p24
#define PIN_THR3    p25
#define PIN_THR4    p26
#define PIN_THR5    p27
#define PIN_THR6    p28
#define PIN_THR7    p29
#define PIN_THR8    p30
#define PIN_WMPWM   p21         // Wheel motor
#define PIN_WMA     p12
#define PIN_WMB     p11
#define PIN_WENCA   p13         // Wheel encoder
#define PIN_WENCB   p14
#define PIN_I2CSDA  p9          // RGB LED
#define PIN_I2CSCL  p10
#define PIN_LEDIOE  p22
#define ADDR_RGB    0xaa
#define LED_STR0_R  PCA_LED7
#define LED_STR0_G  PCA_LED4
#define LED_STR0_B  PCA_LED6
#define LED_STR0_A  PCA_LED5
#define LED_STR1_R  PCA_LED3
#define LED_STR1_G  PCA_LED0
#define LED_STR1_B  PCA_LED2
#define LED_STR1_A  PCA_LED1

#endif

#endif