#ifndef DEFINES_DEBUG_H
#define DEFINES_DEBUG_H

//#####################################################################################\\
// Toggle between regular serial and ROS serial
#define ROS_SERIAL_MODE     true    // Default true

// Mode defines:
#define NORMAL                  0
#define DEBUG_THRUSTERS         1
#define DEBUG_WHEEL_CONST       2
#define DEBUG_WHEEL_PID         3
#define DEBUG_LED_CONST         4
#define DEBUG_LED_COLOR_SEQ     5
#define DEBUG_LED_ALPHA_SEQ     6

#define MODE                NORMAL

// Thruster debugging
#define DT_PERIOD           500.0      // [ms] Length of thrust pulse

// Wheel constant PWM debugging
#define DWC_PWM             0.2

// Wheel PID debugging
#define DWP_SETPOINT        200.0

// LED constant debugging
#define DLC_COLOR           red

// Other modes
#define MODE_DUTY_CYCLE_CMD false
#define MODE_FEED_FORWARD   false

#endif