#ifndef DEFINES_H
#define DEFINES_H

#include "defines_debug.h"
#include "defines_pins.h"

//#####################################################################################\\

#define SERIAL_BAUD_RATE   115200

#define N_THRUSTERS     8

#define PID_PERIOD      50.0        // [ms] Update period of the PID command
#define LED_PERIOD      50.0        // [ms] Period of the blinking LED
#define MEAS_PERIOD     50.0        // [ms] Period at which to publish new velocity measurement
#define PID_DEBUG_PERIOD 2500.0     // [ms] Period at which to publish PID parameters
#define THRUST_PERIOD   100.0       // [ms] PWM period of thrusters
#define THRUST_PWM_N    1000.0        // Number of PWM steps per PID period
#define MOTOR_PWM_PERIOD    0.00005 // 20 kHz

// Parameters for motor encoder
#define NCREV           64.0        // Number of counts per revolution
#define SPEED_COUNTS    100         // Number of counts per speed measurement in encoder

#define NGR             18.75       // Gear ratio
#define V_SMAX          500.0       // [RPM] No-load max shaft speed
#define M2SEC           60.0        // [sec/min] Conversion
#define REV2DEG         360.0       // [deg/rev] Conversion

#define V_SMAX_ENF      400.0       // [RPM] Enforced maximum shaft speed
#define V_SMIN_ENF      0.0         // [RPM] Enforced minimum shaft speed

#define COUNTS2SHAFT    M2SEC/NCREV/NGR   // Counts/sec to shaft speed in RPM

#define R               2.4         // 12 V / 5 A
#define CURRENT_MAX     5.0         // Stall curent of motor
#define VOLTAGE_MAX     12.0        // Supply voltage to motor

// Regular PID
#define KP_INIT         1.0 
#define KI_INIT         0.0001
#define KD_INIT         0.0
#define ACC_LIMIT_INIT  0.0         // Scaled accumulated error limit

// PID with feed-foward term
#define KP_FF_INIT          0.1
#define KI_FF_INIT          0.00001
#define KD_FF_INIT          0.0
#define ACC_LIMIT_FF_INIT   0.0
#define SLOPE_FF_INIT       0.001704
#define INTER_FF_INIT       -0.0171

#define SMOOTHING_VAL   0.9
#define PWM_LIMIT       0.7

#define INITIAL_SP      0.0
#define COARSE_INCR     50.0
#define FINE_INCR       25.0
#define HAIR_INCR       5.0

#define KE              VOLTAGE_MAX/(V_SMAX*NGR)

// RGBA LED parameters
#define MODE_AMBER      false
#define RGB_LED_PERIOD  50
#define DEF_CLR_FADE_T  1000
#define DEF_ALP_FADE_T  1000

//#####################################################################################\\

#endif  // End include guard