#include "mbed.h"
#include "rtos/rtos.h"
#include <string>
#include "MuNFC.h"

DigitalOut led_alive(LED1);
DigitalOut led_progress(LED2);
DigitalOut led_ok(LED3);
DigitalOut led_failed(LED4);
Semaphore s(1);

MuNFC nfc("00000003RdfgT390", 1, p11, p12, p13, p19, p18);
Serial arduino(p9, p10);  // tx, rx

#define DEFAULT_PACKET 1

char messageFromNFC[300];
char c;
string messageFromArduino;
string messageToNFC;

//Encode callback
void encode_cb(TLVList* tlv, void *)
{
  static uint32_t counter = 0;
  counter++;
  tlv->putUInt8( DEFAULT_PACKET ); //First uint8_t is packet type
  tlv->putString((char*)messageToNFC.c_str());
  tlv->putUInt32( counter );
}

//Decode callback
void decode_cb(TLVList* tlv, void *)
{
  if(tlv->getNext() != UINT8)
  {
    return;
  }
  if(tlv->getUInt8() == DEFAULT_PACKET) //First uint8_t is packet type
  { 
    if(tlv->getNext() != STRING)
    {
      return;
    }
    tlv->getString(messageFromNFC, 299);
    printf("Message received from NFC: %s\n",messageFromNFC);
  }
  s.release();
}

//NFC event
void event_cb(NFCEvent event, void*)
{
    switch(event)
    {
    case NFC_TRANSACTION_STARTED:
        led_progress=1;
        led_ok=0;
        led_failed=0;
    break;
    case NFC_TRANSACTION_SUCCESSFUL:
        led_progress=0;
        led_ok=1;
        led_failed=0;
    break;
    case NFC_TRANSACTION_FAILED:
        led_progress=0;
        led_ok=0;
        led_failed=1;
    break;
    }
}

int main() {   
    nfc.encode(encode_cb, NULL);
    nfc.decode(decode_cb, NULL);
    nfc.event(event_cb, NULL);
    s.wait();
    
    bool ret = nfc.init();
    if(ret)
    {
      //printf("MuNFC stack initialized\n");
      
    }
    else
    {
      //printf("Could not initialize stack\n");
    }
    
    messageFromNFC[0] = '\0';
    //messageToNFC = "pay_666_EUR_202_123456789101112131";
    messageToNFC = "cancel";
    nfc.run(); //Start thread
    

    
    while(1) {
        led_alive = 1;
        
        
        // read messages from arduino
        while(arduino.readable()){
            
            c = arduino.getc();
            if (c != '\n'){
                messageFromArduino += c;
            } else {
                if (messageFromArduino.length() > 1){    
                
                    //blink a bit
                    led_alive = 0;
                    wait(0.05);
                    led_alive = 1;
                    wait(0.05);
                    led_alive = 0;
                
                    messageToNFC = messageFromArduino;
                    //printf("Set message to: %s\n",messageToNFC);
                }
                messageFromArduino = "";
            }
        }
        
        if (messageFromNFC[0] != '\0'){
            arduino.printf("%s\n",messageFromNFC);
            messageFromNFC[0] = '\0';
        }
        
        /*
        if(s.wait(200) > 0)
        {
          printf("Got: %s\n",messageFromNFC);
        }*/
    }
}
