/* mbed Microcontroller Library
 * Copyright (c) 2019 ARM Limited
 * SPDX-License-Identifier: Apache-2.0
 */

#include "mbed.h"
#include "platform/mbed_thread.h"
#include "LCD.h"

// Blinking rate in milliseconds
#define BLINKING_RATE_MS                                                    500
int zaehler=0;
DigitalOut  statusled(PC_0);
PortOut  reste(PortC,0b11111110); 
PortOut  alle(PortC,0b11111111);
DigitalIn   taste(PA_1);
InterruptIn taste2(PA_10);
lcd meinLCD;

void isr() //Interrupt-Service-Routine
{
statusled=0;
reste=0b11111111;
}


int main()
{
    // Initialise the digital pin LED1 as an output
    DigitalOut led(LED1);
    PortIn schalterchen (PortB,0b11111111);
    taste.mode(PullDown); //die Grundplatine benötigt bei Eingängen PullDown)
    schalterchen.mode(PullDown);
    taste2.mode(PullDown); //Interrupt-Definitionen
    taste2.rise(&isr); //taste2.fall für fallende Flanke
    taste2.enable_irq(); 
    __enable_irq(); //globale Freigabe
    statusled=1;
    meinLCD.clear();
    meinLCD.cursorpos(0x40);
    meinLCD.printf("Urlaubsbaron");
    AnalogIn poti(PA_0);
    
    
    while (true) {
        led = !led;
        zaehler++;
        meinLCD.cursorpos(0);
        meinLCD.printf("Zaehler= %d" ,zaehler);
        if (poti>0.5) statusled=1;
        else 
        {
            statusled=0;
            alle=schalterchen;
        }        
        if(taste==1){statusled=0;}
        thread_sleep_for(BLINKING_RATE_MS);
    }
}
