/* USER CODE BEGIN Header */
/**
  ******************************************************************************
  * @file           : main.h
  * @brief          : Header for main.c file.
  *                   This file contains the common defines of the application.
  ******************************************************************************
  * @attention
  *
  * <h2><center>&copy; Copyright (c) 2020 STMicroelectronics.
  * All rights reserved.</center></h2>
  *
  * This software component is licensed by ST under BSD 3-Clause license,
  * the "License"; You may not use this file except in compliance with the
  * License. You may obtain a copy of the License at:
  *                        opensource.org/licenses/BSD-3-Clause
  *
  ******************************************************************************
  */
/* USER CODE END Header */

/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef __MAIN_H
#define __MAIN_H

#ifdef __cplusplus
extern "C" {
#endif

/* Includes ------------------------------------------------------------------*/
#include "stm32h7xx_hal.h"


/* Private includes ----------------------------------------------------------*/
/* USER CODE BEGIN Includes */

/* USER CODE END Includes */

/* Exported types ------------------------------------------------------------*/
/* USER CODE BEGIN ET */

/* USER CODE END ET */

/* Exported constants --------------------------------------------------------*/
/* USER CODE BEGIN EC */

const int frame_bsize_8b            =640*480*1;  //640*480 pixels de 1 byte
const int frame_bsize_QVGA_8b       =320*240*1;  //320*240 pixels de 1 byte
const int frame_bsize_QQVGA_8b      =160*120*1;  //160*120 pixels de 1 byte
const int frame_bsize_10b           =640*240*2;  //640*240 pixels de 2 bytes
const int frame_bsize_QVGA_10b      =320*240*2;  //320*240 pixels de 2 bytes 
const int frame_bsize_QQVGA_10b     =160*120*2;  //160*120 pixels de 2 bytes 

// same value but in word size
const int frame_wsize_8b            =frame_bsize_8b/4;          //640*480 pixels de 1 byte /4 pour donner la tailler en word
const int frame_wsize_QVGA_8b       =frame_bsize_QVGA_8b/4;     //320*240 pixels de 1 byte  /4 pour donner la tailler en word
const int frame_wsize_QQVGA_8b      =frame_bsize_QQVGA_8b/4;    //160*120 pixels de 1 byte /4 pour donner la tailler en word
const int frame_wsize_10b           =frame_bsize_10b/4;         //640*240 pixels de 2 bytes /4 pour donner la tailler en word
const int frame_wsize_QVGA_10b      =frame_bsize_QVGA_10b/4;    //320*240 pixels de 2 bytes  /4 pour donner la tailler en word
const int frame_wsize_QQVGA_10b     =frame_bsize_QQVGA_10b/4;   //160*120 pixels de 2 bytes  /4 pour donner la tailler en word



/* USER CODE END EC */

/* Exported macro ------------------------------------------------------------*/
/* USER CODE BEGIN EM */

/* USER CODE END EM */

/* Exported functions prototypes ---------------------------------------------*/
void Error_Handler(void);

/* USER CODE BEGIN EFP */

/* Private function prototypes -----------------------------------------------*/
// functions for sending frame over ethernet
void print_start_frame(void);
void send_frame_ethernet(void); 
int send_frame_ethernet_nohandshake_while(void);


void process_message(int rcount, char* rbuffer);

// configuration functions
static void MX_GPIO_Init(void);
static void MX_DMA_Init(void);
static void MX_DCMI_Init_8b(void);
static void MX_DCMI_Init_10b(void);

// capture functions
void start_capture_10b();
void start_video();
void suspend_capture(void);
void resume_capture(void);
void stop_capture(void);


// IRQ handler for DMA/MDMA
//void HAL_DMA_IRQHandler(DMA_HandleTypeDef* hdma);
void DMA2_Stream1_IRQHandler(void);
//void DMA1_Stream0_IRQHandler(void);
//void DMA1_Stream1_IRQHandler(void);
void HAL_DMA_XferErrorCallback (DMA_HandleTypeDef * hddma);
void HAL_DMA_XferCpltCallback (DMA_HandleTypeDef * hddma);

// IRQ and callback handler for DCMI
void HAL_DCMI_FrameEventCallback(DCMI_HandleTypeDef *hdcmi);
void HAL_DCMI_VsyncEventCallback(DCMI_HandleTypeDef *hdcmi);
void HAL_DCMI_LineEventCallback (DCMI_HandleTypeDef *hdcmi);  
void HAL_DCMI_ErrorCallback (DCMI_HandleTypeDef *hdcmi);
//void HAL_DCMI_IRQHandler (DCMI_HandleTypeDef * hdcmi);




/* USER CODE END EFP */

/* Private defines -----------------------------------------------------------*/
#define B1_Pin GPIO_PIN_13
#define B1_GPIO_Port GPIOC
#define OSC32_IN_Pin GPIO_PIN_14
#define OSC32_IN_GPIO_Port GPIOC
#define OSC32_OUT_Pin GPIO_PIN_15
#define OSC32_OUT_GPIO_Port GPIOC
#define USB_FS_PWR_EN_Pin GPIO_PIN_10
#define USB_FS_PWR_EN_GPIO_Port GPIOF
#define PH0_MCU_Pin GPIO_PIN_0
#define PH0_MCU_GPIO_Port GPIOH
#define PH1_MCU_Pin GPIO_PIN_1
#define PH1_MCU_GPIO_Port GPIOH
#define LD1_Pin GPIO_PIN_0
#define LD1_GPIO_Port GPIOB
#define LD3_Pin GPIO_PIN_14
#define LD3_GPIO_Port GPIOB
#define STLINK_RX_Pin GPIO_PIN_8
#define STLINK_RX_GPIO_Port GPIOD
#define STLINK_TX_Pin GPIO_PIN_9
#define STLINK_TX_GPIO_Port GPIOD
#define USB_FS_OVCR_Pin GPIO_PIN_7
#define USB_FS_OVCR_GPIO_Port GPIOG
#define USB_FS_VBUS_Pin GPIO_PIN_9
#define USB_FS_VBUS_GPIO_Port GPIOA
#define USB_FS_ID_Pin GPIO_PIN_10
#define USB_FS_ID_GPIO_Port GPIOA
#define USB_FS_N_Pin GPIO_PIN_11
#define USB_FS_N_GPIO_Port GPIOA
#define USB_FS_P_Pin GPIO_PIN_12
#define USB_FS_P_GPIO_Port GPIOA
#define LD2_Pin GPIO_PIN_1
#define LD2_GPIO_Port GPIOE
/* USER CODE BEGIN Private defines */

/* USER CODE END Private defines */

#ifdef __cplusplus
}
#endif

#endif /* __MAIN_H */

/************************ (C) COPYRIGHT STMicroelectronics *****END OF FILE****/
