/* Includes ------------------------------------------------------------------*/
//my include
#include "main.h"
#include "common_task.h"
#include "check_status.h"
#include "register_address.h"

//mbed include
#include "stm32h7xx_hal.h"
#include "mbed.h"
#include "EthernetInterface.h"
#include "TCPServer.h"
#include "TCPSocket.h"
//#include "FastPWM.h"


/* Private variables ---------------------------------------------------------*/

//DCMI & DMA stuff
DCMI_HandleTypeDef hdcmi;
DMA_HandleTypeDef hdma_dcmi;

// DMA handle for mem2mem transfert 
DMA_HandleTypeDef hd_m2m_dma;

// Virtual USB Serial port
Serial pc(USBTX, USBRX);

// etherner stuff
EthernetInterface eth;

TCPSocket socket;  //data socket
TCPSocket cs;  //com sockey

char ServerIP[17]="10.10.130.12";
int portnumber = 61477;
int portnumber_com = 61478;
char* commandbuffer;
char* commandbuffertemp;

int IN_MSG_LEN=64;
char OUT_MSG_LEN[5]="%64s";


// SPI1
SPI spi(PD_7, PB_4, PA_5); // mosi, miso, sclk
DigitalOut SSN(PA_15);


//LEDs
DigitalOut led1(LED1);  //PB_0
DigitalOut led2(LED2);  //PB_7
DigitalOut led3(LED3);  //PB_14

    
// GPIOS
DigitalOut RSTN(PA_0); 
DigitalOut SLEEPN(PA_2); 
DigitalOut CAPTURE(PA_9);
DigitalIn button_capture(PC_13);
InterruptIn irq_cis(PA_11);         //TODO
DigitalOut CONFIG1(PA_8);           
DigitalOut CONFIG2(PD_2);           
//FastPWM MCLK(PA_3);       



// frame pointer and frame size
char* FRAME_BUFFER;
int imSize=frame_bsize_10b;


int DEBUG=0;
int DEBUG_DCMI=1;
int TEST_DMA=1;

// DCMI callback handler
static __IO int HAL_DCMI_ErrorCallback_value=0;
static __IO int HAL_DCMI_IRQHandler_value=0;
static __IO int line_read=0;
static __IO int frame_read=0;
static __IO int frame_ready_to_send=0;

// DMA  callback handler
static __IO int DMA1_Stream0_IRQHandler_value=0;
static __IO int DMA1_Stream1_IRQHandler_value=0;
static __IO int DMA2_Stream1_IRQHandler_value=0;
static __IO int DMA_IRQHandler_value=0;
static __IO int HAL_DMA_XferCpltCallback_value=0;
static __IO int HAL_DMA_XferErrorCallback_value=0;



/***********************************************************************************************
*
*       Ethernet function
*
************************************************************************************************/

/**
@param none
@return  void
@brief print the start of the frame stored in frame buffer
*/

void print_start_frame(){
    int i,j,k=0;
    int byte_sent=0;
 
    for (i=0; i<1 ; i++){
        for (k=0; k<20; k++){
            for (j=0; j<32; j++){
                pc.printf("%3i ",(uint8_t) *(FRAME_BUFFER+i*640+k*32+j));
                sprintf(commandbuffer, "%3i ",(uint8_t) *(FRAME_BUFFER+i*640+k*32+j));
                byte_sent=cs.send(commandbuffer, strlen(commandbuffer));
            }
            pc.printf("\b\r\n");
            sprintf(commandbuffer, "\b\r\n");
            byte_sent=cs.send(commandbuffer, strlen(commandbuffer));
            
        }
    }   
}

/**
@brief sent via the data socket the frame stored in frame buffer
@param none
@return  the number of byte sent on the socket
*/
int send_frame_ethernet_nohandshake_while(){
   
    int  byte_chunk_sent=0;
    int a=0;
    int pixel_per_chunk=2048;
    int bytes_per_pixel=2;
    int bytes_per_chunk=pixel_per_chunk*bytes_per_pixel;
    int byte_to_send=0;
    int byte_per_image=imSize;
    

    while (byte_chunk_sent<byte_per_image){
        byte_to_send=min(byte_per_image - byte_chunk_sent, bytes_per_chunk);
        
        //pointer are world align. hence the divided by 4
        a = socket.send(FRAME_BUFFER+byte_chunk_sent/4 , byte_to_send);
        if(a<0){
            // non blocking may time out
            //pc.printf("error byte -1/ %d / %d\r\n",a,byte_chunk_sent);
            //return -1;   
        } else {
            byte_chunk_sent += a;
            //pc.printf("%d sent - total sent %d\r\n",a,byte_chunk_sent);
        }
    }
    
    //pc.printf("total of %d bytes sent\r\n",byte_chunk_sent);
    
    return byte_chunk_sent;
        
}



/**********************************************************************************************
*
*       capture function
*
************************************************************************************************/

//https://github.com/tomvdb/stm32f401-nucleo-basic-template/blob/master/Drivers/BSP/STM324x9I_EVAL/stm324x9i_eval_camera.c
/**
@brief start dcmi and start frame capture
@param none
@return  void
*/
void start_capture(){
        frame_read=0;
        line_read=0;
        
        //memset(FRAME_BUFFER,0,(size_t) frame_bsize_10b);
        HAL_DCMI_Stop(&hdcmi);
        if(DEBUG_DCMI==1)
            pc.printf("starting snapshot\r\n");
        
        // disable crop features
        HAL_DCMI_DisableCrop(&hdcmi);
        
        //enable DCMI
        ///HAL_DCMI_Start_DMA(&hdcmi, DCMI_MODE_SNAPSHOT, (uint32_t) FRAME_BUFFER, Im_size);
        //HAL_StatusTypeDef status = HAL_DCMI_Start_DMA (&hdcmi, DCMI_MODE_SNAPSHOT,(uint32_t) FRAME_BUFFER, (uint32_t) frame_wsize_QVGA_10b);  
        HAL_StatusTypeDef status = HAL_DCMI_Start_DMA (&hdcmi, DCMI_MODE_SNAPSHOT,(uint32_t) 0x30000000, (uint32_t) frame_wsize_QVGA_10b);  
        wait_us(100);
        
        if(DEBUG_DCMI==1)  {
            print_HAL_status_code(status);
            print_DCMI_state_code(HAL_DCMI_GetState(&hdcmi));
            print_DCMI_error_code(HAL_DCMI_GetError(&hdcmi));
            pc.printf("%i XferCount\r\n",hdcmi.XferCount);
            pc.printf("%i XferSize\r\n",hdcmi.XferSize);
            pc.printf("%i XferTransferNumber\r\n",hdcmi.XferTransferNumber);
            pc.printf("%x pBuffPtr\r\n",hdcmi.pBuffPtr);
            pc.printf("%i ErrorCode\r\n",hdcmi.ErrorCode);
        }

}

/**
@brief suspend DCMI
@param none
@return  void
*/
void suspend_capture(void){
    // Suspend the Camera Capture //
    HAL_DCMI_Suspend(&hdcmi); 
    
    HAL_DCMI_StateTypeDef DCMI_state = HAL_DCMI_GetState(&hdcmi);
    print_DCMI_state_code(DCMI_state);    
}

/**
@brief resume DCMI
@param none
@return  void
*/
void resume_capture(void) {
    // Start the Camera Capture //
    HAL_DCMI_Resume(&hdcmi);
}

/**
@brief stop DCMI
@param none
@return  void
*/
void stop_capture(void) {
    if(HAL_DCMI_Stop(&hdcmi) == HAL_OK){
     pc.printf("Error stopping camera\n\r");
    }else{
      pc.printf("Camera stopped\n\r"); 
    }
    
    HAL_DCMI_StateTypeDef DCMI_state = HAL_DCMI_GetState(&hdcmi);
    print_DCMI_state_code(DCMI_state);
}


/**********************************
*
* override DCMI callbacks
*
**********************************/
/**
@brief override interrupt DCMI: on frame callback; send frame
@param none
@return  void
*/
void HAL_DCMI_FrameEventCallback(DCMI_HandleTypeDef *hdcmi){
    frame_ready_to_send=1;
}

/**
@brief override interrupt DCMI: on vsync callback; increment frame count
@param none
@return  void
*/
void HAL_DCMI_VsyncEventCallback(DCMI_HandleTypeDef *hdcmi){
    frame_read++;       
}

/**
@brief override interrupt DCMI: on hsync callback; increment line count
@param none
@return  void
*/
void HAL_DCMI_LineEventCallback (DCMI_HandleTypeDef *hdcmi){  
    line_read++;  
}

/**
@brief override interrupt DCMI: on error callback; 
@param none
@return  void
*/
void HAL_DCMI_ErrorCallback (DCMI_HandleTypeDef *hdcmi){    
    HAL_DCMI_ErrorCallback_value=HAL_DCMI_GetError(hdcmi);
    pc.printf("error callback\r\n");
}

/**
@brief override interrupt DCMI: on IRQ handler; 
@param none
@return  void
*/
/*void HAL_DCMI_IRQHandler (DCMI_HandleTypeDef * hdcmi){
    HAL_DCMI_IRQHandler_value=1;
    pc.printf("DCMI IRQ handler\n\r");
}*/

/**********************************
*
* override DCMI callbacks
*
**********************************/

/**
@brief debug: set frmae buffer as a known pattern
@param none
@return  void
*/
void format_frame(int imSize){

        for (int j=0;j<1280;j=j+2){
            //1ere ligne
            pc.printf("%i - %i \r\n",j,(int) FRAME_BUFFER+j);
            *(FRAME_BUFFER+j)= (char) (j/2);
            *(FRAME_BUFFER+j+1)= (char) (j/2/256);
            
            //101eme ligne
            *(FRAME_BUFFER+100*1280+j)= (char) (j/2);
            *(FRAME_BUFFER+100*1280+j+1)= (char) (j/2/256);

        }

}

void print_memory_info() {
    // allocate enough room for every thread's stack statistics
    int cnt = osThreadGetCount();
    mbed_stats_stack_t *stats = (mbed_stats_stack_t*) malloc(cnt * sizeof(mbed_stats_stack_t));
 
    cnt = mbed_stats_stack_get_each(stats, cnt);
    for (int i = 0; i < cnt; i++) {
        printf("Thread: 0x%iX, Stack size: %iu / %iu\r\n", stats[i].thread_id, stats[i].max_size, stats[i].reserved_size);
    }
    free(stats);
 
    // Grab the heap statistics
    mbed_stats_heap_t heap_stats;
    mbed_stats_heap_get(&heap_stats);
    printf("Heap size: %iu / %iu bytes\r\n", heap_stats.current_size, heap_stats.reserved_size);
}


/******************************************************************************/
/* STM32H7xx Peripheral Interrupt Handlers                                    */
/* Add here the Interrupt Handlers for the used peripherals.                  */
/* For the available peripheral interrupt handler names,                      */
/* please refer to the startup file (startup_stm32h7xx.s).                    */
/******************************************************************************/
/**
  * @brief  This function is executed in case of complition.
  * @param  MDMA_HandleTypeDef * hmdma
  * @retval None
  */
void HAL_DMA_XferCpltCallback (DMA_HandleTypeDef * hddma){
    HAL_DMA_XferCpltCallback_value=1;
}
/**
  * @brief  This function is executed in case of error.
  * @param  MDMA_HandleTypeDef * hmdma
  * @retval None
  */
void HAL_DMA_XferErrorCallback (DMA_HandleTypeDef * hddma){
    HAL_DMA_XferErrorCallback_value=1;
}

/**
  * @brief This function handles DMA1 stream0 global interrupt.
  */
void DMA2_Stream1_IRQHandler(void){
    HAL_DMA_IRQHandler(&hd_m2m_dma);
    DMA2_Stream1_IRQHandler_value=1;
}
/*void DMA1_Stream0_IRQHandler(void){
    HAL_DMA_IRQHandler(&hd_m2m_dma);
    DMA1_Stream0_IRQHandler_value=1;
}*/

/*void DMA_IRQHandler(DMA_HandleTypeDef* hdma){
    DMA_IRQHandler_value=1;
}*/


/**********************************************************************************************
*
*       main function
*
************************************************************************************************/

int main(void){
    
         
    uint8_t a,b,c,d=0;
    uint8_t mclk;
    uint8_t unlimited=0;
    int res;
    uint8_t SLEEPN_flag=0;
    uint8_t PBP_flag=0;
    uint8_t OEN_flag=0;
    int status=0;
    int byte_sent;
    char host_cmd[IN_MSG_LEN+1];
    int loopcount=0;
    int button_pushed=0;
    
    //ethernet 
    char rbuffer[IN_MSG_LEN+1];
    char * pch;
    int rcount;
    int data=0;
    int add=0;
    int readvalue=0;
    int i=0;
    int sizetosent=IN_MSG_LEN;

    
    //***********************************************
    /* Initialize all configured peripherals - First thing to do  */ 
    //***********************************************
    HAL_Init();
    // general purpose IO
    MX_GPIO_Init();
    // digital camera interface
    
    //************************************************
    // config serial print
    //************************************************
    pc.baud(115200);//Set baudrate here. 
    pc.printf("**********************************\r\n CIS001  \r\n**********************************\r\n");
    pc.printf("Nucleo CPU SystemCoreClock is %d MHz\r\n", SystemCoreClock/1000000);
    
    MX_DMA_Init();
    // flexible memory controller
    MX_DCMI_Init_10b();
    // direct memory access
    
    
    //***********************************************
    /* Disable/Enable the CPU Cache */ 
    //***********************************************
    
    // must clean Dcache before disabling;
    SCB_CleanDCache();
    SCB_DisableICache();
    SCB_DisableDCache();
    
    //SCB_EnableICache();
    //SCB_EnableDCache();
        
    
    //************************************************
    // reset leds
    //************************************************
    led1=0;
    led2=0;
    led3=0;
    
    //************************************************
    // init pointers
    //************************************************
    pc.printf("**********************************\r\n");
    pc.printf("Initialising pointer with malloc...\r\n");     
    print_memory_info();
    int random_memset= (rand()%3) ;
    FRAME_BUFFER=(char *) malloc( frame_bsize_QVGA_10b*sizeof(char));
    memset((void *)FRAME_BUFFER,random_memset,(size_t) frame_bsize_QVGA_10b); 
    print_memory_info();

    //initialize commandbuffer pointer
    commandbuffer=(char *) malloc((IN_MSG_LEN+1)*sizeof(char));
    commandbuffertemp=(char *) malloc((IN_MSG_LEN+1)*sizeof(char));
    pc.printf("done\r\n");
    
    
    //************************************************
    // test  DMA
    //************************************************
    if(TEST_DMA){
        pc.printf("**********************************\r\n");
        pc.printf("testing Mem2Mem DMA : writing from secondary SRAM to secondary SRAM\r\n");
        
        int debug_dma=0;
        const int buff_size=16384; // word size
        uint32_t* DMATestPatternAddresss= (uint32_t *) (0x30000000);
        uint32_t* DMAReadAddress= (uint32_t *) (0x30000000+buff_size*4);
        int nb_error_dma=0;
        char pattern[4]={0x00,0x55,0xaa,0xFF};
        uint32_t errordma;
        HAL_DMA_StateTypeDef state_dma;
        HAL_StatusTypeDef res_dma;
        
        for (int i=0;i<4;i++){
            //set pattern & clean dest buffer
            memset((void *) DMATestPatternAddresss, (int) pattern[i], (size_t) (buff_size*sizeof(uint32_t)/sizeof(char)) );
            memset((void *) DMAReadAddress, (int) 0x01, (size_t) (buff_size*sizeof(uint32_t)/sizeof(char)) );
            
            if(debug_dma){
                errordma = HAL_DMA_GetError (&hd_m2m_dma);
                state_dma =  HAL_DMA_GetState (&hd_m2m_dma);
                pc.printf("\n\r");
                print_HAL_DMA_error_code(errordma);
                print_HAL_DMA_status_code(state_dma);
            }
            
            //reset interrupt variable
            DMA2_Stream1_IRQHandler_value=0;
            HAL_DMA_XferErrorCallback_value=0;
            HAL_DMA_XferCpltCallback_value=0;
            
            res_dma= HAL_DMA_Start_IT(&hd_m2m_dma, (uint32_t) DMATestPatternAddresss, (uint32_t) DMAReadAddress, (uint32_t) buff_size);
            if(debug_dma){
                errordma = HAL_DMA_GetError (&hd_m2m_dma);
                state_dma =  HAL_DMA_GetState (&hd_m2m_dma);
                pc.printf("\n\r");
                print_HAL_status_code(res_dma);
                print_HAL_DMA_error_code(errordma);
                print_HAL_DMA_status_code(state_dma);
            }
            
            while (  !(DMA2_Stream1_IRQHandler_value|| HAL_DMA_XferCpltCallback_value || HAL_DMA_XferErrorCallback_value)){
                 if(debug_dma){
                     pc.printf(" %i %i %i\r\n",DMA2_Stream1_IRQHandler_value,HAL_DMA_XferCpltCallback_value,HAL_DMA_XferErrorCallback_value);
                    wait_us(100000);
                }
            }
            if(HAL_DMA_XferErrorCallback_value){
                    pc.printf("DMA error interrupt\n\r"); 
            }  
            if(debug_dma){
                pc.printf("dma exit: dma2s1-%i CmpltCB-%i ErrorCB-%i\r\n",DMA2_Stream1_IRQHandler_value,HAL_DMA_XferCpltCallback_value,HAL_DMA_XferErrorCallback_value);
                errordma = HAL_DMA_GetError (&hd_m2m_dma);
                state_dma =  HAL_DMA_GetState (&hd_m2m_dma);
                print_HAL_DMA_error_code(errordma);
                print_HAL_DMA_status_code(state_dma);
                pc.printf("\n\r");
            }
    
            //check result
            for (int j=0;j<buff_size;j++){
                if(debug_dma && j<10){
                    pc.printf("%u == %u\r\n",*(DMATestPatternAddresss+j),*(DMAReadAddress+j));
                }
                if(*(DMATestPatternAddresss+j)!= *(DMAReadAddress+j)){
                    nb_error_dma++;  
                }   
            }
            pc.printf("%i/%i error(s) in DMA test %i\r\n",nb_error_dma,buff_size,i);
            nb_error_dma=0;
            //wait_us(10000);
        }
    }
        
    
    //************************************************
    // init spi
    //************************************************
    pc.printf("**********************************\r\n");
    pc.printf("Confirguring the SPI...");   
    // Setup the spi for 16 bit data (2x8), high steady state clock,second edge capture, with a 5MHz clock rate
    /*  mode | POL PHA
        -----+--------
          0  |  0   0
          1  |  0   1
          2  |  1   0
          3  |  1   1*/
    spi.format(16,0);
    spi.frequency(100000);
    
    //start generating MCLK
    uint32_t half_periode=4;
    //MCLK.prescaler(1);
    //MCLK.period_ticks(9);
    //MCLK.pulsewidth_ticks(half_periode);
    //mclk=1;
    pc.printf("done\r\n");
    pc.printf("Testing the SPI...\r\n"); 
    a=TASK_TEST_SPI();                     
    if (a==0){
        pc.printf("Test spi OK :) \r\n");
    }else{
        pc.printf("Test spi KO :( \r\n");    
    }

    
    
    
    //************************************************
    //reset & init CIS001
    //************************************************
    pc.printf("**********************************\r\n");
    pc.printf("reseting image sensor...");
    
    TASK_INIT_SENSOR();
    
    pc.printf("done\r\n");
 
    //************************************************
    // Ethernet & socket stuff
    //************************************************
    pc.printf("**********************************\r\n");
    pc.printf("Connecting Ethernet cable....\r\n");
    eth.connect();
    SocketAddress sockaddr;
    const char *mac = eth.get_mac_address();
    const char* ip = eth.get_ip_address();
    pc.printf("MAC Address is %s\r\n", mac ? mac : "No Mac");
    pc.printf("IP address is: %s\r\n", ip ? ip : "No IP");
    pc.printf("**********************************\r\n");
    
    //************************************************
    //open a new socket for printing information & debug
    //************************************************
    status=cs.open(&eth);
    if(status != 0){
        pc.printf("error open com interface\r\n");
        cs.close();
        return 1;
    }
    else{
        pc.printf("comunication socket open");
    }
    
    status=cs.connect(ServerIP, portnumber_com);
    if(status !=0){
        pc.printf("\r\nerror open com socket\r\n");
        cs.close();
        return 1;
    }else{
        pc.printf(" and connected\r\n");
    }
    
    //************************************************
    //open a new socket for data and command
    //************************************************
    status=socket.open(&eth);
    if(status != 0){
        //myprint("*error open interface\r\n");
        pc.printf("failed to Open socket\n\r");
        socket.close();
        return 1;
    }else{
        pc.printf("data socket open ");
    }
    
    status=socket.connect(ServerIP, portnumber);
    if(status !=0){
        pc.printf("\r\nfailed to connect to server\n\r");
        socket.close();
        return 1;
    }else{
        pc.printf(" and connected\r\n");
    }
    
    //************************************************
    // set socking as non blocking and set timer.
    // allows to do something else than waiting for messages
    //************************************************
    socket.set_blocking(false); // non blocking 
    socket.set_timeout(1);       // Timeout after (1)ms
    pc.printf("**********************************\r\n");
    
    
    //************************************************
    // Infinite loop
    //************************************************
    pc.printf("main loop\r\n");
    while (1){
                
        led2= !led2;
        loopcount++;
        //************************************************
        // check if DCMI git an error
        //************************************************
        if ((HAL_DCMI_ErrorCallback_value != 0) || (HAL_DCMI_IRQHandler_value != 0) || (DMA1_Stream0_IRQHandler_value==1)){
            //reset flags
            HAL_DCMI_ErrorCallback_value=0;
            HAL_DCMI_IRQHandler_value=0;
            DMA1_Stream0_IRQHandler_value=0;
            
            
            // deals with the error 
            print_DCMI_state_code(HAL_DCMI_GetState(&hdcmi));
            print_DCMI_error_code(HAL_DCMI_GetError(&hdcmi));
            pc.printf(" %i line %i frame\r\n",line_read,frame_read);
            pc.printf("%i XferCount\r\n",hdcmi.XferCount);
            pc.printf("%i XferSize\r\n",hdcmi.XferSize);
            pc.printf("%i XferTransferNumber\r\n",hdcmi.XferTransferNumber);
            pc.printf("%x pBuffPtr\r\n",hdcmi.pBuffPtr);
            pc.printf("%i ErrorCode\r\n",hdcmi.ErrorCode);
        }
        
        //************************************************
        // check if there is a frame ready to be sent
        //************************************************
        if(line_read != 0){
            pc.printf("%i line read\r\n",line_read);    
        }
        if(frame_ready_to_send==1){
            frame_ready_to_send=0;
            pc.printf("ready to send frame: %i \r\n",line_read);
            line_read=line_read;
            send_frame_ethernet_nohandshake_while();
            
        }
        //************************************************
        // blink led every 1024 loop in the main loop
        //************************************************
        if(loopcount==1024){    // more or less evey second
            led1=!led1;
            loopcount=0;   
        }
        
        //************************************************
        // do soemthing when button is pressed (pressed = active low)
        //************************************************
        if(button_capture==0 && button_pushed==0){
            pc.printf("bc\n\r");
            button_pushed=1;
            
            // do something here
            CAPTURE=1;
            wait_us(500);
            CAPTURE=0;
            
        }else if(button_capture==1 && button_pushed==1){
            button_pushed=0;
        }
        

        //************************************************
        // check if we receiveid a message (non bloacking, timeout=1ms)
        //************************************************
        rcount = socket.recv(&rbuffer, sizeof rbuffer);
        if(rcount>0){
            //************************************************
            // something was received :)
            //************************************************
            pc.printf("recv %d bytes [%.*s]\r\n", rcount, strstr(rbuffer, "\n") - rbuffer-1, rbuffer);  // printr xx bytes of rbuffer computed by strstr(x)-x

            pch = strtok (rbuffer," ");
            
            if (pch != NULL) {
                //pc.printf("%s\r\n", pch);
                 
                if (strcmp (pch,"write")==0 || strcmp (pch,"WRITE")==0){
                    
                    pch = strtok (NULL, " ");
                    data=atoi(pch);
                    pch = strtok (NULL, " ");
                    add=atoi(pch);
                    TASK_SPI_WRITE(add,data);
                    
                    sprintf(commandbuffertemp, "done writing %d at %d", data, add);
                    sprintf(commandbuffer,OUT_MSG_LEN,commandbuffertemp);
                    byte_sent=cs.send(commandbuffer,strlen(commandbuffer));
                    //pc.printf("[%s]_-_%d\n\r",commandbuffer,byte_sent);
                    
                }else if (strcmp (pch,"read")==0 || strcmp (pch,"READ")==0 ){
                    
                    pch = strtok (NULL, " ");
                    add=atoi(pch);
                    readvalue = TASK_SPI_READ(add);
                    
                    sprintf(commandbuffertemp, "%d/%d", readvalue,add);
                    sprintf(commandbuffer,OUT_MSG_LEN,commandbuffertemp);
                    byte_sent=socket.send(commandbuffer,strlen(commandbuffer));
                    //pc.printf("[%s]_-_%d\n\r",commandbuffer,byte_sent);
                    
                    sprintf(commandbuffertemp, "done reading %d at %d", readvalue, add);
                    sprintf(commandbuffer,OUT_MSG_LEN,commandbuffertemp);
                    byte_sent=cs.send(commandbuffer,strlen(commandbuffer));
                    //pc.printf("[%s]_-_%d\n\r",commandbuffer,byte_sent);
                    
                }else if (strcmp (pch,"capture")==0 ||strcmp (pch,"CAPTURE")==0){
                    // check size of image to be received
                    pch = strtok (NULL, " ");
                    pc.printf("[%s]\n\r",pch);
                    // PAS OP !
                    //imSize=atoi(pch);
                    imSize=frame_bsize_10b;
                    sprintf(commandbuffertemp, "trying to capture image of %d bytes...", imSize);
                    sprintf(commandbuffer,OUT_MSG_LEN,commandbuffertemp);
                    byte_sent=cs.send(commandbuffer,strlen(commandbuffer));
                    
                    //start DCMI
                    start_capture();
                    //start capture
                    wait_us(100);
                    CAPTURE=1;
                    wait_us(100);
                    CAPTURE=0;
                    wait_us(100);

                    // if we want to output a dum frame
                    if(DEBUG==1){
                        format_frame(imSize);
                        byte_sent=send_frame_ethernet_nohandshake_while();
                        //sprintf(commandbuffertemp, "sent image of %d bytes/%d bytes", byte_sent,imSize);
                        //sprintf(commandbuffer,OUT_MSG_LEN,commandbuffertemp);
                        //byte_sent=cs.send(commandbuffer,strlen(commandbuffer));
                        //pc.printf("[%s]_-_%d\n\r",commandbuffer,byte_sent);
                    }                                   
                    
                }else if (strcmp (pch,"reset")==0 ||strcmp (pch,"RESET")==0){
                    TASK_RSTN_SENSOR();  
                                
                    sprintf(commandbuffertemp, "done reseting chip");
                    sprintf(commandbuffer,OUT_MSG_LEN,commandbuffertemp);
                    byte_sent=cs.send(commandbuffer,strlen(commandbuffer));
                    //pc.printf("[%s]_-_%d\n\r",commandbuffer,byte_sent);
                    
                }else if (strcmp (pch,"test_spi")==0 ||strcmp (pch,"TEST_SPI")==0){
                    a=TASK_TEST_SPI();  
                                
                    if (a==1){
                        sprintf(commandbuffertemp, "test spi OK");
                    }else{
                        sprintf(commandbuffertemp, "test spi KO");    
                    }
                    sprintf(commandbuffer,OUT_MSG_LEN,commandbuffertemp);
                    byte_sent=cs.send(commandbuffer,strlen(commandbuffer));
                    
                }else if (strcmp (pch,"exit")==0 ||strcmp (pch,"EXIT")==0){             
                    sprintf(commandbuffer, OUT_MSG_LEN,"close com and data sockets");
                    byte_sent=cs.send(commandbuffer,strlen(commandbuffer));
                    //pc.printf("[%s]_-_%d\n\r",commandbuffer,byte_sent);
                    status=socket.close();
                    status=cs.close();
    
                }else{
                    sprintf(commandbuffer, OUT_MSG_LEN,"command not recoginzed");
                    byte_sent=cs.send(commandbuffer,strlen(commandbuffer));
                    //pc.printf("[%s]_-_%d\n\r",commandbuffer,byte_sent);
                }
            } else{ //tok is null
                    sprintf(commandbuffer,  OUT_MSG_LEN,"empty tok");
                    byte_sent=cs.send(commandbuffer,strlen(commandbuffer));
                    //pc.printf("[%s]_-_%d\n\r",commandbuffer,byte_sent);    
            }  
            
        }else{  // non blocking timed out and received <0
        
            //sprintf(commandbuffer, "empty token\r\n");
            //myprint(commandbuffer);
            if(pc.readable()){
                pc.scanf("%s", (char *) &host_cmd);
                pch = strtok (rbuffer," ");
                if (strcmp(host_cmd,"port")==0 || strcmp(host_cmd,"PORT")==0)  {
                    sprintf(commandbuffer, "PORT\r\n");
                    myprint(commandbuffer);
                    
                } else if (strcmp (pch,"write")==0 || strcmp (pch,"WRITE")==0){
                    
                    pch = strtok (NULL, " ");
                    data=atoi(pch);
                    pch = strtok (NULL, " ");
                    add=atoi(pch);
                    TASK_SPI_WRITE(add,data);
                    
                    sprintf(commandbuffer, "write %d at %d", data, add);
                    byte_sent=cs.send(commandbuffer,strlen(commandbuffer));
                    pc.printf("[%s]%d\n\r",commandbuffer,byte_sent);
                    
                }else if (strcmp (host_cmd,"pix")==0 || strcmp (host_cmd,"PIX")==0){
                    sprintf(commandbuffer, "line : %i\n\r frame: %i",line_read,frame_read );
                    byte_sent=cs.send(commandbuffer,strlen(commandbuffer));
                    pc.printf("[%s]%d\n\r",commandbuffer,byte_sent);
                    
                }else if (strcmp (host_cmd,"print")==0 || strcmp (host_cmd,"PRINT")==0){
                    print_start_frame();
                }else{
                    pc.printf("command not reconginzed\n\r");
                }
            }
            
        }  //end non blocking timed-out
    
    } //end while(1) loop
    
} // end main



/***********************************************************************************************
*
*       configuration function
*
************************************************************************************************/


/**
    *@brief Initialize DCMI in 8b mode
    *@param none
    *@return  void
*/
static void MX_DCMI_Init_8b(void)
{

    hdcmi.Instance = DCMI;
    hdcmi.Init.SynchroMode        = DCMI_SYNCHRO_HARDWARE;
    hdcmi.Init.PCKPolarity        = DCMI_PCKPOLARITY_FALLING;
    hdcmi.Init.VSPolarity         = DCMI_VSPOLARITY_HIGH;
    hdcmi.Init.HSPolarity         = DCMI_HSPOLARITY_HIGH;
    
    hdcmi.Init.CaptureRate        = DCMI_CR_ALL_FRAME;
    hdcmi.Init.ExtendedDataMode   = DCMI_EXTEND_DATA_8B;
    hdcmi.Init.JPEGMode           = DCMI_JPEG_DISABLE;
    hdcmi.Init.ByteSelectMode     = DCMI_BSM_ALL;
    hdcmi.Init.ByteSelectStart    = DCMI_OEBS_ODD;
    hdcmi.Init.LineSelectMode     = DCMI_LSM_ALL;
    hdcmi.Init.LineSelectStart    = DCMI_OELS_ODD;
    
    if (HAL_DCMI_Init(&hdcmi) != HAL_OK)
  {
    Error_Handler();
  }
  
  
  /* USER CODE BEGIN DCMI_Init 2 */
    //check status
    print_DCMI_state_code(HAL_DCMI_GetState(&hdcmi));
  /* USER CODE END DCMI_Init 2 */

}


/**
  * @brief DCMI Initialization Function
  * @param None
  * @retval None
  */
static void MX_DCMI_Init_10b(void)
{
  
    /* in CIS doc:
    PCLK: pixel clock. Values of the pixels are changed on posedge of this clock and must be sampled on the negedge.
    VSYNC: This signal goes up at the beginning of the frame, stays up during all transmission and goes down at the end of the frame.
    HSYNC: This signal goes up at the beginning of a row of pixel and goes down at the end of the row.
    */
  
  
  hdcmi.Instance = DCMI;
  hdcmi.Init.SynchroMode    = DCMI_SYNCHRO_HARDWARE;
  hdcmi.Init.PCKPolarity    = DCMI_PCKPOLARITY_FALLING;    //  Values of the pixels are changed on posedge of this clock and must be sampled on the negedge.
  hdcmi.Init.VSPolarity     = DCMI_VSPOLARITY_HIGH;         // Vertical synchronization active High (active low in mdcam & camel)
  hdcmi.Init.HSPolarity     = DCMI_HSPOLARITY_HIGH;         // Horizontal synchronization active High (active low in mdcam & camel)
  
  hdcmi.Init.CaptureRate            = DCMI_CR_ALL_FRAME;
  hdcmi.Init.ExtendedDataMode       = DCMI_EXTEND_DATA_10B;
  hdcmi.Init.JPEGMode               = DCMI_JPEG_DISABLE;
  hdcmi.Init.ByteSelectMode         = DCMI_BSM_ALL;
  hdcmi.Init.ByteSelectStart        = DCMI_OEBS_ODD;
  hdcmi.Init.LineSelectMode         = DCMI_LSM_ALL;
  hdcmi.Init.LineSelectStart        = DCMI_OELS_ODD;
  
  if (HAL_DCMI_Init(&hdcmi) != HAL_OK)
  {
    Error_Handler();
  }
  
    /* USER CODE BEGIN DCMI_Init 2 */
    //check status
    pc.printf("%i XferCount\r\n",hdcmi.XferCount);
    pc.printf("%i XferSize\r\n",hdcmi.XferSize);
    pc.printf("%i XferTransferNumber\r\n",hdcmi.XferTransferNumber);
    pc.printf("%i pBuffPtr\r\n",hdcmi.pBuffPtr);
    pc.printf("%i ErrorCode\r\n",hdcmi.ErrorCode);
    print_DCMI_state_code(HAL_DCMI_GetState(&hdcmi));
  /* USER CODE END DCMI_Init 2 */

}




/**
  * @brief Enable DMA controller clock
  * @param None
  * @retval None
  */
static void MX_DMA_Init(void) 
{
  
    /* DMA controller clock enable */
    __HAL_RCC_DMA1_CLK_ENABLE();
    __HAL_RCC_DMA2_CLK_ENABLE();
    
    if(TEST_DMA==1){
        /* Configure DMA request hd_m2m_dma on DMA2_Stream1 */
        hd_m2m_dma.Init.Request               = DMA_REQUEST_MEM2MEM;
        hd_m2m_dma.Init.Direction             = DMA_MEMORY_TO_MEMORY;
        hd_m2m_dma.Init.PeriphInc             = DMA_PINC_ENABLE;
        hd_m2m_dma.Init.MemInc                = DMA_MINC_ENABLE;
        hd_m2m_dma.Init.PeriphDataAlignment   = DMA_PDATAALIGN_WORD;
        hd_m2m_dma.Init.MemDataAlignment      = DMA_MDATAALIGN_WORD;
        hd_m2m_dma.Init.Mode                  = DMA_NORMAL;
        hd_m2m_dma.Init.Priority              = DMA_PRIORITY_HIGH;
        hd_m2m_dma.Init.FIFOMode              = DMA_FIFOMODE_ENABLE;
        hd_m2m_dma.Init.FIFOThreshold         = DMA_FIFO_THRESHOLD_FULL;
        hd_m2m_dma.Init.MemBurst              = DMA_MBURST_INC4;
        hd_m2m_dma.Init.PeriphBurst           = DMA_MBURST_INC4;
        hd_m2m_dma.Instance = DMA2_Stream1;
        if (HAL_DMA_Init(&hd_m2m_dma) != HAL_OK) {
        Error_Handler( );
        }
      
        //thom : register callback
        HAL_DMA_RegisterCallback (&hd_m2m_dma,HAL_DMA_XFER_CPLT_CB_ID, HAL_DMA_XferCpltCallback);
        HAL_DMA_RegisterCallback (&hd_m2m_dma,HAL_DMA_XFER_ERROR_CB_ID, HAL_DMA_XferErrorCallback);
    }


    /* DMA interrupt init */
    
    //DCMI
    /* DMA1_Stream0_IRQn interrupt configuration */
    HAL_NVIC_SetPriority(DMA1_Stream0_IRQn, 0x00, 0);
    HAL_NVIC_EnableIRQ(DMA1_Stream0_IRQn);  
  
    
    if(TEST_DMA==1){
        //MEM2MEM DMA
        /* NVIC configuration for DMA transfer complete interrupt*/
        HAL_NVIC_SetPriority(DMA2_Stream1_IRQn, 0x0F, 0);
        HAL_NVIC_EnableIRQ(DMA2_Stream1_IRQn); 
    }
  

}

/**
  * @brief GPIO Initialization Function
  * @param None
  * @retval None
  */
static void MX_GPIO_Init(void)
{
  
  GPIO_InitTypeDef GPIO_InitStruct = {0};

  /* GPIO Ports Clock Enable */
  __HAL_RCC_GPIOE_CLK_ENABLE();
  __HAL_RCC_GPIOC_CLK_ENABLE();
  __HAL_RCC_GPIOF_CLK_ENABLE();
  __HAL_RCC_GPIOH_CLK_ENABLE();
  __HAL_RCC_GPIOA_CLK_ENABLE();
  __HAL_RCC_GPIOB_CLK_ENABLE();
  __HAL_RCC_GPIOD_CLK_ENABLE();
  __HAL_RCC_GPIOG_CLK_ENABLE();

}



/**
  * @brief  This function is executed in case of error occurrence.
  * @retval None
  */
void Error_Handler(void)
{
  /* USER CODE BEGIN Error_Handler_Debug */
  /* User can add his own implementation to report the HAL error return state */

  /* USER CODE END Error_Handler_Debug */
}

#ifdef  USE_FULL_ASSERT
/**
  * @brief  Reports the name of the source file and the source line number
  *         where the assert_param error has occurred.
  * @param  file: pointer to the source file name
  * @param  line: assert_param error line source number
  * @retval None
  */
void assert_failed(uint8_t *file, uint32_t line)
{ 
  /* USER CODE BEGIN 6 */
  /* User can add his own implementation to report the file name and line number,
     tex: printf("Wrong parameters value: file %s on line %d\r\n", file, line) */
  /* USER CODE END 6 */
}
#endif /* USE_FULL_ASSERT */