#include "mbed.h"

/**
@param none
@return  void
@brief print the start of the frame stored in frame buffer
*/

extern Serial pc;

void print_HAL_status_code(HAL_StatusTypeDef val){
    
    if(val == HAL_OK){
          pc.printf("HAL status : HAL_OK\r\n");
    }else if (val ==HAL_ERROR){
        pc.printf("HAL status : HAL_ERROR\r\n");
    }else if (val ==HAL_BUSY){
        pc.printf("HAL status : HAL_BUSY\r\n");
    }else if (val ==HAL_TIMEOUT){
        pc.printf("HAL status : HAL_TIMEOUT\r\n");
    }else{
        pc.printf("HAL status : undefined status code\r\n");
    } 
    
}

/**
@param none
@return  void
@brief print the start of the frame stored in frame buffer
*/
void print_DCMI_error_code(uint32_t errorCode){
 
    if(errorCode == HAL_DCMI_ERROR_NONE){
        pc.printf("DCMI error: No error\r\n");
    }else if(errorCode == HAL_DCMI_ERROR_OVR){
        pc.printf("DCMI error: Overrun error\r\n");
    }else if(errorCode == HAL_DCMI_ERROR_SYNC){
        pc.printf("DCMI error: Synchronization error\r\n");
    }else if(errorCode == HAL_DCMI_ERROR_TIMEOUT){
        pc.printf("DCMI error: Timeout error\r\n");
    }else if(errorCode == HAL_DCMI_ERROR_DMA){
        pc.printf("DCMI error: DMA error\r\n");
    }else {
        pc.printf("DCMI error: error code not recognized\r\n");
    }
}

/**
@param none
@return  void
@brief print the start of the frame stored in frame buffer
*/
void print_DCMI_state_code(HAL_DCMI_StateTypeDef state){
 
    if(state == HAL_DCMI_STATE_RESET){
        pc.printf("DCMI state: reset\r\n");
    }else if(state == HAL_DCMI_STATE_READY){
        pc.printf("DCMI state: ready\r\n");
    }else if(state == HAL_DCMI_STATE_BUSY){
        pc.printf("DCMI state: busy\r\n");
    }else if(state == HAL_DCMI_STATE_TIMEOUT){
        pc.printf("DCMI state: Timeout\r\n");
    }else if(state == HAL_DCMI_STATE_ERROR){
        pc.printf("DCMI state: error\r\n");
    }else if(state == HAL_DCMI_STATE_SUSPENDED){
        pc.printf("DCMI state: sespended\r\n");
    }else {
        pc.printf("DCMI state: state code not recognized\r\n");
    }
}

/**
@param none
@return  void
@brief print the start of the frame stored in frame buffer
*/
void print_HAL_DMA_error_code(uint32_t error_code){

    if(error_code==HAL_DMA_ERROR_NONE){
        pc.printf("DMA error :  no error\r\n");
    }else if(error_code==HAL_DMA_ERROR_TE){
        pc.printf("DMA error :  Transfer error\r\n");
    }else if(error_code==HAL_DMA_ERROR_FE){
        pc.printf("DMA error :  FIFO error\r\n");
    }else if(error_code==HAL_DMA_ERROR_DME){
        pc.printf("DMA error :  Direct Mode error\r\n");
    }else if(error_code==HAL_DMA_ERROR_TIMEOUT){
        pc.printf("DMA error :  Timeout error\r\n");
    }else if(error_code==HAL_DMA_ERROR_PARAM){
        pc.printf("DMA error :  Parameter error\r\n");
    }else if(error_code==HAL_DMA_ERROR_NO_XFER){
        pc.printf("DMA error :  Abort requested with no Xfer ongoing\r\n");
    }else if(error_code==HAL_DMA_ERROR_NOT_SUPPORTED){
        pc.printf("DMA error :  Not supported mode\r\n");
    }else if(error_code==HAL_DMA_ERROR_SYNC){
        pc.printf("DMA error :  DMAMUX sync overrun error\r\n");
    }else if(error_code==HAL_DMA_ERROR_REQGEN){
        pc.printf("DMA error :  DMAMUX request generator overrun error\r\n");
    }else if(error_code==HAL_DMA_ERROR_BUSY){
        pc.printf("DMA error :  DMA Busy error\r\n");
    }else{
        pc.printf("DMA error : undefined error code\r\n");
    }   
}

/**
@param none
@return  void
@brief print the start of the frame stored in frame buffer
*/
void print_HAL_DMA_status_code(HAL_DMA_StateTypeDef state_code){  
    
    if(state_code == HAL_DMA_STATE_RESET){
        pc.printf("DMA state  : reset - DMA not yet initialized or disabled\r\n");
     } else if(state_code== HAL_DMA_STATE_READY){
        pc.printf("DMA state  : ready - DMA initialized and ready for use\r\n");
     } else if(state_code== HAL_DMA_STATE_BUSY){
        pc.printf("DMA state  : busy - DMA process is ongoing \r\n");
     } /*else if(state_code== HAL_DMA_STATE_TIMEOUT){
        pc.printf("DMA state  : DMA timeout state\r\n");
     } */else if(state_code== HAL_DMA_STATE_ERROR){
        pc.printf("DMA state  : DMA error state\r\n");
     } else if(state_code== HAL_DMA_STATE_ABORT){
        pc.printf("DMA state  : DMA Abort state\r\n");
     } else {
         pc.printf("DMA state  : undefined state code\r\n");
    }  
}