//IOT Class Project.  June 9, 2014.  Tom Sullivan

#include "mbed.h"
#include "LM75B.h"
#include "C12832_lcd.h"
#include "EthernetInterface.h"
#include "NTPClient.h"
#include "MMA7660.h"
#include "Websocket.h"

C12832_LCD lcd;
DigitalOut led1(LED1);
MMA7660 MMA(p28, p27);
AnalogIn pot20(p20);
AnalogIn pot19(p19);
AnalogIn ain17(p17);
AnalogOut aout18(p18);
BusIn joy(p15,p12,p13,p16); //DigitalIn joyUp(p15), joyDown(p12), joyLeft(p13), joyRight(p16);

Ticker myTicker1;
EthernetInterface eth;
NTPClient ntp;
time_t currentTime;
char dataOut[128];

//Temperature variables
LM75B tmp(p28,p27);
float tempNow, tempHI=80,tempLO=60;
float coolHyst = 1, heatHyst = 1;
int Pressing = 0;
int heatOn = 0, coolOn = 0; //disabled = -1, enabled/Off = 0, enabled/On = 1

//set flag that indicates it is time to output data to the web socket
void sendData() {
    led1 = 1; //!led1;
}

int main()
{
    printf("\n\r-----Starting Project-----\n\r");
    //Connect to ethernet. Use DHCP. **********************
    eth.init();                    
    eth.connect();
    printf("IP Address is %s\n\r", eth.getIPAddress());
    
    
    //Connect to mbed websocket server
    printf("Connecting to mbed websocket server channel 445\n\r");
    Websocket ws("ws://sockets.mbed.org/ws/445/rw");
    //Websocket ws("17.244.173.207");//ws://sockets.mbed.org/ws/445/rw");
    ws.connect();
    printf("Done connecting\n\r");
    
    //Attach ticker with X second timing
    printf("Setting ticker\n\r");
    myTicker1.attach(&sendData, 0.5); //send data out every half second
    float potOut,senseIn,sigOut;
    
    int i=0;
    while(1) {

        //Print information to LCD
        //lcd.cls();
        //lcd.locate(0,3);

        //If the time is right, send data to the websocket server
        if (led1) {
            i=i+1;
            if (i >= 20) {
                i=0;
            };
 
            //printf("Sending message\n\r");
            //accel_z = MMA.z();
            //sprintf(dataOut,"{\"Temp\":%.1f,\"X\":%.1f,\"Y\":%.1f,\"Z\":%.1f}",tempNow,MMA.x(),MMA.y(),MMA.z());
            potOut=pot19.read();
            senseIn = ain17.read() + 0.1;
            sigOut = ((float)i)/20;
            //printf("%d, %.2f\n\r",i,sigOut);
            sprintf(dataOut,"{\"X\":%.2f,\"Y\":%.2f,\"Z\":%.2f}",potOut,senseIn,sigOut);
            //printf("%s\n\r",dataOut);
            //lcd.cls();
            //lcd.locate(0,3);
            //lcd.printf("Pot19: %.2f\n",potOut);
            //lcd.printf("Sense: %.2f\n",senseIn);
            //lcd.printf("SigOut: %.2f\n",sigOut);
            
            ws.send(dataOut);// %d",heatOn);
            led1 = 0;
        }
    }
}
