//IOT Class, HW7 Program 1.  June 2, 2014.  Tom Sullivan

#include "mbed.h"
#include "LM75B.h"
#include "C12832_lcd.h"
#include "EthernetInterface.h"
#include "NTPClient.h"
#include "MMA7660.h"
#include "Websocket.h"
#include "xively.h"
#include "xi_err.h"
#include "xi_printf.h"
#include <stdarg.h>
#include <stdio.h>


#define XI_FEED_ID 442300006 // set Xively Feed ID (numerical, no quoutes
#define XI_API_KEY "FvameuMiutLFm5O135FCYEQn6okK8gijbsjPXTcSYARgkCYv" // set Xively API key (double-quoted string) 

C12832_LCD lcd;
DigitalOut led1(LED1);
MMA7660 MMA(p28, p27);
AnalogIn pot20(p20);
AnalogIn pot19(p19);
BusIn joy(p15,p12,p13,p16); //DigitalIn joyUp(p15), joyDown(p12), joyLeft(p13), joyRight(p16);

Ticker myTicker1;
EthernetInterface eth;
NTPClient ntp;
time_t currentTime;
char dataOut[128];

//Temperature variables
LM75B tmp(p28,p27);
float tempNow, tempHI=80,tempLO=60;
float coolHyst = 1, heatHyst = 1;
int Pressing = 0;
int heatOn = 0, coolOn = 0; //disabled = -1, enabled/Off = 0, enabled/On = 1
int heatControl;

//set flag that indicates it is time to output data to the web socket
void sendData() {
    led1 = 1; //!led1;
}

void mbed_printf( const char* fmt, ...  )
{
    char buffer[ 64 ];
    
    va_list ap;
    va_start( ap, fmt );
    vsnprintf( buffer, 64, fmt, ap );
    va_end( ap );
    
    printf("%s \n\r",buffer );
}

int main()
{
    printf("\n\r-----Starting HW7-1 Thermostat Heat/Cool-----\n\r");
    //Connect to ethernet. Use DHCP. **********************
    eth.init();                    
    eth.connect();
    
    //Get time from NTP server on internet ************************
    printf("Initializing time...\r\n");
    if (ntp.setTime("0.pool.ntp.org") == 0)  //connect to ntp server
    {
      set_time(time(NULL) - 7*60*60);  //correct current time to Pacific Standard Time
      currentTime = time(NULL);        //read corrected time from the system RTC
      printf("Time is set to (PST): %s\r\n", ctime(&currentTime));
    }
    else
    {
      printf("ntp.setTime return not zero");
      printf("Error\r\n");
    } 
    
    //Connect to mbed websocket server
    printf("Connecting to mbed websocket server channel 445\n\r");
    Websocket ws("ws://sockets.mbed.org/ws/445/rw");
    ws.connect();
    printf("Done connecting\n\r");
    
    xi_feed_t feed;
    memset( &feed, NULL, sizeof( xi_feed_t ) );
    
    feed.feed_id = XI_FEED_ID;
    feed.datastream_count = 5;
    
    feed.datastreams[0].datapoint_count = 1;
    xi_datastream_t* temperature_datastream = &feed.datastreams[0];
    strcpy( temperature_datastream->datastream_id, "temperature" );
    xi_datapoint_t* current_temperature = &temperature_datastream->datapoints[0];

    feed.datastreams[1].datapoint_count = 1;
    xi_datastream_t* accelx_datastream = &feed.datastreams[1];
    strcpy( accelx_datastream->datastream_id, "accel_x" );
    xi_datapoint_t* current_accelx = &accelx_datastream->datapoints[0];
    
    feed.datastreams[2].datapoint_count = 1;
    xi_datastream_t* accely_datastream = &feed.datastreams[2];
    strcpy( accely_datastream->datastream_id, "accel_y" );
    xi_datapoint_t* current_accely = &accely_datastream->datapoints[0];
    
    feed.datastreams[3].datapoint_count = 1;
    xi_datastream_t* accelz_datastream = &feed.datastreams[3];
    strcpy( accelz_datastream->datastream_id, "accel_z" );
    xi_datapoint_t* current_accelz = &accelz_datastream->datapoints[0];
    
    feed.datastreams[4].datapoint_count = 1;
    xi_datastream_t* heatcontrol_datastream = &feed.datastreams[4];
    strcpy(heatcontrol_datastream->datastream_id, "HeatControl" );
    xi_datapoint_t* current_heatcontrol = &heatcontrol_datastream->datapoints[0];
    // create the cosm library context
    xi_context_t* xi_context
        = xi_create_context( XI_HTTP, XI_API_KEY, feed.feed_id );

    // check if everything works
    if( xi_context == NULL ) {return -1;}
    
    printf("feed:%d datastreams:[%s,%s,%s,%s]\n\r", feed.feed_id,
                    accelx_datastream->datastream_id,
                    accely_datastream->datastream_id,
                    accelz_datastream->datastream_id,
                    heatcontrol_datastream->datastream_id);
    
    //Attach ticker with 10 second timing
    printf("Setting ticker\n\r");
    myTicker1.attach(&sendData, 10); //10*60
    
    while(1) {
        //Get temp and Hi/Lo setting
        tempNow = 32+(9/5)*tmp.temp();
        tempHI = 50+40*pot19.read();
        tempLO = 40+40*pot20.read();
        
        //Use joystick to enable and disable heater and cooler
        //Cooler: up is enable, down is disable
        //Heater: left is enable, right is disable
        if (joy == 0x0) {  //joystick not being used currently
            Pressing = 0;  //release memory of being pressed
        } else if (Pressing == 0) {  //if joystick is being pressed (and this is the start of the press)
            Pressing = 1;  //set memory of being pressed so next cycle through doesn't repeat actions
            //process joystick press
            switch (joy) { //which button?
                case 0x1:  //up
                    if (coolOn < 0) { //if cooler is disabled, enable it
                        coolOn = 0;   
                    }
                    break;
                case 0x2:  //down
                    coolOn = -1;
                    break;
                case 0x4:  //left
                    if (heatOn < 0) { //if heat is disabled, enable it
                        heatOn = 0;
                    }
                    break;
                case 0x8:  //right
                    heatOn = -1;   //disable heat
                    break;
            }
        };
        
        //Turn on heat if temperature too low
        //Turn on cooler if temperature too high
        if (heatOn >= 0) { //if heat enabled
            if (tempNow < tempLO+heatHyst) {
                heatOn = 1;
                heatHyst = 1;//give offset so that heater will stay on 1 degree higher than target
            }
            else {
                heatOn = 0;
                heatHyst = -1; //give offset so that heater will stay off 1 degree lower than target
            }
        }
        if (coolOn >= 0) { //if cooler enabled
            if (tempNow > tempHI+coolHyst) {
                coolOn = 1;
                coolHyst = -1;//give offset so that cooler will stay on 1 degree lower than target
            }
            else {
                coolOn = 0;
                coolHyst = 1; //give offset so that cooler will stay off a bit longer
            }
        }
        
        //Print information to LCD
        lcd.cls();
        lcd.locate(0,3);
        lcd.printf("Temp: %.1f, Hi/LO: %.1f/%.1f\n",tempNow,tempHI,tempLO);
        lcd.printf("%s", ctime(&currentTime));
        lcd.printf("heatOn: %d, coolOn: %d",heatOn,coolOn);
        
        //If the time is right, send data to the websocket server and Xively
        if (led1) {
            printf("Sending message\n\r");
            xi_set_value_f32(current_temperature, tempNow);
            xi_set_value_f32(current_accelx, MMA.x());
            xi_set_value_f32(current_accely, MMA.y());
            xi_set_value_f32(current_accelz, MMA.z());

    //current_led = &led_datastream->datapoints[0];   
        //int led_value = current_led->value.i32_value;
        //mbed_printf("%d",led_value); 
            //current_heatcontrol = &heatcontrol_datastream->datapoints[0];
            int heatControl = current_heatcontrol->i32_value;
            
            xi_feed_update(xi_context, &feed);
            printf("xi_feed updated.\n\r");
            xi_datastream_get(xi_context, feed.feed_id, heatcontrol_datastream->datastream_id, heatcontrol_datastream->datapoints);
           // heatControl = heatcontrol_datastream->datapoints[0];//current_heatcontrol.value;
            mbed_printf("HeatControl: %d...\n",heatcontrol_datastream->datapoints[0]);
            if (heatControl == -1) {
                heatOn = -1;
            }
            else if (heatControl == 1) {
                coolOn = -1;
            }
        
            sprintf(dataOut,"{\"Temp\":%.1f,\"X\":%.1f,\"Y\":%.1f,\"Z\":%.1f}",tempNow,MMA.x(),MMA.y(),MMA.z());
            printf("%s\n\r",dataOut);
            ws.send(dataOut);// %d",heatOn);
            led1 = 0;
        }
        wait(0.1);
    }
}
