// Name: T.H. Lu
// Date: 03/27/2014
// Description:
//   Header file for accelestick. Contains all defines and function declarations.
//

#include <stdlib.h>
#include "mbed.h"

#include "MMA7660.h"         // Accelerometer API
#include "C12832_lcd.h"      // LCD API
#include "USBMouseKeyboard.h"// USB Mouse API

#ifndef ACCELESTICK_H
  #define ACCELESTICK_H
 
#define SCALE_X 50      // float to int conversion factor
#define SCALE_Y SCALE_X 
#define SCALE_Z SCALE_X
#define NOISE_FLOOR 0.10*SCALE_X // zero out any integer g value less than NOISE_FLOOR

#define ACCEL_MIN -1.5
#define ACCEL_MAX 1.5

#define CALIB_SMPLS 16   // number of samples used for calibrating accelerometer

// Joystick button values based on joyb declaration
enum {JS_NONE=0, JS_DOWN=1, JS_LEFT=2, JS_CENTER=4, JS_UP=8, JS_RIGHT=16};
enum {LED_LOCK=0, LED_DEBUG, LED_CALIB, LED_ALIVE};

// structure to store max and min g values for debugging
typedef struct s_max_min {
    float max_x, max_y, max_z;
    float min_x, min_y, min_z;
} Max_min_t;

// structure for accelerometer int g values
typedef struct s_int_g {
    int16_t x, y, z;
} G_int_t;

// structure for accelerometer float g values
typedef struct s_float_pos {
    float x, y, z;
} G_float_t;

// structure to store all mouse related data
typedef struct 
{
    int16_t x, y, z;  // x, y, z position
    uint8_t button;   // left button, 1 = left, 2 = center, 4 = middle
    bool dc;          // double click
    int8_t scroll;    // <0 to go up, >0 to go down
} Mouse_state_t;


//--- Functions Declaration ---//

  // scan joystick for mouse buttons and scroll
  void get_joystick_input();
  
  // sample accelerometer values for mouse movement
  void sample_mma();

  // calibrate accelerometer
  void calib_mma(G_int_t current);
  
  // update mouse position and buttons
  void update_mouse();
  
  // print debug messages to USB serial
  void print_debug_msg();
  
  // filter out accelestick noise
  int16_t filter_noise(int16_t const);
  
  // flash specified LED. Needed 2 copies because Ticker cannot attach functions with parameters
  void flash_led2();
  void flash_led3();
  
  // convert floating MMA g value into integer
  G_int_t conv_g2int(G_float_t mma_g);
  
  int8_t init_accelestick();
  void run_accelestick();
  
#endif