//*****************************************************************************
//* SERIAL PORT RECEIVE ATTACH DEMO PROGRAM
//* Simple demo program showing how the serial port "attach()" method is used
//* to interrupt when a character has been received into the USART. 
//*
//* The main() program sets up the serial port baudrate, attaches the
//* function pointer to the function to be called when a character is received
//* on this serial port, and then loops and flashed some LEDs.
//* 
//* Routine "void SerialRecvInterrupt(void)" is invoked anytime a character 
//* has been received by the by the USART. 
//*
//*****************************************************************************
#include "mbed.h"
#include <ctype.h>

#define BFR_SIZE         32         // Needs to be a power of two.
#define BFR_WRAP_MASK  0x1F         // Modulo 32

unsigned char rcvBuffer[BFR_SIZE];  // Receive buffer. 
unsigned char inIdx;                // Read by background, written by Int Handler.
unsigned char outIdx;               // Read by Int Handler, written by Background.

DigitalOut led4(LED4);
Serial usbS(USBTX,USBRX);
Serial pins(p9,p10);

//*****************************************************************************
// mc serial receive interrupt handler
//***************************************************************************** 
void rx_interrupt(void) {
    char c;
    led4 = 1;
    usbS.printf("Ack Recieved from Module\n");
    c=pins.getc();
    c=pins.getc();
}
//*****************************************************************************
// Main Program
//*****************************************************************************

int main() {
    int adc_val = rand()%100+1;
    char msg[30];
    
    usbS.printf("Msg Send to Module\n");
    pins.attach(&rx_interrupt,pins.RxIrq);
    
     
    while(1) {
        sprintf(msg,"Adc_val %d\n",adc_val);
        while(!pins.writeable());
        pins.puts(msg);
        wait(2);
        led4 = 0;
    }
}
