#include "mbed.h"
#include "BMP280.h"
#include "DHT.h"
#include "stdio.h"

Timer txTimer, mqTimer;
Serial device(p9, p10);
BMP280 bmpObj(p28, p27);
DHT dhtObj(p21,DHT11);
AnalogIn mqObj(p20);

char sensorConf[4];
char msg[60];

bool tmpFlag = true;    //temperature sensor flag
bool presFlag = true;   //pressure sensor flag
bool co2Flag = true;    //co2 sensor flag
bool humFlag = true;    //humidity sensor flag

bool rxFlag = false;    //recieve packet flag

int bmpTmp,bmpPres,dhtHum,dhtTmp;     //stores bmp280 temperature and sensor value
int avgTmp;                                 //average of bmpTmp and dhtTmp
uint16_t mqCo2;

//enable or desable sensors
void setSensors(void);

//get temperature and pressure values from bmp280
void bmpGetValue(void);

//get temperature and humidity value from dht11
void dhtGetValue(void);

//get airquality value from mq135
void mqGetValue(void);


void rx_interrupt()
{
    int i = 0;

    while(device.readable()){
        sensorConf[i++]= device.getc();
        i++;
        }

    sensorConf[i] = '\0';
    rxFlag = true;

    return;
}

int main()
{
    //device.attach(&rx_interrupt,device.RxIrq);

    bmpObj.initialize();        //initialize bmp280 sensor

    txTimer.start();                //start transmit timer
    mqTimer.start();                //start airquality timer

    while (true) {
        bmpGetValue();              //get value from bmp280 sensor
        dhtGetValue();              //get value from dht11 sensor     

        if (mqTimer.read_ms()>2000) {
            mqGetValue();
            mqTimer.reset();
        }

        if(rxFlag) {
            setSensors();
            rxFlag = false;
        }
        
        if(bmpTmp!=0 && dhtTmp!=0) {

            avgTmp = (bmpTmp + dhtTmp)/2;
        }
        
        if(txTimer.read_ms()>8000) {
            if(device.writeable()) {
                sprintf(msg,"TMP %d PRS d% CO2 d% HUM %d ",avgTmp,bmpPres,mqCo2,dhtHum);
                device.puts(msg);
            }
            txTimer.reset();
        }

        wait(0.5);
    }
}

void bmpGetValue(void)
{
    if(tmpFlag) {
        bmpTmp = bmpObj.getTemperature();
    }
    if(presFlag) {
        bmpPres = bmpObj.getPressure();
    }
}

void dhtGetValue(void)
{
    int s = dhtObj.readData();
    wait(0.5);
    if (s == ERROR_NONE) {
        if(humFlag) {
            dhtHum  = dhtObj.ReadHumidity();
        }
        if(tmpFlag) {
            dhtTmp  = dhtObj.ReadTemperature(CELCIUS);
        }
    }
}

void mqGetValue()
{
    if(co2Flag) {
        mqCo2 = mqObj.read_u16();
    }
}

void setSensors(void)
{
    if(sensorConf[0]=='T') {
        if(sensorConf[1]=='0') {
            tmpFlag = false;
            avgTmp = 0;
        } else {
            tmpFlag = true;
        }
    } else if(sensorConf[0]=='P') {
        if(sensorConf[1]=='0') {
            presFlag = false;
            bmpPres = 0;
        } else {
            presFlag = true;
        }
    } else if(sensorConf[0]=='C') {
        if(sensorConf[1]=='0') {
            co2Flag = false;
            mqCo2 = 0;
        } else {
            co2Flag = true;
        }
    } else if(sensorConf[0]=='H') {
        if(sensorConf[1]=='0') {
            humFlag = false;
            dhtHum = 0;
        } else {
            humFlag = true;
        }
    }
}

