#include "mbed.h"

// The following sequence is presented:
// GREEN   - 1 second
// BLUE    - 1 second
// RED     - 1 second
// WHITE   - 1 second
// ALL OFF - 4 seconds


#define OFF         1
#define ON          0
#define TIME        1

DigitalOut myled_blue(LED1);
DigitalOut myled_green(LED2);
DigitalOut myled_red(LED3);
void all_off(void);
void all_on(void);

int main()
{
    while(1) {
        all_off();
        myled_green = ON;
        wait(TIME);
        all_off();

        myled_blue = ON;
        wait(TIME);
        all_off();

        myled_red = ON;
        wait(TIME);
        all_off();

        all_on(); //WHITE
        wait(TIME);
        all_off();

        wait(TIME*4);
    }
}

void all_off(void)
{
    myled_green = OFF;
    myled_blue  = OFF;
    myled_red   = OFF;
}

void all_on(void)
{
    myled_green = ON;
    myled_blue  = ON;
    myled_red   = ON;
}
