#include "mbed.h"
#include "eeprom.h"
#include "MFRC522.h"
#include "stdlib.h"

//interrupcao botao
InterruptIn button1(PTA13);
InterruptIn button2(PTA17);
InterruptIn button3(PTA16);
DigitalOut led1(LED1);
DigitalOut led2(LED2);       
DigitalOut flash(LED4);
//Timer debounce;

//LCD
#define tuss 2
#define tusl 20
#define tms 2

SPI lcd(PTE3, PTE1, PTE2);
DigitalOut cs(PTE4);
DigitalOut res(PTD5);
DigitalOut dc(PTC12);

//KL25Z Pins for MFRC522 SPI interface
 #define SPI_MOSI    PTC6
 #define SPI_MISO    PTC7
 #define SPI_SCLK    PTC5
 #define SPI_CS      PTC4
// KL25Z Pin for MFRC522 reset
 #define MF_RESET    PTC3
  
//Pinos EEPROM
#define SDA PTC2            // I2C SDA pin
#define SCL PTC1           // I2C SCL pin 
#define EEPROM_CONTROL_BYTE 0xA0
#define I2C_READ 0x01

#define OFF 1
#define ON 0

DigitalOut LedRed   (LED_RED);
DigitalOut LedGreen (LED_GREEN); 
 
EEPROM i2c(SDA, SCL, 0, EEPROM::T24C16);      // T24C01 should work for the 24AA02E48 eeprom
MFRC522    RfChip   (SPI_MOSI, SPI_MISO, SPI_SCLK, SPI_CS, MF_RESET); 
 
//I2C i2c(PTE0, PTE1); // sda, scl on KL25Z
Serial pc(USBTX, USBRX); // tx, rx 

int flag_identificacao=1,flag_cadastro=0,flag_descadastro=0,flag_mudamodo=0;

void init_LCD(){
    res = 0;
    dc = 0;
    cs = 1;
    wait(0.1);
    res = 1;
   // k = 0;
    cs = 0;
    lcd.write(0x3C);
    wait_us(tuss);
    cs = 1;
    wait_ms(tms);
    cs = 0;
    lcd.write(0x0C);
    wait_us(tuss);
    cs = 1;
    wait_us(tusl);
    cs = 0;
    lcd.write(0x01);
    wait_us(tuss);
    cs = 1;
    wait_ms(tms);
    cs = 0;
    lcd.write(0x06);
    wait_us(tuss);
    cs = 1;
    wait_ms(tms);    
    dc = 1;
    wait_ms(tms);
    
    return;        
}

/* Função "pula_linha" vai para a linha de baixo do LCD para escrita */
void pula_linha(){    
    dc = 0;
    wait_ms(tms);
    cs = 0;
    lcd.write(0xC0);
    wait_us(tuss);
    cs = 1;
    wait_ms(tms);    
    dc = 1;
    wait_ms(tms);
    
    return;
}    

/* Função "limpa_lcd" limpa a tela do LCD */
void limpa_lcd(void){
    
    dc = 0;
    wait_ms(tms);
    cs = 0;
    lcd.write(0x01);
    wait_us(tuss);
    cs = 1;
    wait_ms(tms);    
    dc = 1;
    wait_ms(tms);
    
    return;
}

/* Função "escreve_lcd" escreve a string passada na linha do LCD */
void escreve_lcd (char *s){       
     
    while(*s){       
        cs = 0;
        lcd.write(*s);
        wait_us(tuss);
        cs = 1;
        wait_ms(tms);
        s++;
    }    
    return ;
}

/* Função "escreve_mem" colaca o dado passado na posição passada */
void escreve_mem(int8_t dado, uint8_t i){
    int8_t buf, elementos;
    
    LedGreen = 0;
    i2c.read(0, elementos); wait_ms(1);
    buf=dado;
    i2c.write(5*elementos+1+i, buf); wait_ms(1); //escreve na memoria o dado passado por referência    
}

/* Função "read_mem" lê a posição requisitada e retorna o seu valor */
char read_mem(uint8_t posicao, uint8_t i){
    char x;
    int8_t buf, elementos;
    
    i2c.read(0, elementos);
    wait_ms(1);
    if (elementos < posicao){
        printf("A posicao requisitada excede o numero de elementos registrados na memoria\n\r");
        return -1;
    }else{
        i2c.read(5*(posicao-1)+1+i, buf); wait_ms(1);  // Lê a posição requisitada e coloca na variável "buf"
        x=buf;
        return x;
    }
}

/* Função "pega_id" pega o ID do cartão aproximado
   copia na string passada  */
void pega_id (char *s){
 
    int i=0;
    int8_t buf=0;
    
    while(true){

        inicio:
        
        if(flag_mudamodo==1)   // Caso o usuário aperte algum botão, sai da função
            return;
        
        if ( ! RfChip.PICC_IsNewCardPresent()){     // Look for new cards
            wait_ms(500);
            goto inicio;  
        }
        if ( ! RfChip.PICC_ReadCardSerial()){     // Select one of the cards

        }
        LedGreen = 0;
        wait(0.3);
        LedGreen = 1;  
        for (i=0; i < RfChip.uid.size; i++){    // Copia o ID do cartão na string passada de parâmetro
            buf=RfChip.uid.uidByte[i];
            *(s+i)=buf;
        }
   
        break ;
    }
    return ;
}    

/* Verifica se o ID passado ja esta na memoria
   Caso ja esteja, o programa retorna k+1. Caso contrario, retorna 0 */
int jaexiste (char *idcartao){
    
    int k,i;
    int8_t buf,elementos;
    char compara[4];

    i2c.read(0, elementos); wait_ms(1);   
    
    for (k=0;k<elementos;k++){ // Laço para andar na memória nos diversos cartões salvos
        for (i=0; i < 4; i++){   // Salva o ID da memória na string auxiliar "compara"
                i2c.read(5*k+1+i, buf); wait_ms(1);
                compara[i]=buf;
        }
        
        // Compara o ID do cartão aproximado com o ID da memória
        if((compara[0] == *(idcartao))   &&
           (compara[1] == *(idcartao+1)) &&
           (compara[2] == *(idcartao+2)) &&
           (compara[3] == *(idcartao+3)))
            return k+1;
        
    }
    return 0;

}

/* Função "printa_id" printa o ID passado por referência */
void printa_id (char *id){

    int i;
     
    for (i=0; i<4 ; i++){
        printf("%d ",*(id+i));   
    }
    return;
}

/* Função "colocamemoria" insere as informações do cartão 
    aproximado (ID e senha inserida) na memória */
void colocamemoria(char *idcartao){
    
    int8_t elementos,i,buf,senha;
    
    // Escreve na última posição da memória o ID do novo cartão cadastrado
    for (i=0; i < 4; i++){ 
        escreve_mem( *(idcartao+i), i);
    }
    
    printf("Digite a senha: ");
    scanf("%d", &senha);
    buf=senha;
    
    i2c.read(0, elementos); wait_ms(1);  
    elementos++;
    i2c.write(5*elementos, buf); wait_ms(1);  //Escreve a senha inserida pela usuário na memória
    
    printf("\n\n\rCartao de ID ");
    printa_id(idcartao);
    printf("com SENHA %d cadastrado com sucesso.\n\r",senha);
    

    i2c.write(0, elementos); wait_ms(1);
    
    return;
}

/* A função modo_cadastro faz o cadastro dos novos cartões solicitando que o usuário 
    insera uma senha relacionado ao ID cadastrado    */
void modo_cadastro (){
       
    char id_cartao[4];
    int8_t elementos;
    
    i2c.read(0, elementos); wait_ms(1);  
    printf("\n\rMODO CADASTRO ATIVADO.\n\r");
    printf("Aproxime Cartao do Leitor. \n\r");
    
    pega_id(id_cartao);    // Detecta o ID do cartao aproximado e coloca no vetor id_cartao
    // Trecho abaixo faz com que o modo seja trocado caso o usuário tenha solicitado um modo diferente
    if(flag_mudamodo==1){
        flag_mudamodo=0; 
        return;
    }
    wait_ms(10);
    
    if( jaexiste(id_cartao)!=0 ){      // Caso o cartão já esteja cadastrado
        printf("O cartao de ID "); 
        printa_id(id_cartao);       
        printf("ja esta cadastrado.\n\r");
    }
    else // Caso o cartão não esteja cadastrado
        colocamemoria(id_cartao);    // Função "colocamemoria" cadastra o novo cartão
    
    wait_ms(50);

    return ;
}

/* A função "modo_descadastro" pega o ID do cartão aproximado e descadastra 
    caso o cartão seja encontrado na memória */
void modo_descadastro (){
    
    char id_cartao[4],aux[5];
    int8_t elementos,k,i,buf;
    
    i2c.read(0, elementos); wait_ms(1);  // Variável "elementos" recebe a quantidade de cartões cadastrados

    printf("\n\rMODO DESCADASTRO ATIVADO.\n\r");
    printf("Aproxime Cartao do Leitor. \n\r");
    
    pega_id(id_cartao);    // Detecta o ID do cartao aproximado e coloca no vetor id_cartao
    // Trecho abaixo faz com que o modo seja trocado caso o usuário tenha solicitado um modo diferente
    if(flag_mudamodo==1){
        flag_mudamodo=0; 
        return;
    }
    
    k=jaexiste(id_cartao);
    if( k!=0 ){ // Entra caso o ID do cartão aproximado seja encontrado na memória
        //Caso haja apenas um elemento, esse elemento é apagado e muda-se automaticamente para o Modo Cadastro
        if(elementos==1){ 
            printf("Cartao de ID ");
            printa_id(id_cartao);
            printf("descadastrado com sucesso.\n\r");
            elementos--;
            i2c.write(0,elementos); wait_ms(1);
            printf("Nao Ha Cartao Cadastrado, Ativando Modo Cadastro...\n\r");
            flag_identificacao=0;
            flag_cadastro=1;
            flag_descadastro=0;
            return;
        }
        /* Caso haja mais de um cartão cadastrado, copia-se o último elemento na string "aux"
             e coloca na posição do cartão encontrado */
        else{ 
            for (i=0; i < 5; i++){
                i2c.read(5*(elementos-1)+1+i, buf); wait_ms(1);
                aux[i]=buf;
            }
            for (i=0; i < 5; i++){
                i2c.write(5*(k-1)+1+i, aux[i]); wait_ms(1); //Escreve na posição descadastrada o último elemento
            }           
            printf("Elemento %d desregistrado com sucesso.\n\r",k);
            elementos--;
            i2c.write(0,elementos); wait_ms(1);
            return; 
        }
    }
    else{ //Entra se k=0 (quando não o cartão não é encontrado na memória)
        printf("Cartao nao esta registrado.\n\r");
    }
    

    return ;
}

/* A função "modo_identificacao" corresponde ao modo de leitura de cartões 
    para permitir o acesso do usuario */
void modo_identificacao (){

    int k;
    char id_cartao[4];
    int8_t elementos,senha,buf;
    
    i2c.read(0, elementos); wait_ms(1);    // Coloca em "elementos" o numero de cartões cadastrados na memória 
    printf("\n\rMODO IDENTIFICACAO ATIVADO\n\r");
    printf("Aproxime Cartao do Leitor. \n\r");
    
    pega_id(id_cartao);    // Detecta o ID do cartao aproximado e coloca no vetor id_cartao
    // Trecho abaixo faz com que o modo seja trocado caso o usuário tenha solicitado um modo diferente
    if(flag_mudamodo==1){
        flag_mudamodo=0; 
        return;
    }
    /* Variável "k" recebe a posição na memória do cartão aproximado. Caso o cartão aproximado não seja encontrado, k recebe 0 */
    k=jaexiste(id_cartao);  
    if(k!=0){  // Entra caso o cartão seja encontrado na memória
        printf("Digite a senha: \n\r");
        scanf("%d",&senha);
        printf("Senha inserida: %d\n\r",senha);
        i2c.read(5*k, buf); wait_ms(1); //Variável "buf" recebe a senha cadastrada na memória
        //Comparações da senha digitada com a senha cadastrada
        if (senha==buf) printf("Senha Correta - Acesso Permitido.\n\r"); 
        else printf("Senha Incorreta - Acesso Negado.\n\r");      
    }
    else //Entra caso k seja 0
        printf("Cartao Nao Esta Cadastrado.\n\r\n\r");

    return;
        
}

//  As 3 funções abaixo setam as flags necessárias para que a função correta
//     seja ativada quando a tecla correspondente é pressionada.
//  A condição no início muda "flag_mudamodo" para indicar que haverá
//     uma mudança no modo ativo do programa. 
void isr1() {
    
    if(flag_identificacao==0)
        flag_mudamodo=1;
        
    flag_identificacao=1;
    flag_cadastro=0;
    flag_descadastro=0;
}
void isr2() {
    
    if(flag_descadastro==0)
        flag_mudamodo=1;
    
    flag_identificacao=0;
    flag_cadastro=0;
    flag_descadastro=1;   
}
void isr3() {

    if(flag_cadastro==0)
        flag_mudamodo=1;

    flag_identificacao=0;
    flag_cadastro=1;
    flag_descadastro=0;
}


int main(void) {

    int8_t elementos=0;    
    
    pc.baud(9600);
   //debounce.start();

    
    //Init. RC522 Chip
    RfChip.PCD_Init();
    
    //init LCD
    init_LCD();
    
    i2c.write(0, 0); wait_ms(1);//escreve 0 elementos na memoria
    
    i2c.read(0,elementos); wait_ms(1);
    
    button1.rise(&isr1); // Ativa quando a tecla "*" é pressionada
    button2.fall(&isr2); // Ativa quando a tecla "0" é pressionada
    button3.fall(&isr3); // Ativa quando a tecla "#" é pressionada
    
    while (true){     

        if(flag_identificacao==1){      // Entra caso o botão correspondente seja pressionado
            limpa_lcd(); 
            escreve_lcd ("IDENTICACAO");
            pula_linha();
            escreve_lcd ("PASSE CARTAO");
            modo_identificacao();   // Ativa o modo identificação
        }
        if(flag_cadastro==1){     // Entra caso o botão correspondente seja pressionado
            limpa_lcd();
            escreve_lcd ("CADASTRO");
            pula_linha();
            escreve_lcd ("PASSE CARTAO");
            modo_cadastro();        // Ativa o modo cadastro
        }
        if(flag_descadastro==1){        // Entra caso o botão correspondente seja pressionado
            limpa_lcd();
            escreve_lcd ("DESCADASTRO");
            pula_linha();
            escreve_lcd ("PASSE CARTAO");
            modo_descadastro();         // Ativa o modo descadastro
        }        

    }
    
}    