/* Code originally from MIDN T Stone
modified and debugged by Evangelista */
#include "mbed.h"

Serial pc(USBTX, USBRX); //declare the computer to the serial port
PwmOut leds[3] = {LED1, LED2, LED3}; // create an aray including three LEDs
int trigger; // declare trigger value
float pwm[3] = {0.0, 0.0, 0.0}; // declare variables for the PWM of each LED
float brightness[3] = {0, 0, 0}; // declare and initlialize an array for the desired brightness of each LED
int i; // declare for use in for loop
int iterations; // declare a variable for the maximum amount of iterations
float max;// declare a variable to store the maximum brightness specified by the user
int main (void)
{
    max = 0.0;
    i = 0;
    iterations = 0;
    while(1) {
        // pc.printf(" enter the trigger point and desired brightness for each LED\n");
        pc.scanf("%d,%f,%f,%f", &trigger,&brightness[0],&brightness[0],&brightness[1],&brightness[2]);// receive the trigger value and intended brightness for each of the 3 LEDs
        //pc.printf("%d\n %f\n %f\n %f\n", trigger, brightness[0], brightness[1], brightness[2]); // print these values for clarification
        for ( i =1; i < 3; i++) { // find the highest brightness enetered and assign it to the value max
            if (brightness[i] > max) {
                max = brightness[i];
                pwm[i] = 0;
            }//if
            //pc.printf("the max value is %f", max);

        }//for
        while (trigger == 1) { // while the trigger value is equal to one, increase the PWM of each LED until they reach it's intended brightness
            for (i =0; i < 3; i++) {
                if (pwm[i] < brightness[i]) {
                    pwm[i] = pwm[i] +.01;
                    leds[i].write(pwm[i]);
                    iterations = iterations +1;
                    pc.printf("%d,%f,%f,%f\n",iterations,pwm[0],pwm[1],pwm[2]);// print the number of iterations and the brightness of each light
                    wait(.01);
                }// if
            }// for
            if ( pwm[0] >= max || pwm[1] >= max || pwm[2] >= max) { // when any of the PWMs equals the highest desired, reset the trigger value to exit this while loop
                trigger = 0;
                iterations = 0;
            }// if
        } //while(trigger ==1)

    }// while(1)
}//main
