#include "mbed.h"

#include "SDFileSystem.h"

Serial pc(USBTX, USBRX); // tx, rx
Serial device(p28, p27);  // tx, rx
DigitalOut myled(LED4);
SDFileSystem sd(p11, p12, p13, p14, "sd");

long before;
long after;
char samp[3];
char buff[100];
Timer t;

int getSample();
void flush();

int main() {
    FILE *header;

    pc.baud(19200);
    device.baud(9600);
    
    while(1) {
        memset(buff,'\0',10);
        pc.printf("\r\nHow many bits would you like to test? ");
        char temp = '\0';
        char idx = 0;
        while (temp != '\r'){
            temp = pc.getc();
            buff[idx] = temp;
            pc.putc(temp);
            idx++;
        }
        long num = atol(buff);
        pc.printf("testing %d bits",num);
        t.start();
        header = fopen("/sd/config.txt","w");
        myled = 1;
        before = t.read_us();
        unsigned char val = 0;
        for (unsigned long i=0;i<num;i++){
                fputc(val,header);
                val++;
        }
        after = t.read_us();
        fclose(header);
        myled = 0;
        pc.printf("\r\nIt took %d microseconds to write %d\r\n",(after-before),num);
        pc.printf("aka, a rate of %f bits/sec\r\n",(float)num/((float)(after-before)/1000000));      
    }
}