#include "mbed.h"

#define CMD_MASK    0
#define DATA_MASK   1

// These are temperature dependent!  Here picked at 25C
#define VAClear 0x15
#define VAIdle  0x05
#define AAClear 0x11
#define AAIdle  0x07
#define Drive   0x0D
#define Voltage 0x40

#define Bias    0x02


DigitalOut myled(LED1);

SPI spi(p11, p12, p13);

DigitalIn busy(p14);
DigitalOut nReset(p10);
DigitalOut nCS(p9);
DigitalOut DC(p8);

void PutCharSPI(unsigned char byte, unsigned char image) {
    nCS = 0;
    wait_us(1);
    DC = image;
    spi.write(byte);
    wait_us(1);
    nCS = 1;
}

int main() {
    spi.format(8,0);
    
    nReset = 0;
    nCS = 0;
    DC = 0;
    wait_ms(2);
    nReset = 1;
    
    // Initialization code.
    PutCharSPI( 0xA3, CMD_MASK ); // Enable band gap and other analog control.
    PutCharSPI( 0x18, CMD_MASK );
    PutCharSPI( 0xF6, CMD_MASK ); // Enable oscillator.
    PutCharSPI( 0x40, CMD_MASK );
    PutCharSPI( 0xAE, CMD_MASK ); // Set auto charge pump threshold value.
    PutCharSPI( 0x00, CMD_MASK );
    PutCharSPI( 0xA2, CMD_MASK ); // Set Bias level
    PutCharSPI( Bias, CMD_MASK );
    // Set drive parameters.
    PutCharSPI( 0x80, CMD_MASK );
    PutCharSPI( 0x00, CMD_MASK );
    PutCharSPI( VAClear, CMD_MASK ); // VA Clear Duration
    PutCharSPI( VAIdle, CMD_MASK ); // VA Idle Duration. Stir time.
    PutCharSPI( AAClear, CMD_MASK ); // AA Clear Duration
    PutCharSPI( AAIdle, CMD_MASK ); // AA Idle Duration
    PutCharSPI( Drive, CMD_MASK ); // Drive Duration
    PutCharSPI( Voltage, CMD_MASK ); // Clear Voltage
    PutCharSPI( Voltage, CMD_MASK ); // Drive Voltage
    // Set dummy waveform for supply initialization.
    PutCharSPI( 0x93, CMD_MASK );
    PutCharSPI( 0x00, CMD_MASK ); // Skip VA Clear.
    PutCharSPI( 0x94, CMD_MASK );
    PutCharSPI( 0x00, CMD_MASK ); // Skip VA Idle.
    PutCharSPI( 0x95, CMD_MASK );
    PutCharSPI( 0x00, CMD_MASK ); // Skip AA Clear.
    PutCharSPI( 0x96, CMD_MASK );
    PutCharSPI( 0x00, CMD_MASK ); // Skip AA Idle.
    PutCharSPI( 0x97, CMD_MASK );
    PutCharSPI( 0x00, CMD_MASK ); // Skip Drive.
    // Dummy update results in future supply initialization to Clear Voltage.
    PutCharSPI( 0x31, CMD_MASK ); // Dummy update.
    while(busy) { ; }
    
    // More driver initialization code.
    PutCharSPI( 0xA3, CMD_MASK); // Enable other analog control.
    PutCharSPI( 0x1A, CMD_MASK);
    PutCharSPI( 0xE9, CMD_MASK); // Enable bias driven.
    PutCharSPI( 0x84, CMD_MASK);
    PutCharSPI( 0x2F, CMD_MASK); // Enable booster and high voltage buffer.
    // Delay to allow dc/dc reach voltage.
    // Rise time to 25V with Vin = 2.4V is 280 msec.
    // Rise time to 25V with Vin = 3.3V is 160 msec.
    wait_ms(300);
    // Set up update.
    PutCharSPI( 0x93, CMD_MASK );
    PutCharSPI( 1, CMD_MASK ); // VA Clear Repeats
    PutCharSPI( 0x94, CMD_MASK );
    PutCharSPI( 1, CMD_MASK ); // VA Idle Repeats
    PutCharSPI( 0x95, CMD_MASK );
    PutCharSPI( 1, CMD_MASK ); // AA Clear Repeats
    PutCharSPI( 0x96, CMD_MASK );
    PutCharSPI( 1, CMD_MASK ); // AA Idle Repeats
    PutCharSPI( 0x97, CMD_MASK );
    PutCharSPI( 1, CMD_MASK ); // Drive Repeats
    PutCharSPI( 0x32, CMD_MASK ); // Drive scheme:
    PutCharSPI( 0x32, CMD_MASK ); // Clear to bright.

    while(1) {
        myled = 1;
        wait(0.2);
        myled = 0;
        wait(0.2);
    }
}
