/* Copyright (c) 2010-2011 mbed.org, MIT License
* Modified Mouse code for Joystick - WH 2012
* Modified for RetroPie MW 2016
*
* Permission is hereby granted, free of charge, to any person obtaining a copy of this software
* and associated documentation files (the "Software"), to deal in the Software without
* restriction, including without limitation the rights to use, copy, modify, merge, publish,
* distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the
* Software is furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included in all copies or
* substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
* BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
* NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
* DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/
 
#include "stdint.h"
#include "USBGamepad.h"



bool USBGamepad::update(uint32_t buttons) 
{
   _buttonsP1 = (uint16_t)(buttons & 0xffff);
   _buttonsP2 = (uint16_t)((buttons >> 16) & 0xffff);
   return update();
}
 
bool USBGamepad::update() 
{
   HID_REPORT report;

   // Fill the report according to the Gamepad Descriptor

    #define put(idx, val) (report.data[idx] = (val) & 0xff, report.data[(idx)+1] = ((val) >> 8) & 0xff)
       
    report.data[0] = 0x01;  //Report id 1
    put(1, _buttonsP1); // 0..1 2 bytes    
    
    send(&report);

    report.data[0] = 0x02;  //Report id 2
    put(1, _buttonsP1); 
    
    send(&report);
   
    put(2, _buttonsP2);//  2..3 2 bytes, 32 buttons
   
   // important: keep reportLen in sync with the actual byte length of
   // the reports we build here
   report.length = REPORT_LEN;
 
   // send the report
   return sendNB(&report);
}

bool USBGamepad::buttons(uint32_t buttons) 
{
     _buttonsP1 = (uint16_t)(buttons & 0xffff);
     _buttonsP2 = (uint16_t)((buttons >> 16) & 0xffff);
     return update();
}

 
void USBGamepad::_init() {
 
   _buttonsP1 = 0x0000; // 16 buttons
   _buttonsP2 = 0x0000; // 16 buttons
   
}
 
 
uint8_t * USBGamepad::reportDesc() 
{    

static const uint8_t reportDescriptor[27] = {
    0x05, 0x01,                    // USAGE_PAGE (Generic Desktop)
    0x09, 0x05,                    // USAGE (Game Pad)
    0xa1, 0x01,                    // COLLECTION (Application)
    0xa1, 0x00,                    //   COLLECTION (Physical)
    0x85, 0x01,                    //     REPORT_ID (1)
    0x05, 0x09,                    //     USAGE_PAGE (Button)
    0x19, 0x01,                    //     USAGE_MINIMUM (Button 1)
    0x29, 0x10,                    //     USAGE_MAXIMUM (Button 16)
    0x15, 0x00,                    //     LOGICAL_MINIMUM (0)
    0x25, 0x01,                    //     LOGICAL_MAXIMUM (1)
    0x75, 0x01,                    //     REPORT_SIZE (1)
    0x95, 0x10,                    //     REPORT_COUNT (16)
    0x81, 0x02,                    //     INPUT (Data,Var,Abs)
    0xc0                           // END_COLLECTION
    0x05, 0x01,                    // USAGE_PAGE (Generic Desktop)
    0x09, 0x05,                    // USAGE (Game Pad)
    0xa1, 0x01,                    // COLLECTION (Application)
    0xa1, 0x00,                    //   COLLECTION (Physical)
    0x85, 0x02,                    //     REPORT_ID (2)
    0x05, 0x09,                    //     USAGE_PAGE (Button)
    0x19, 0x01,                    //     USAGE_MINIMUM (Button 1)
    0x29, 0x10,                    //     USAGE_MAXIMUM (Button 16)
    0x15, 0x00,                    //     LOGICAL_MINIMUM (0)
    0x25, 0x01,                    //     LOGICAL_MAXIMUM (1)
    0x75, 0x01,                    //     REPORT_SIZE (1)
    0x95, 0x10,                    //     REPORT_COUNT (16)
    0x81, 0x02,                    //     INPUT (Data,Var,Abs)
    0xc0                           // END_COLLECTION
};

      reportLength = sizeof(reportDescriptor);
      return reportDescriptor;
}
 
 uint8_t * USBGamepad::stringImanufacturerDesc() {
    static uint8_t stringImanufacturerDescriptor[] = {
        0x15,                                            /*bLength*/
        STRING_DESCRIPTOR,                               /*bDescriptorType 0x03*/
        't',0,'h',0,'e',0,'t',0,'a',0,'z',0,'z',0,'b',0,'o',0,'t',0        /*bString iManufacturer - mjrcorp*/
    };
    return stringImanufacturerDescriptor;
}

uint8_t * USBGamepad::stringIserialDesc() {
    static uint8_t stringIserialDescriptor[] = {
        0x16,                                                           /*bLength*/
        STRING_DESCRIPTOR,                                              /*bDescriptorType 0x03*/
        '0',0,'1',0,'2',0,'3',0,'4',0,'5',0,'6',0,'7',0,'8',0,'9',0,    /*bString iSerial - 0123456789*/
    };
    return stringIserialDescriptor;
}

uint8_t * USBGamepad::stringIproductDesc() {
    static uint8_t stringIproductDescriptor[] = {
        0x1E,                                                       /*bLength*/
        STRING_DESCRIPTOR,                                          /*bDescriptorType 0x03*/
        'A',0,'r',0,'c',0,'a',0,'d',0,'e',0,' ',0,'G',0,
        'a',0,'m',0,'e',0,'p',0,'a',0,'d',0                         /*String iProduct */
    };
    return stringIproductDescriptor;
}
