#include "mbed.h"
#include "motordriver.h"
#include "HMC6352.h"

// test program to verify compass integrity when run on motor and to determine filtering values. uncomment/comment motor sections to test.
HMC6352 compass(p9, p10);
Serial pc(USBTX, USBRX);
//Motor left(p21, p22, p20, 1); // pwm, fwd, rev, has brake feature
//Motor right(p24, p25, p27, 1);

int main() {
    float avgdev, dev, maxdev, swing, prevval, curval, minval, maxval = 0.0; //variables to measure swing, maxdev, and avg dev of measurements
    long count = 0;
    //float speed = .1;
    pc.printf("Starting HMC6352 test...\n");
    //left.speed(speed);
    //right.speed(speed);
    //Continuous mode, periodic set/reset, 20Hz measurement rate.
    compass.setOpMode(HMC6352_CONTINUOUS, 1, 20);
    wait(1);
    //init math vals
    curval = compass.sample()/10.0;
    minval = curval;
    maxval = curval;
    while (1) {
        count++; // for avg
        prevval = curval;
        curval = compass.sample()/10.0;
        dev = abs(curval - prevval);
        if (curval > maxval) {maxval = curval;}
        if (curval < minval) {minval = curval;}
        if (dev > maxdev)    {maxdev = dev;}    //largest deviation between two successive readings.
        avgdev += dev; //divide avg dev in print statement
        swing = maxval - minval; //swing is largest reading change possible from remaining stationary.
        if (count % 10 == 1) {
        pc.printf("Heading is: %f, Max Dev: %f, Avg Dev: %f, Swing: %f\n", curval, maxdev, avgdev/count, swing);
            //if (speed < .8) {speed += .05;
            //left.speed(speed);
            //right.speed(speed);}
        }
        wait(0.05);
    }

}
