#include "mbed.h"
#include "ADXL345.h"

DigitalOut mbedled1(LED1); // signals running
DigitalOut mbedled2(LED2); // signals shake warning/detected
DigitalOut mbedled3(LED2); // signals +/- y
DigitalOut mbedled4(LED2); // signlas +/- x

PwmOut IRLED(p21);

Serial pc(USBTX, USBRX); //for debugging
Serial drawbot(p13, p14); //change to whatever send method we use

AnalogIn rightknob(p15);
AnalogIn leftknob(p16);

ADXL345 acc(p5, p6, p7, p8);

//command vars
float rightval, leftval, rightprev, leftprev = 0;
int rightdif, leftdif, righttotal, lefttotal = 0;
char command = 0; // bit0 = 1 if shake; bit7 = 0 if left, 1 right; bit6 = 0 if fwd, 1 rev; bit 1-5 = magnitude; for drawbot
//or bit0 = 1 if shake; bit7 = 0 if y, 1 if x; bit6 = 0 if pos, 1 if neg for smartbot

//accel and shake vars
int z,x,y,zprev,xprev,yprev = 0;
int readings[3];
int shakeweight = 0;

int main()
{
    //Initialize accelerometer
    acc.setPowerControl(0x00);
    acc.setDataFormatControl(0x0B);
    acc.setDataRate(ADXL345_3200HZ);
    acc.setPowerControl(0x08);
    //Initialize accelerometer readings
    acc.getOutput(readings);
    x = (int16_t)readings[0];
    y = (int16_t)readings[1];
    z = (int16_t)readings[2];
    
    //Initialize LEDs & Knobs
    mbedled1 = 1;
    mbedled2 = 0;
    mbedled3 = 0;
    mbedled4 = 0;
    rightval = rightknob;
    leftval = leftknob;
    
    //IR Setup
    IRLED.period(1.0/38000.0);
    IRLED = 0.5;
    //Drive IR LED data pin with 38Khz PWM Carrier
    //Drive IR LED gnd pin with serial TX
    drawbot.baud(2400);
    
    while(1) {
        
        //Check for Shake
        xprev = x;
        yprev = y;
        zprev = z;
        acc.getOutput(readings);
        x = (int16_t)readings[0];
        y = (int16_t)readings[1];
        z = (int16_t)readings[2];
        if (((abs(xprev - x) > 150) || (abs(yprev - y) > 150) || (abs(zprev - z) > 150)) && (shakeweight == 0)){
            mbedled2 = 1; //Light LED2
            shakeweight = 1;}  //activate shake wait
        if (shakeweight > 0) { shakeweight++;}  //if shake wait activated, increment
        if (shakeweight == 8){                 //until 10, then check for second shake
            mbedled2 = 0;
           if ((abs(xprev - x) > 150) || (abs(yprev - y) > 150) || (abs(zprev - z) > 150)) {
                mbedled2 = 1; //Light LED2
                command = 1; //0x01
                drawbot.putc(command);
                pc.printf("Shake Detected! Command is %x. Waiting. \n", command); //Send shake signal via Xbee or IR to drawbot
                wait(5); //Wait long enough for worst case new page set up unless drawbot can talk back
                mbedled2 = 0;
           }
           shakeweight = 0;
        }
        command = 0;
        //Detect Knobs
        rightprev = rightval;
        leftprev = leftval;
        rightval = rightknob;
        leftval = leftknob;
        rightdif =  500*rightval - 500*rightprev;
        leftdif =  500*leftprev - 500*leftval;
        if ((abs(rightdif) > 1) && (abs(rightdif) < 63)) { 
            mbedled3 = 1;
            command = 128; //0x80
            righttotal+=rightdif;
            if (rightdif < 0) { 
                rightdif = -rightdif;
                command =  192;}//0xC0
            command = rightdif | command; 
            pc.printf("RightDif: %d Tot: %d Comm: %x \n", rightdif, righttotal, command); //send right move command and val
            drawbot.putc(command);
            mbedled3 = 0;
        }
        if ((abs(leftdif) > 1) && (abs(leftdif) < 63)) {
            mbedled4 = 1;
            command = 0; //0x00
            lefttotal+=leftdif;
            if (leftdif < 0) { 
                leftdif = -leftdif;
                command =  64;}//0x40
            command = leftdif | command; 
            pc.printf("LeftDif: %d Tot: %d Comm: %x \n", leftdif, lefttotal, command); //send left move command and val
            drawbot.putc(command);
            mbedled4 = 0;
        }
        command = 0;
        wait(.1);
        //Print State
        //pc.printf("RightVal: %F, LeftVal: %F", rightval, leftval);
        //pc.printf("accel: %i, %i, %i\n", x, y, z);
    }
}
