#include "mbed.h"
#include "WS2812.h"
#include "PixelArray.h"

#define WS2812_BUF 77   //number of LEDs in the array
#define NUM_COLORS 2    //number of colors to store in the array

DigitalOut usrLed(LED1);
PixelArray px(WS2812_BUF);

// See the program page for information on the timing numbers
WS2812 ws(D9, WS2812_BUF, 6,17,9,14);   //nucleo-f411re

int color_set(uint8_t red,uint8_t green, uint8_t blue)
{
  return ((red<<16) + (green<<8) + blue);   
}

// 0 <= stepNumber <= lastStepNumber
int interpolate(int startValue, int endValue, int stepNumber, int lastStepNumber)
{
    return (endValue - startValue) * stepNumber / lastStepNumber + startValue;
}

int main()
{    
    uint8_t ir = 0;
    uint8_t ig = 0;
    uint8_t ib = 0;
    
    ws.useII(WS2812::PER_PIXEL); // use per-pixel intensity scaling
    
    // set up the colours we want to draw with
    int colorbuf[NUM_COLORS] = {0xff0000,0x0000ff};
    
    //get starting RGB components for interpolation
    std::size_t c1 = colorbuf[0];
    std::size_t r1 = (c1 & 0xff0000) >> 16;
    std::size_t g1 = (c1 & 0x00ff00) >> 8;
    std::size_t b1 = (c1 & 0x0000ff);
    
    //get ending RGB components for interpolation
    std::size_t c2 = colorbuf[1];
    std::size_t r2 = (c2 & 0xff0000) >> 16;
    std::size_t g2 = (c2 & 0x00ff00) >> 8;
    std::size_t b2 = (c2 & 0x0000ff);
    
    for (int i = 0; i <= WS2812_BUF; i++)
    {
        ir = interpolate(r1, r2, i, WS2812_BUF);
        ig = interpolate(g1, g2, i, WS2812_BUF);
        ib = interpolate(b1, b2, i, WS2812_BUF);
        
        //write the color value for each pixel
        px.Set(i, color_set(ir,ig,ib));
        
        //write the II value for each pixel
        px.SetI(i, 32);
    }
    
    for (int i = WS2812_BUF; i >= 0; i--) 
    {
        ws.write(px.getBuf());
    }
    
    usrLed = 1;
}
