#include "mbed.h"
#include "WS2812.h"
#include "PixelArray.h"

#define WS2812_BUF 77   //number of LEDs in the array
#define NUM_COLORS 6    //number of colors to store in the array

DigitalIn usrBtn(USER_BUTTON);
DigitalOut usrLed(LED1);
PixelArray px(WS2812_BUF);

// See the program page for information on the timing numbers
WS2812 ws(D9, WS2812_BUF, 6,17,9,14);   //nucleo-f411re

int main()
{
    int btnState = 0;
    
    ws.useII(WS2812::PER_PIXEL); // use per-pixel intensity scaling
    
    // set up the colours we want to draw with
    int colorbuf[NUM_COLORS] = {0x2f0000,0x2f2f00,0x002f00,0x002f2f,0x00002f,0x2f002f};
    
    // Now the buffer is written, write it to the led array.
    while (1) 
    {
        if (usrBtn == 0)    //button is pressed
        { 
            usrLed = 1;
            btnState = btnState++;
            
            if (btnState == NUM_COLORS) {
                btnState = 0;
            }
        } 
        else 
        {
            usrLed = 0;
        }
        
        //write the color value for each pixel
        px.SetAll(colorbuf[btnState]);
        
        //write the II value for each pixel
        px.SetAllI(64);
        
        for (int i = WS2812_BUF; i >= 0; i--) 
        {
            ws.write(px.getBuf());
        }
    }
}
