/*
 * Copyright (c) 2013, The Robot Studio
 *  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *  * Redistributions of source code must retain the above copyright notice, this
 *    list of conditions and the following disclaimer.
 *
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  Created on: Feb 27, 2013
 *      Author: Cyril Jourdan (cyril.jourdan@therobotstudio.com)
 */
 
#ifndef EPOSCMD_H
#define EPOSCMD_H

/*** Includes ***/
#include "mbed.h"
#include <stdint.h>
#include "registers.h"

/*** Define s ***/
#define NUMBER_MAX_EPOS2_PER_SLAVE  15
#define NUMBER_MSG_PER_PACKET       45
#define NUMBER_BYTES_PER_MSG        8
#define NUMBER_EPOS2_BOARDS         15
#define NB_SAMPLES_MEDIAN           5
//#define NB_MSG_TO_TRACK             20 //at least 4
//#define CMD_BUFFER_SIZE             26 //13*2 -> 2 cmdSet of 13 cmds each
#define PAUSE                       10
#define EPOS2_OK                    0
#define EPOS2_ERROR                 -1
#define LOOP_PERIOD_TIME            25000 //25 ms - 40Hz
#define TIMEOUT                     10000

enum ActivatedMode
{
    POSITION = 0,
    CURRENT = 1,
    VELOCITY = 2,
    PROFILE_POSITION = 3,
    FORCE = 4
}; 

//global variables
extern CAN cantoepos;
extern Serial pc;
//extern Serial pc;
extern DigitalOut ledchain[];   //used for debugging
extern char data[8];
//extern unsigned int count[12];  //used for debugging
extern ActivatedMode activMode[NUMBER_MAX_EPOS2_PER_SLAVE];

//ADC variables
extern AnalogIn an1;
extern AnalogIn an2;
extern AnalogIn an3;
extern AnalogIn an4;
extern AnalogIn an5;
extern AnalogIn an6;

//sensor variables
extern int32_t encPosition[NUMBER_MAX_EPOS2_PER_SLAVE];
//extern int16_t potiPosArray[NUMBER_MAX_EPOS2_PER_SLAVE][5];
extern int16_t potiPosArray[NUMBER_MAX_EPOS2_PER_SLAVE];
extern int16_t medPotiPosition[NUMBER_MAX_EPOS2_PER_SLAVE];
extern int16_t avgCurrent[NUMBER_MAX_EPOS2_PER_SLAVE];
extern int16_t medForce[NUMBER_MAX_EPOS2_PER_SLAVE];
extern int32_t velocity[NUMBER_MAX_EPOS2_PER_SLAVE];

extern int8_t boardStatus[NUMBER_MAX_EPOS2_PER_SLAVE];

//Multiplexer address lines
extern DigitalOut A0;
extern DigitalOut A1;
extern DigitalOut A2;

//functions
void setMultiplexerChannel(const int8_t);
static void setNMT(const int8_t, uint8_t);
extern int8_t setObjectSDO(const int8_t, const int32_t, int32_t);
static int8_t setPDO(const int8_t, uint16_t, uint8_t, uint32_t, uint8_t);

//EPOS2 boards and Motor settings
//static void setMotorType(const int8_t);
//static void setPolePair(const int8_t);
//static void setMaximalMotorSpeed(const int8_t);
//static void setMaximalProfileVelocity(const int8_t);
//static void setMaxAcceleration(const int8_t);
//static void setThermalTimeConstantWinding(const int8_t);
//static void setMaximalFollowingError(const int8_t);

static int8_t setModeOfOperation(const int8_t, uint8_t);
extern void setModeOfOperationPDO(const int8_t, uint8_t);

static void shutdownControlword(const int8_t);
extern void shutdownControlwordIT(const int8_t);
static void switchOnEnableOperationControlword(const int8_t);
extern void switchOnEnableOperationControlwordIT(const int8_t);
extern void faultResetControlword(const int8_t);
//static void reEnableControlword(const int8_t);

//macro functions
extern int8_t initEposBoard(const int8_t);
extern void setCurrent(const int8_t, const int16_t);
extern void setPosition(const int8_t, const int32_t);
extern void setVelocity(const int8_t, const int32_t);
extern void setForce(const int8_t, const int16_t);

extern void getPosition(const int8_t);
extern void getCurrent(const int8_t);
extern void getVelocity(const int8_t);
extern int16_t getForce(const int8_t);
extern void getPotiPosition(const int8_t);
extern void getIncEnc1CntIdxPls(const int8_t); //get Incremental Encoder 1 Counter at Index Pulse

extern void getStatusword(const int8_t);

#endif //EPOSCMD_H