//Library
#include "mbed.h"
#include "TS_DISCO_F746NG.h"
#include "LCD_DISCO_F746NG.h"

// Initialisation objet
LCD_DISCO_F746NG lcd;
TS_DISCO_F746NG ts;
I2C i2c (D14,D15);

uint8_t texttp[30];
    uint8_t texthm[30];
    uint8_t status;
    uint8_t idx;
    uint8_t cleared = 0;
    uint8_t prev_nb_touches = 0;
    uint8_t event_press = 0;
    uint16_t x, y;
    uint16_t pos_y = 210;
    uint16_t rayon = 0;
    
    int adress = 0x40 << 1;
    int touchtp;
    int touchhum;
     
    char ctemp[2] = {0x03,0x11};
    char chumi[2] = {0x03,0x01};
    char datatp[2] = { 0,0 };
    char datahu [2] = { 0,0 };
    
    float temp = 0;
    float temperature = 0;
    float humi = 0;
    float humidity = 0;
    
    int times = 0;

int choice = 0;

// Debug
//Serial pc(USBTX, USBRX);

// Fonction d'affichage de l'interface
void Clear_avec_un_rectangle (void){
    
    // Fond d'écran blanc  
    lcd.Clear(LCD_COLOR_LIGHTGRAY);
    lcd.SetBackColor(LCD_COLOR_LIGHTGRAY);

    // Bonton rouge pour température  
    lcd.SetTextColor(LCD_COLOR_RED);           
    lcd.DrawRect(25,100,200,50); 
    lcd.SetFont(&Font24);
    lcd.DisplayStringAt(33, 115, (uint8_t *)"TEMPERATURE", LEFT_MODE);  
    
    // Bouton vert pour humitidé 
    lcd.SetTextColor(LCD_COLOR_BLUE);
    lcd.DrawRect(250,100,200,50);
    lcd.SetFont(&Font24);
    lcd.DisplayStringAt(280, 115, (uint8_t *)"HUMIDITE", LEFT_MODE);  
          
    // Titre de l'interface 
    lcd.SetTextColor(LCD_COLOR_BLACK);
    lcd.SetFont(&Font20);
    lcd.DisplayStringAt(0, 10, (uint8_t *)"Capteur Humidite & Temperature", CENTER_MODE);  
}

void humidi(void){
    lcd.SetBackColor(LCD_COLOR_LIGHTGRAY);
    lcd.SetTextColor(LCD_COLOR_LIGHTGRAY);
    lcd.FillCircle(235,215,50); 
    lcd.SetFont(&Font16);
    sprintf((char*)texthm,"%0.1d %%",(int)humidity);
    lcd.DisplayStringAt(0, pos_y, (uint8_t *)"                                         ", CENTER_MODE);
    lcd.SetTextColor(LCD_COLOR_BLACK);
    lcd.DrawCircle(235,215,50); 
    lcd.SetTextColor(LCD_COLOR_BLUE);
    rayon = 50*(humidity/100);
    if(rayon>=50)
        rayon =50;
    lcd.FillCircle(235,215,rayon);
    lcd.SetBackColor(LCD_COLOR_BLUE);
    lcd.SetTextColor(LCD_COLOR_BLACK);
    lcd.DisplayStringAt(0, pos_y, (uint8_t *)&texthm, CENTER_MODE);
    //  prev_nb_touches = TS_State.touchDetected;
    cleared = 0;  
    x= 1;
    
}

void temper(void) {
    lcd.SetBackColor(LCD_COLOR_LIGHTGRAY);
    lcd.SetTextColor(LCD_COLOR_LIGHTGRAY);
    lcd.FillCircle(235,215,50);
                
    sprintf((char*)texttp,"%0.1d c",(int)temperature);
    lcd.DisplayStringAt(0, pos_y, (uint8_t *)"                                          ", CENTER_MODE); 
                
    lcd.SetTextColor(LCD_COLOR_BLACK);
    lcd.DrawCircle(235,215,50); 
                
    lcd.SetTextColor(LCD_COLOR_RED);
    rayon = 50*(temperature/50);
    if(rayon>=50)
        rayon =50;
    lcd.FillCircle(235,215,rayon);
    lcd.SetBackColor(LCD_COLOR_RED);
    lcd.SetTextColor(LCD_COLOR_BLACK);
                
    lcd.SetFont(&Font16);
    lcd.SetTextColor(LCD_COLOR_BLACK);
    lcd.DisplayStringAt(0, pos_y, (uint8_t *)&texttp, CENTER_MODE); 
                
    //  prev_nb_touches = TS_State.touchDetected;
    cleared = 0;
    x = 2;
}

void select_etat(void){        
    if ((x == 1) && (times == 10))
    {humidi();
    times = 0;}
    
    else if ((x == 2) && (times == 10))
    {temper();
    times = 0;}   
    
    
    }


//add capt 0x40
//f = 400kHz
//float temp = (capt/32) -50;

// Fonction MAIN
int main()
{
    // Debug
    //pc.baud(9600);
    
    // Paramétrage de l'I2C 
    i2c.frequency(100000);
    
    // Initialisation variable
    TS_StateTypeDef TS_State;
   
    
    
    
    // Affichage de l'interface
    Clear_avec_un_rectangle();
    
    while(1) {  
     select_etat();  
     times = times + 1;          
        
        // Demande de la valeur du registre température au capteur              
        i2c.write(adress ,ctemp ,2, 0);
        wait_ms(35);
        i2c.read(adress,datatp,2);
        wait_ms(35);
        temp = datatp[1]<<6;
        temp = temp + (datatp[2]>>2);
        temperature = (temp/32) - 50; 
        
        // Debug
        //pc.printf("\n\r temperature : %f",temperature);
        //pc.printf("\n\r data1 : %d ",(datatp[1]<<6) + (datatp[2] >> 2));
        
        wait_ms(35);
        
        // Demande de la valeur deu registre humidité
        i2c.write(adress ,chumi ,2, 0);
        wait_ms(35);
        i2c.read(adress,datahu,2);
        wait_us(35);
        humi = datahu[1]<<4;
        humi = humi + (datahu[2]>>4);
        humidity = (humi/16) - 24; 
        
        // Debug
        //pc.printf("\n\r Humidity : %f %",humidity);
        //pc.printf("\n\r data1 + data2 : %d ",(datahu[1]<<4) + (datahu[2]>>4));
        
        wait_ms(35);
        
        // Détéction d'un apuie sur l'écran tactile
        ts.GetState(&TS_State);
        if (TS_State.touchDetected) {
            
            if (TS_State.touchDetected < prev_nb_touches) {
                for (idx = (TS_State.touchDetected + 1); idx <= 5; idx++) {
                    lcd.ClearStringLine(idx);
                }
            }
            prev_nb_touches = TS_State.touchDetected;
            cleared = 0;
            
            // Enregistrement de la position de l'apuie 
            for (idx = 0; idx < TS_State.touchDetected; idx++) {
                x = TS_State.touchX[idx];
                y = TS_State.touchY[idx];
            }
            
            // Détection d'un apuie sur le bouton humidité  
            if((x>250) && (x<450) && (y>=100) && (y<150)) { 
                touchhum=1;
                touchtp=0;
            }
             
            // Détection d'un apuie sur le bouton température            
            else if ((x>25) && (x<200)&&(y>=100)&&(y<150)) {
                touchhum=0;
                touchtp=1;
            }
            
            // Si apuie sur le bouton humidité, affichage valeur envoyé par le capteur
            if (touchhum==1 && touchtp==0) {
              humidi();
            }
            
            // Si apuie sur le bouton température, affichage valeur envoyé par le capteur
            else if (touchhum==0 && touchtp==1) {
                temper();
            }                      
        }  
    }
}






















