#include "pixy2.h"

/*      _DEBUG_     */
int sommeDeControle,sommeRecue;
char *ptr;

void automate_debug(T_Pixy2State &etat);

Serial pc(USBTX, USBRX, 9600);
/*                  */

typedef enum {IDLE, SND, SND_2, CHECKSUM_ERROR, TIMEOUT, OK, OK_2} T_state;

// FLAGS
bool FLAG_BP = false;
int nb_appui = 0;

// Prototypes
void appui_BP(void);


int main(void)
{
    PIXY2               maPixy(PC_12, PD_2);     // PC_12 : UART5_TX --- PD_2 : UART5_RX
    
    T_pixy2Version* version;
    T_pixy2Resolution* resolution;
    T_pixy2ErrorCode    rep;
    
    // Initialisations
    InterruptIn BP(USER_BUTTON);
    BP.rise(&appui_BP);
    
    Timer temps;
    temps.start();
    
    T_state etat = IDLE;
    
    while(1) {

        switch (etat) {
            case IDLE :
                if (FLAG_BP && nb_appui == 0) {
                    pc.printf("Envoi...\n\r");
                    etat = SND;
                    FLAG_BP = false;
                    temps.reset();
                    nb_appui += 1;
                }
                if (FLAG_BP && nb_appui == 1) {
                    pc.printf("Envoi...\n\r");
                    etat = SND_2;
                    FLAG_BP = false;
                    temps.reset();
                    nb_appui = 0;
                }
                break;

            case SND :
                rep = maPixy.pixy2_getVersion(&version);
                
                if (rep == PIXY2_BAD_CHECKSUM) {
                    etat = CHECKSUM_ERROR;   
                }
                if (temps.read()>0.5f) {
                    etat = TIMEOUT;
                }
                if (rep == PIXY2_OK) {
                    etat = OK;
                }
                break;
                
            case SND_2 :
                rep = maPixy.pixy2_getResolution(&resolution);
                
                if (rep == PIXY2_BAD_CHECKSUM) {
                    etat = CHECKSUM_ERROR;   
                }
                if (temps.read()>0.5f) {
                    etat = TIMEOUT;
                }
                if (rep == PIXY2_OK) {
                    etat = OK_2;
                }
                break;
            
            case CHECKSUM_ERROR :
                pc.printf("Erreur de CheckSum...\n\r");
                pc.printf("CheckSum Recu    : %d\n\r", sommeRecue);
                pc.printf("CheckSum Calcule : %d\n\r", sommeDeControle); 
                etat = IDLE;
                break;
            
            case TIMEOUT :
                pc.printf("Erreur Timeout...\n\rRep : %d\n\r", rep);
                for(int i=0; i<2; ++i)
                    pc.printf("%d\n\r", *(ptr + i));
                etat = IDLE;
                break;

            case OK :
                pc.printf("Version de la camera : %s\n\r", version->pixHFString);
                etat = IDLE;
                break;
                
            case OK_2 :
                pc.printf("Resolution de la camera : %d - %d\n\r", resolution->pixFrameWidth, resolution->pixFrameHeight);
                etat = IDLE;
                break;

        }
        
        //automate_debug(maPixy.etat);
    }
}

// FONCTIONS
void appui_BP(void)
{
    FLAG_BP = true;
}

void automate_debug(T_Pixy2State &etat) {
    
    static int etat_debug_passe = -1;
    
    if(etat != etat_debug_passe) {
        switch(etat) {
            case idle :
                pc.printf("IDLE\n\r");
                break;
            case messageSent :
                pc.printf("DATA_SENT\n\r");
                break;
            case receivingHeader :
                pc.printf("RECEIVING_HEADER\n\r");
                break;
            case receivingData :
                pc.printf("RECEIVING_DATA\n\r");
                break;
            case dataReceived :
                pc.printf("DATA_RECEIVED\n\r");
                break;    
        }
    }
    
    etat_debug_passe = etat;   
}