#include "mbed.h"
#include "LCD_DISCO_F746NG.h"
//#include "stm32746g_discovery_lcd.h"
//#include "stm32746g_discovery_ts.h"
#include "TS_DISCO_F746NG.h"

Serial rfid(PF_7,PF_6);
Serial PC(USBTX, USBRX);
PwmOut exitPWM(PA_0);
AnalogIn CNY70(PF_10); 

LCD_DISCO_F746NG lcd;

TS_DISCO_F746NG ts; //pour detecter toucher ecran lcd
TS_StateTypeDef TS_State;

Timer timePartie;

char tabRfid[20]={0}, caractRFID, nomTag[16]={0}, charTimer[5]={0};
int iRFID=0;

void PageAttentScan(){ //page d'acceuil attente scan
    lcd.DisplayStringAt(10,130,(uint8_t *)"Scanner votre tag RFID",CENTER_MODE);
    lcd.DrawRect(429,221,50,50);
    }
    
    
void PageAttentChoix(char* pnum_badge){ //Page Play ou Setting

    lcd.DisplayStringAt(0,50,(uint8_t *)tabRfid,CENTER_MODE);
    lcd.DisplayStringAt(0,80,(uint8_t *)nomTag,CENTER_MODE);
    
    lcd.DrawRect(50,150,150,50);
    lcd.DrawRect(280,150,150,50);

    lcd.DisplayStringAt(90,165,(uint8_t *)"Play",LEFT_MODE);
    lcd.DisplayStringAt(60,165,(uint8_t *)"Setting",RIGHT_MODE);
    
    lcd.DrawRect(358,220,120,50);
    lcd.DisplayStringAt(0,235,(uint8_t *)"Retour",RIGHT_MODE);
    }
    
void PageDiff(){ //page difficulte (easy medium ou hard)
    //0=easy 1=medium 2=hard
    char score[5]={0};
    
    lcd.SetTextColor(0xffff0000);
    lcd.DisplayStringAt(0,20,(uint8_t *)"Choix de la difficulte",CENTER_MODE);
    lcd.SetTextColor(0xff000000);
    lcd.DisplayStringAt(0,80,(uint8_t *)tabRfid,CENTER_MODE);
    
    lcd.DrawRect(25,150,100,50);
    lcd.DrawRect(170,150,125,50);
    lcd.DrawRect(359,150,100,50);
    
    
    lcd.DisplayStringAt(40,165,(uint8_t *)"Easy",LEFT_MODE);
    lcd.DisplayStringAt(0,165,(uint8_t *)"Medium",CENTER_MODE);
    lcd.DisplayStringAt(40,165,(uint8_t *)"Hard",RIGHT_MODE);

    }

void  AfficheDiffPartie(int modeChoisie){ //affichage du lancement de la partie pendant compte a rebour
    
    lcd.SetTextColor(0xffff0000);
    
    if(modeChoisie==0)lcd.DisplayStringAt(0,50,(uint8_t *)"Partie facile",CENTER_MODE);
    else if(modeChoisie==1)lcd.DisplayStringAt(0,50,(uint8_t *)"Partie Moyenne",CENTER_MODE);
    else if(modeChoisie==2)lcd.DisplayStringAt(0,50,(uint8_t *)"Partie Dure",CENTER_MODE);
    
    lcd.SetTextColor(0xff000000);
    lcd.DisplayStringAt(0,20,(uint8_t *)"Lancement de la partie",CENTER_MODE);
    lcd.DrawCircle(235,170,50);
}

void AfficheWin(){ //affichage win
    
    lcd.DisplayStringAt(0,20,(uint8_t *)"Bravo vous avez gagne :",CENTER_MODE);
    lcd.SetTextColor(0xffff0000);
    lcd.DisplayStringAt(0,60,(uint8_t *)charTimer,CENTER_MODE);
    lcd.SetTextColor(0xff000000);
    lcd.DrawRect(260,200,200,50);
    lcd.DisplayStringAt(30,215,(uint8_t *)"  Retour",RIGHT_MODE);
}

bool TouchScreenOk(int xMin,int xMax,int yMin,int yMax,uint16_t valX,uint16_t valY,uint8_t nbrPointTactile){ //verif si on touche le BP
    bool toucheScreenOk=false;
    
        
    if(valX>xMin && valX<xMax && valY>yMin && valY<yMax && nbrPointTactile>0) toucheScreenOk=true;
    
    
    return toucheScreenOk;
}

char TouchScreenChar(){ //detection bp pour setting
    char caract=' ';
    char carLigne12[11]="AZERTYUIOP", carLigne2[11]="QSDFGHJKLM",carLigne3[11]="WXCVBNssee";
    int colX=-1;
    uint16_t x, y;
    wait(0.1);
    ts.GetState(&TS_State);
    
    if (TS_State.touchDetected > 0) {
        
        x = TS_State.touchX[0];
        y = TS_State.touchY[0];
        
        
        if(y>127){
            colX=x/48;
            PC.printf("Y > 127");
            if(y>223)caract=carLigne3[colX];//ligne 3
            else if(y>175)caract=carLigne2[colX];//ligne 2
            else caract=carLigne12[colX];//ligne 1
            
        }     
    }
    if(caract!=' ')PC.printf("Caract = %c",caract);
    return caract;
}

bool StartPartie(int modeChoisie,int* numSwitchPartie){ //switch case de la partie
        bool etatPartie = false;
        
        switch(*numSwitchPartie){
            case 0: //lancement de compte a rebour
                AfficheDiffPartie(modeChoisie);
                lcd.DisplayStringAt(0,160,(uint8_t *)"3",CENTER_MODE);
                if(CNY70.read()<0.1){
                    *numSwitchPartie=1; //verification si poignee est la
                    timePartie.reset();
                }
                break;
            case 1: //compte a rebour
                AfficheDiffPartie(modeChoisie);
                if(timePartie.read()>1)*numSwitchPartie=2;
                break;
                
            case 2: //compte a rebour
                AfficheDiffPartie(modeChoisie);
                lcd.DisplayStringAt(0,160,(uint8_t *)"2",CENTER_MODE);
                *numSwitchPartie=3;
                break;
            
            case 3: //compte a rebour
                
                if(timePartie.read()>2)*numSwitchPartie=4;
                break;
            
            case 4: //compte a rebour
                AfficheDiffPartie(modeChoisie);
                lcd.DisplayStringAt(0,160,(uint8_t *)"1",CENTER_MODE);
                *numSwitchPartie=5;
                break;
            
            case 5: //lancementde la partie
                
                if(timePartie.read()>3){
                    *numSwitchPartie=6;
                    lcd.Clear(0xffffffff);
                    timePartie.reset();
                }
                break;
                
            case 6: //affichage  du jeu
                lcd.SetTextColor(0xffff0000);
                lcd.DisplayStringAt(0,70,(uint8_t *)"GO",CENTER_MODE);
                lcd.DrawRect(170,130,125,50);
                lcd.DisplayStringAt(0,145,(uint8_t *)"STOP",CENTER_MODE);
                lcd.SetTextColor(0xff000000);
                lcd.DrawRect(260,200,200,50);
                lcd.DisplayStringAt(30,215,(uint8_t *)"Abandonner",RIGHT_MODE);
                
                lcd.DisplayStringAt(0,20,(uint8_t *)"Decoler le manche",CENTER_MODE);
                lcd.DisplayStringAtLine(9,(uint8_t *)"Timer");
                etatPartie=true;
                break;
                
        }
        
    return etatPartie;
}



bool GetRfid(char* pnum_badge,char caractRfid,int* pincreRfid){ //detection RFID
    
    bool readRfid=false;
    
    if(rfid.readable()) {
        caractRFID=rfid.getc();
        
        if(caractRFID==2){ //carect 2 = debut trame
            for(int i=0;i<20;i++){
                caractRFID=rfid.getc();
                if(caractRFID!=3)tabRfid[i]=caractRFID; //carect 3 = fin trame
                else{
                    readRfid=true;
                    i=20;
                    PC.printf("%s",tabRfid);       
                }
            }
        }
    }
    return readRfid;
}  
     
void AfficheClavier(void){ //affichage du clavier pour le mode setting
    
    int tailleCarres = 48,valMaxy=271;
    
    lcd.DisplayStringAt(0,20,(uint8_t *)" ENTRER UN NOM",CENTER_MODE);
    lcd.DisplayStringAtLine(4,(uint8_t *)nomTag);
    lcd.DisplayStringAt(0,145,(uint8_t *)" A  Z  E R  T  Y  U  I  O P",LEFT_MODE);
    lcd.DisplayStringAt(0,188,(uint8_t *)" Q  S  D F  G  H  J  K  L M",LEFT_MODE);
    lcd.DisplayStringAt(0,237,(uint8_t *)" W  X  C V  B  N  SUP  ENTER",LEFT_MODE);
    for(int i=0;i<10;i++){ //affichage des carres
        for(int j=0;j<3;j++){
            if(i>5 && j==0){
                if(i==6 || i==8)lcd.DrawRect((i*tailleCarres),(valMaxy-tailleCarres)-(j*tailleCarres),tailleCarres*2,tailleCarres); //rectangle enter et supp
            }
            else lcd.DrawRect((i*tailleCarres),(valMaxy-tailleCarres)-(j*tailleCarres),tailleCarres,tailleCarres);
        }
    }
    
}

int main() {

    
    char num_badge[20]={1}, *pnum_badge=&num_badge[0], caractRfid, oneCaractSetting;
    
    int numSwitchPrincipal=0,modePartie=-1,numSwitchPartie=0, * pnumSwitchPartie=&numSwitchPartie, increRfid=0, *pincreRfid=&increRfid, valMaxNomSetting=0;
 
    bool etatPartie=false;
    
    float cyclePWM=0.0, valCNY70=0.0;
    
    uint16_t tactileX, tactileY;
    uint8_t nbrPointTactile;
    
    exitPWM.period(0.00005f); //init PWM
    exitPWM.write(cyclePWM);
    
    PC.printf("Start\n");
    
    while(1) {
        
        //Partie traitemement tatile
        ts.GetState(&TS_State);
        //wait(0.01);
        nbrPointTactile=TS_State.touchDetected;
        if (nbrPointTactile > 0) {
            
            tactileX = TS_State.touchX[0];
            tactileY = TS_State.touchY[0];
            PC.printf("X : %d",tactileX);
            PC.printf("Y : %d",tactileY);
            
            
        }
        ////////////////////
        
        switch(numSwitchPrincipal){
            case 0:  //ecran aceuil
                PageAttentScan();
                if(GetRfid(pnum_badge,caractRfid,pincreRfid)){
                    wait(0.1);
                    lcd.Clear(0xffffffff);
                    numSwitchPrincipal=1;
                    
                }
                if(TouchScreenOk(429,479,221,271,tactileX,tactileY,nbrPointTactile)){ //BP pour ne pas utiliser le RFID
                    wait(0.1);
                    lcd.Clear(0xffffffff);
                    
                    numSwitchPrincipal=1;
                }
                break;
                
            case 1: //affichage bp lay et setting
                etatPartie=false;
                numSwitchPartie=0;
                PageAttentChoix(pnum_badge);
                numSwitchPrincipal=2;
                break;
                
            case 2: //choix bp
                
                if(TouchScreenOk(50,200,150,200,tactileX,tactileY,nbrPointTactile)){ //bp play
                    wait(0.1);
                    PC.printf("PB play 1\n");
                    numSwitchPrincipal=3;
                }
                if(TouchScreenOk(280,430,150,200,tactileX,tactileY,nbrPointTactile)){ //bp setting
                    wait(0.1);
                    lcd.Clear(0xffffffff);
                    AfficheClavier();
                    numSwitchPrincipal=8;
                }
                if(TouchScreenOk(358,478,220,270,tactileX,tactileY,nbrPointTactile)){ //BP Retour
                    lcd.Clear(0xffffffff);
                    numSwitchPrincipal=0;
                    for(int i=0;i<20;i++){
                        tabRfid[i]='\0';
                    }
                    for(int i=0;i<16;i++){
                        nomTag[i]='\0';
                    }
                    valMaxNomSetting=0;
                    
                    
                }
                break;
            case 3: //affichpb mode
                lcd.Clear(0xffffffff);
                PageDiff();
                numSwitchPrincipal=4;
                break;  
            case 4: //lancement debut game
             //0=easy 1=medium 2=hard
                if(TouchScreenOk(25,125,150,200,tactileX,tactileY,nbrPointTactile)){ //easy
                    timePartie.start();
                    numSwitchPrincipal=5;
                    lcd.Clear(0xffffffff);
                    modePartie=0;
                }
                else if(TouchScreenOk(170,295,150,200,tactileX,tactileY,nbrPointTactile)){ //medium
                    timePartie.start();
                    numSwitchPrincipal=5;
                    lcd.Clear(0xffffffff);
                    modePartie=1;
                }
                else if(TouchScreenOk(359,459,150,200,tactileX,tactileY,nbrPointTactile)){ //hard
                    timePartie.start();
                    numSwitchPrincipal=5;
                    lcd.Clear(0xffffffff);
                    modePartie=2;
                }
                break;
                
                
           
            case 5: //fin initialisation game
                cyclePWM=1.0;
                exitPWM.write(cyclePWM);
                etatPartie=StartPartie(modePartie,pnumSwitchPartie); //fin de la partie Start de la game
                if(etatPartie==true){
                    if(modePartie==0)cyclePWM=0.65;
                    else if(modePartie==1)cyclePWM=0.70;
                    else if(modePartie==2)cyclePWM=0.75;
                    //exitPWM.write(cyclePWM);
                    numSwitchPrincipal=6;
                    
                }
                break;
                
            case 6: //debut de la partie
                valCNY70=CNY70.read();
                sprintf(charTimer, "%3.2f", timePartie.read());
                lcd.DisplayStringAtLine(10,(uint8_t *)charTimer); //affichage du chronometre
                
                if(TouchScreenOk(170,295,130,180,tactileX,tactileY,nbrPointTactile)){ //PB stop 
                    timePartie.stop();
                    sprintf(charTimer, "%f", timePartie.read());
                    timePartie.reset();
                    cyclePWM=0.0;
                    lcd.Clear(0xffffffff);
                    numSwitchPrincipal=7;
                    AfficheWin();
                    
                }
                if(valCNY70>0.7){ //Si poignee retire
                    timePartie.stop();
                    sprintf(charTimer, "%f", timePartie.read());
                    timePartie.reset();
                    cyclePWM=0.0;
                    lcd.Clear(0xffffffff);
                    numSwitchPrincipal=7;
                    AfficheWin();
                }
                if(TouchScreenOk(260,460,200,250,tactileX,tactileY,nbrPointTactile)){ //BP Abandonner
                    timePartie.stop();
                    timePartie.reset();
                    lcd.Clear(0xffffffff);
                    numSwitchPrincipal=1;
                    cyclePWM=0;
                }
                exitPWM.write(cyclePWM);
                break;
                
            case 7: //fin de la partie
                cyclePWM=0.0;
                exitPWM.write(cyclePWM);
                
                if(TouchScreenOk(260,460,200,250,tactileX,tactileY,nbrPointTactile)){ //BP Retour
                    lcd.Clear(0xffffffff);
                    numSwitchPrincipal=1;
                }
                
                break;
                
            case 8: //setting
                wait(0.1);
                oneCaractSetting= TouchScreenChar();
                if(oneCaractSetting!=' '){
                    if(oneCaractSetting=='s'){ //supprimer
                        nomTag[valMaxNomSetting-1]='\0';
                        if(valMaxNomSetting>0)valMaxNomSetting--;
                        lcd.ClearStringLine(3);
                        lcd.DisplayStringAtLine(3,(uint8_t *)nomTag);
                    }
                    else if(oneCaractSetting=='e' && valMaxNomSetting>0){ //enter
                        lcd.Clear(0xffffffff);
                        PageAttentChoix(pnum_badge);
                        numSwitchPrincipal=2; 
                        wait(0.1);
                    }
                    else if(valMaxNomSetting<15 && oneCaractSetting!='s' && oneCaractSetting!='e'){ //ajouter la lettre selectionne max 15 caracteres 
                        nomTag[valMaxNomSetting]=oneCaractSetting;
                        valMaxNomSetting++;
                        lcd.ClearStringLine(3);
                        lcd.DisplayStringAtLine(3,(uint8_t *)nomTag);
                    }

                }
                
                break;
            
        }
                   
    }
}
