// Hello World! for the TextLCD

#include "mbed.h"

// +++++++++++++ timer section +++++++++++++++++ 
Ticker can_ticker;
Ticker adc_ticker;

// ++++++++++++ pin section +++++++++++++++++++++
// used as indicator
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);

// voltage inputs
AnalogIn ainp15 (p15);
AnalogIn ainp16 (p16);
AnalogIn ainp17 (p17);
AnalogIn ainp18 (p18);
AnalogIn ainp19 (p19);
AnalogIn ainp20 (p20);

// used to output the adc values on CAN bus
CAN can1(p30, p29);
 
 
// ++++++++++ variables section +++++++++++++++++++
char can1_arrry[8];
char can2_arrry[8];
char can3_arrry[8];

// used to convert float values into char segments for CAN transmission 
union { float a; char b[4];} adcvar1;
union { float a; char b[4];} adcvar2;
union { float a; char b[4];} adcvar3;
union { float a; char b[4];} adcvar4;
union { float a; char b[4];} adcvar5;
union { float a; char b[4];} adcvar6;
 
  
// ++++++++++++++ function section ++++++++++++++++

void send_msg() 
{    
    // send the can messages with the adc vales each 10 ms

    if(can1.write(CANMessage(0x200, can1_arrry, 8))) 
    {
      // show success
      led2 = !led2;
    }
    else
      led1 = 0;
      
      
    if(can1.write(CANMessage(0x201, can2_arrry, 8))) 
    {
      // show success
      led3 = !led3;
    }
    else
      led1 = 0;      
    
    
    if(can1.write(CANMessage(0x202, can3_arrry, 8))) 
    {
      // show success
      led4 = !led4;
    }
    else
      led1 = 0;      
            
      
} // void send_msg()
 
 
void read_adc()
{     
     adcvar1.a = ainp15;
     adcvar2.a = ainp16;
     adcvar3.a = ainp17;
     adcvar4.a = ainp18;
     adcvar5.a = ainp19;
     adcvar6.a = ainp20;
 
     // adc values from pin15 and pin16 are prepared for transmission
     can1_arrry[0] = adcvar1.b[0];
     can1_arrry[1] = adcvar1.b[1];
     can1_arrry[2] = adcvar1.b[2];
     can1_arrry[3] = adcvar1.b[3];
     can1_arrry[4] = adcvar2.b[0];
     can1_arrry[5] = adcvar2.b[1];
     can1_arrry[6] = adcvar2.b[2];
     can1_arrry[7] = adcvar2.b[3];
 
     // adc values from pin17 and pin18 are prepared for transmission
     can2_arrry[0] = adcvar3.b[0];
     can2_arrry[1] = adcvar3.b[1];
     can2_arrry[2] = adcvar3.b[2];
     can2_arrry[3] = adcvar3.b[3];
     can2_arrry[4] = adcvar4.b[0];
     can2_arrry[5] = adcvar4.b[1];
     can2_arrry[6] = adcvar4.b[2];
     can2_arrry[7] = adcvar4.b[3];
 
     // adc values from pin19 and pin20 are prepared for transmission
     can3_arrry[0] = adcvar5.b[0];
     can3_arrry[1] = adcvar5.b[1];
     can3_arrry[2] = adcvar5.b[2];
     can3_arrry[3] = adcvar5.b[3];
     can3_arrry[4] = adcvar6.b[0];
     can3_arrry[5] = adcvar6.b[1];
     can3_arrry[6] = adcvar6.b[2];
     can3_arrry[7] = adcvar6.b[3];
      
} // void read_adc()

 
 // ++++++++++++ main section ++++++++++++++++++
 
int main() 
{
    // leds are switched off at start
    led1 = 0;
    led2 = 0;
    led3 = 0;
    led4 = 0;
    
    // set can bus speed (not all possible combinations can be written to a common CAN controller (btr0 and btr1 registers))
    can1.frequency (125000);
   
    // configure timer for can message transmission
    can_ticker.attach(&send_msg, 0.01);
    
    // configure timer to get analogg inputs    
    adc_ticker.attach(&read_adc, 0.01);
    
    // dummy message to receive a CAN message
    CANMessage msg;
    
    while(1)
    {
        if(can1.read(msg))
        {
              // switch on led1, when a message has been received
              led1 = !led1;
        } 
        wait(0.2);
    }
} // main