#ifndef EFFECTS_H
#define EFFECTS_H

#include "mbed.h"
#include "LEDs.h"
#include "Rotary.h"

class Effects {
  public:
    Effects(LEDs *_leds);
    void doEffect(uint8_t effect, Rotary::Action action);
    void noEffect();

  private:
    void scroll(uint32_t ms, Rotary::Action action);
    void knightRider(uint32_t ms);
    void blink(bool firstTime, Rotary::Action action);
    void makeRainbow(bool firstTime, uint32_t ms, Rotary::Action action);
    void colorChase(uint32_t ms, Rotary::Action action);
    void leftRightColorFade(uint32_t ms, Rotary::Action action);

    LEDs *leds;
    uint32_t lastUpdate;
    uint8_t lastEffect;
    Timer timer;
};

#endif
