#include "EffectPlugs.h"

EffectPlugs::EffectPlugs(uint8_t _num, DigitalInOut *_pins) 
{
  num = _num;
  pins = _pins;
  
  for (uint8_t i = 0; i < num; i++) 
  {
    pins[i].input();
    pins[i].mode(PullUp);
  }
}

uint8_t EffectPlugs::pluggedConnection() 
{
  uint8_t connection = 0, foundConnection = 0;
  for (uint8_t i = 0; i < num; i++) 
  {
    pins[i].output();
    pins[i].write(0);
    
    for (uint8_t j = i + 1; j < num; j++) 
    {
      connection++;
      if (pins[j].read() == 0) 
        foundConnection = connection;
    }
    pins[i].input();
    pins[i].mode(PullUp);
  }
  return foundConnection;
}
