#ifndef LEDS_H
#define LEDS_H

#include "mbed.h"
#include "board.h"
#include "EEPROM.h"
#include "PololuLedStrip.h"

#define LEDS_MAIN_STRIP_TOGGLE_OFFSET 5

typedef struct hsv_color
{
    unsigned char h;
    unsigned char s;
    unsigned char v;
} hsv_color;

class LEDs {
  public:
    LEDs(PinName main, PinName single);
    void updateSingleLED(uint8_t colorH, uint8_t colorS, uint8_t colorV);
    void updateStripLED(uint8_t index, uint8_t colorH, uint8_t colorS, uint8_t colorV);
    void setStripLED(uint8_t index, uint8_t colorH, uint8_t colorS, uint8_t colorV);
    void setStripLEDRGB(uint8_t index, uint8_t colorH, uint8_t colorS, uint8_t colorV);
    void turnOffStripLED(uint8_t index);
    bool isStripLEDOn(uint8_t index);
    void scrollStripToLeft();
    void scrollStripToRight();
    void off();
    void show();
    void saveStateToEEPROM();
    void loadStateFromEEPROM();
    void loadStateFromEEPROMAndDim(uint8_t dimAmount);
    void fadeToBlackBy(uint8_t amount, rgb_color& colour);
    rgb_color mainColours[LEDS_MAIN_STRIP_NUM_LEDS];
    rgb_color singleColours[LEDS_SINGLE_STRIP_NUM_LEDS];
  private:
    hsv_color RgbToHsv(rgb_color rgb);
    rgb_color HsvToRgb(hsv_color hsv);
  
    PololuLedStrip mainStrip;
    PololuLedStrip singleStrip;
    
    uint8_t currentIndex;
    EEPROM eeprom;
};

#endif
