#include "Pulser.h"

Pulser::Pulser(PinName _pin):
out(_pin)
{
  lastUpdate = 0;
  value = 65535;
  direction = -256;
  timer.start();
}

void Pulser::pulse() {
  uint32_t now = timer.read_ms();
  while (now - lastUpdate > delay) {
    lastUpdate += delay;
    value += direction;
    if (value >= 69120 || value <= 53760) direction = -direction;
  }
  if (value < 65535) out.write_u16(value);
}

void Pulser::steady() {
  out.write_u16(32768);
}

void Pulser::off() {
  out.write_u16(0);
  value = 65535;
  direction = -256;
  lastUpdate = timer.read_ms();
}
