#ifndef ROTARY_H
#define ROTARY_H

#include "mbed.h"

class Rotary {
  public:
    enum Action {
      NONE, LEFT, RIGHT, TIMEOUT
    };

#ifdef DEV
		static const uint32_t TIMEOUT_MILLIS = 20 * 1000UL;
#else
		static const uint32_t TIMEOUT_MILLIS = 120 * 1000UL;
#endif

    Rotary(PinName _pinA, PinName _pinB);
    Action read();
    Action waitForAction();

  private:
    uint8_t _prevPos, _flags;
    DigitalIn pinA, pinB;
    uint8_t readEnc();
};

#endif
