# example-mbedos-blinky

Blinky is a simple example program that blinks an LED on an mbed-enabled board with mbed OS.

[![arch-ble-gcc](https://x1j4rqb9of.execute-api.us-west-2.amazonaws.com/badge/thegecko/example-mbedos-blinky/arch-ble-gcc?circle-token=29093fffa8e4086f715e03dd0e3a4c150ab09f9d)](http://yotta.mbed.com/#/target/arch-ble-gcc)

[![arch-link-gcc](https://x1j4rqb9of.execute-api.us-west-2.amazonaws.com/badge/thegecko/example-mbedos-blinky/arch-link-gcc?circle-token=29093fffa8e4086f715e03dd0e3a4c150ab09f9d)](http://yotta.mbed.com/#/target/arch-link-gcc)

[![atmel-samd21g18a-gcc](https://x1j4rqb9of.execute-api.us-west-2.amazonaws.com/badge/thegecko/example-mbedos-blinky/atmel-samd21g18a-gcc?circle-token=29093fffa8e4086f715e03dd0e3a4c150ab09f9d)](http://yotta.mbed.com/#/target/atmel-samd21g18a-gcc)

[![atmel-samg55j19-gcc](https://x1j4rqb9of.execute-api.us-west-2.amazonaws.com/badge/thegecko/example-mbedos-blinky/atmel-samg55j19-gcc?circle-token=29093fffa8e4086f715e03dd0e3a4c150ab09f9d)](http://yotta.mbed.com/#/target/atmel-samg55j19-gcc)

[![atmel-samr21g18a-gcc](https://x1j4rqb9of.execute-api.us-west-2.amazonaws.com/badge/thegecko/example-mbedos-blinky/atmel-samr21g18a-gcc?circle-token=29093fffa8e4086f715e03dd0e3a4c150ab09f9d)](http://yotta.mbed.com/#/target/atmel-samr21g18a-gcc)

[![bbc-microbit-classic-gcc-nosd](https://x1j4rqb9of.execute-api.us-west-2.amazonaws.com/badge/thegecko/example-mbedos-blinky/bbc-microbit-classic-gcc-nosd?circle-token=29093fffa8e4086f715e03dd0e3a4c150ab09f9d)](http://yotta.mbed.com/#/target/bbc-microbit-classic-gcc-nosd)

[![bbc-microbit-classic-gcc-s130](https://x1j4rqb9of.execute-api.us-west-2.amazonaws.com/badge/thegecko/example-mbedos-blinky/bbc-microbit-classic-gcc-s130?circle-token=29093fffa8e4086f715e03dd0e3a4c150ab09f9d)](http://yotta.mbed.com/#/target/bbc-microbit-classic-gcc-s130)

[![bbc-microbit-classic-gcc](https://x1j4rqb9of.execute-api.us-west-2.amazonaws.com/badge/thegecko/example-mbedos-blinky/bbc-microbit-classic-gcc?circle-token=29093fffa8e4086f715e03dd0e3a4c150ab09f9d)](http://yotta.mbed.com/#/target/bbc-microbit-classic-gcc)

[![bbc-microbit-gcc](https://x1j4rqb9of.execute-api.us-west-2.amazonaws.com/badge/thegecko/example-mbedos-blinky/bbc-microbit-gcc?circle-token=29093fffa8e4086f715e03dd0e3a4c150ab09f9d)](http://yotta.mbed.com/#/target/bbc-microbit-gcc)

[![blenano-gcc](https://x1j4rqb9of.execute-api.us-west-2.amazonaws.com/badge/thegecko/example-mbedos-blinky/blenano-gcc?circle-token=29093fffa8e4086f715e03dd0e3a4c150ab09f9d)](http://yotta.mbed.com/#/target/blenano-gcc)

[![efm32gg-stk-gcc](https://x1j4rqb9of.execute-api.us-west-2.amazonaws.com/badge/thegecko/example-mbedos-blinky/efm32gg-stk-gcc?circle-token=29093fffa8e4086f715e03dd0e3a4c150ab09f9d)](http://yotta.mbed.com/#/target/efm32gg-stk-gcc)

[![efm32hg-stk-gcc](https://x1j4rqb9of.execute-api.us-west-2.amazonaws.com/badge/thegecko/example-mbedos-blinky/efm32hg-stk-gcc?circle-token=29093fffa8e4086f715e03dd0e3a4c150ab09f9d)](http://yotta.mbed.com/#/target/efm32hg-stk-gcc)

[![efm32lg-stk-gcc](https://x1j4rqb9of.execute-api.us-west-2.amazonaws.com/badge/thegecko/example-mbedos-blinky/efm32lg-stk-gcc?circle-token=29093fffa8e4086f715e03dd0e3a4c150ab09f9d)](http://yotta.mbed.com/#/target/efm32lg-stk-gcc)

[![efm32wg-stk-gcc](https://x1j4rqb9of.execute-api.us-west-2.amazonaws.com/badge/thegecko/example-mbedos-blinky/efm32wg-stk-gcc?circle-token=29093fffa8e4086f715e03dd0e3a4c150ab09f9d)](http://yotta.mbed.com/#/target/efm32wg-stk-gcc)

[![frdm-k22f-gcc](https://x1j4rqb9of.execute-api.us-west-2.amazonaws.com/badge/thegecko/example-mbedos-blinky/frdm-k22f-gcc?circle-token=29093fffa8e4086f715e03dd0e3a4c150ab09f9d)](http://yotta.mbed.com/#/target/frdm-k22f-gcc)

[![frdm-k64f-gcc](https://x1j4rqb9of.execute-api.us-west-2.amazonaws.com/badge/thegecko/example-mbedos-blinky/frdm-k64f-gcc?circle-token=29093fffa8e4086f715e03dd0e3a4c150ab09f9d)](http://yotta.mbed.com/#/target/frdm-k64f-gcc)

[![frdm-k64f-st-ble-gcc](https://x1j4rqb9of.execute-api.us-west-2.amazonaws.com/badge/thegecko/example-mbedos-blinky/frdm-k64f-st-ble-gcc?circle-token=29093fffa8e4086f715e03dd0e3a4c150ab09f9d)](http://yotta.mbed.com/#/target/frdm-k64f-st-ble-gcc)

[![k64f-gcc](https://x1j4rqb9of.execute-api.us-west-2.amazonaws.com/badge/thegecko/example-mbedos-blinky/k64f-gcc?circle-token=29093fffa8e4086f715e03dd0e3a4c150ab09f9d)](http://yotta.mbed.com/#/target/k64f-gcc)

[![kinetis-k22f-gcc](https://x1j4rqb9of.execute-api.us-west-2.amazonaws.com/badge/thegecko/example-mbedos-blinky/kinetis-k22f-gcc?circle-token=29093fffa8e4086f715e03dd0e3a4c150ab09f9d)](http://yotta.mbed.com/#/target/kinetis-k22f-gcc)

[![kinetis-k64-gcc](https://x1j4rqb9of.execute-api.us-west-2.amazonaws.com/badge/thegecko/example-mbedos-blinky/kinetis-k64-gcc?circle-token=29093fffa8e4086f715e03dd0e3a4c150ab09f9d)](http://yotta.mbed.com/#/target/kinetis-k64-gcc)

[![lex-test-gcc](https://x1j4rqb9of.execute-api.us-west-2.amazonaws.com/badge/thegecko/example-mbedos-blinky/lex-test-gcc?circle-token=29093fffa8e4086f715e03dd0e3a4c150ab09f9d)](http://yotta.mbed.com/#/target/lex-test-gcc)

[![mbed-gcc](https://x1j4rqb9of.execute-api.us-west-2.amazonaws.com/badge/thegecko/example-mbedos-blinky/mbed-gcc?circle-token=29093fffa8e4086f715e03dd0e3a4c150ab09f9d)](http://yotta.mbed.com/#/target/mbed-gcc)

[![mkit-gcc](https://x1j4rqb9of.execute-api.us-west-2.amazonaws.com/badge/thegecko/example-mbedos-blinky/mkit-gcc?circle-token=29093fffa8e4086f715e03dd0e3a4c150ab09f9d)](http://yotta.mbed.com/#/target/mkit-gcc)

[![nordic-nrf51822-16k-gcc](https://x1j4rqb9of.execute-api.us-west-2.amazonaws.com/badge/thegecko/example-mbedos-blinky/nordic-nrf51822-16k-gcc?circle-token=29093fffa8e4086f715e03dd0e3a4c150ab09f9d)](http://yotta.mbed.com/#/target/nordic-nrf51822-16k-gcc)

[![nordic-nrf51822-32k-gcc](https://x1j4rqb9of.execute-api.us-west-2.amazonaws.com/badge/thegecko/example-mbedos-blinky/nordic-nrf51822-32k-gcc?circle-token=29093fffa8e4086f715e03dd0e3a4c150ab09f9d)](http://yotta.mbed.com/#/target/nordic-nrf51822-32k-gcc)

[![nordic-nrf51822-gcc-unofficial-fota](https://x1j4rqb9of.execute-api.us-west-2.amazonaws.com/badge/thegecko/example-mbedos-blinky/nordic-nrf51822-gcc-unofficial-fota?circle-token=29093fffa8e4086f715e03dd0e3a4c150ab09f9d)](http://yotta.mbed.com/#/target/nordic-nrf51822-gcc-unofficial-fota)

[![nordic-nrf51822-gcc-unofficial-no-softdevice](https://x1j4rqb9of.execute-api.us-west-2.amazonaws.com/badge/thegecko/example-mbedos-blinky/nordic-nrf51822-gcc-unofficial-no-softdevice?circle-token=29093fffa8e4086f715e03dd0e3a4c150ab09f9d)](http://yotta.mbed.com/#/target/nordic-nrf51822-gcc-unofficial-no-softdevice)

[![nordic-nrf51822-gcc-unofficial](https://x1j4rqb9of.execute-api.us-west-2.amazonaws.com/badge/thegecko/example-mbedos-blinky/nordic-nrf51822-gcc-unofficial?circle-token=29093fffa8e4086f715e03dd0e3a4c150ab09f9d)](http://yotta.mbed.com/#/target/nordic-nrf51822-gcc-unofficial)

[![nordic-nrf51822-gcc](https://x1j4rqb9of.execute-api.us-west-2.amazonaws.com/badge/thegecko/example-mbedos-blinky/nordic-nrf51822-gcc?circle-token=29093fffa8e4086f715e03dd0e3a4c150ab09f9d)](http://yotta.mbed.com/#/target/nordic-nrf51822-gcc)

[![nrf51dk-gcc](https://x1j4rqb9of.execute-api.us-west-2.amazonaws.com/badge/thegecko/example-mbedos-blinky/nrf51dk-gcc?circle-token=29093fffa8e4086f715e03dd0e3a4c150ab09f9d)](http://yotta.mbed.com/#/target/nrf51dk-gcc)

[![nxp-lpc111x-gcc](https://x1j4rqb9of.execute-api.us-west-2.amazonaws.com/badge/thegecko/example-mbedos-blinky/nxp-lpc111x-gcc?circle-token=29093fffa8e4086f715e03dd0e3a4c150ab09f9d)](http://yotta.mbed.com/#/target/nxp-lpc111x-gcc)

[![nxp-lpc1768-gcc](https://x1j4rqb9of.execute-api.us-west-2.amazonaws.com/badge/thegecko/example-mbedos-blinky/nxp-lpc1768-gcc?circle-token=29093fffa8e4086f715e03dd0e3a4c150ab09f9d)](http://yotta.mbed.com/#/target/nxp-lpc1768-gcc)

[![nxpdk5-jn517x-gcc](https://x1j4rqb9of.execute-api.us-west-2.amazonaws.com/badge/thegecko/example-mbedos-blinky/nxpdk5-jn517x-gcc?circle-token=29093fffa8e4086f715e03dd0e3a4c150ab09f9d)](http://yotta.mbed.com/#/target/nxpdk5-jn517x-gcc)

[![redbearlab-nrf51822-gcc](https://x1j4rqb9of.execute-api.us-west-2.amazonaws.com/badge/thegecko/example-mbedos-blinky/redbearlab-nrf51822-gcc?circle-token=29093fffa8e4086f715e03dd0e3a4c150ab09f9d)](http://yotta.mbed.com/#/target/redbearlab-nrf51822-gcc)

[![seeedtinyble-gcc](https://x1j4rqb9of.execute-api.us-west-2.amazonaws.com/badge/thegecko/example-mbedos-blinky/seeedtinyble-gcc?circle-token=29093fffa8e4086f715e03dd0e3a4c150ab09f9d)](http://yotta.mbed.com/#/target/seeedtinyble-gcc)

[![st-nucleo-f091rc-gcc](https://x1j4rqb9of.execute-api.us-west-2.amazonaws.com/badge/thegecko/example-mbedos-blinky/st-nucleo-f091rc-gcc?circle-token=29093fffa8e4086f715e03dd0e3a4c150ab09f9d)](http://yotta.mbed.com/#/target/st-nucleo-f091rc-gcc)

[![st-nucleo-f401re-gcc](https://x1j4rqb9of.execute-api.us-west-2.amazonaws.com/badge/thegecko/example-mbedos-blinky/st-nucleo-f401re-gcc?circle-token=29093fffa8e4086f715e03dd0e3a4c150ab09f9d)](http://yotta.mbed.com/#/target/st-nucleo-f401re-gcc)

[![st-nucleo-f401re-st-ble-gcc](https://x1j4rqb9of.execute-api.us-west-2.amazonaws.com/badge/thegecko/example-mbedos-blinky/st-nucleo-f401re-st-ble-gcc?circle-token=29093fffa8e4086f715e03dd0e3a4c150ab09f9d)](http://yotta.mbed.com/#/target/st-nucleo-f401re-st-ble-gcc)

[![st-stm32f439zi-gcc](https://x1j4rqb9of.execute-api.us-west-2.amazonaws.com/badge/thegecko/example-mbedos-blinky/st-stm32f439zi-gcc?circle-token=29093fffa8e4086f715e03dd0e3a4c150ab09f9d)](http://yotta.mbed.com/#/target/st-stm32f439zi-gcc)

[![stk3700-gcc](https://x1j4rqb9of.execute-api.us-west-2.amazonaws.com/badge/thegecko/example-mbedos-blinky/stk3700-gcc?circle-token=29093fffa8e4086f715e03dd0e3a4c150ab09f9d)](http://yotta.mbed.com/#/target/stk3700-gcc)

[![stm32f4-disco-gcc](https://x1j4rqb9of.execute-api.us-west-2.amazonaws.com/badge/thegecko/example-mbedos-blinky/stm32f4-disco-gcc?circle-token=29093fffa8e4086f715e03dd0e3a4c150ab09f9d)](http://yotta.mbed.com/#/target/stm32f4-disco-gcc)

[![stm32f411e-disco-gcc](https://x1j4rqb9of.execute-api.us-west-2.amazonaws.com/badge/thegecko/example-mbedos-blinky/stm32f411e-disco-gcc?circle-token=29093fffa8e4086f715e03dd0e3a4c150ab09f9d)](http://yotta.mbed.com/#/target/stm32f411e-disco-gcc)

[![stm32f411re-nucleo-gcc](https://x1j4rqb9of.execute-api.us-west-2.amazonaws.com/badge/thegecko/example-mbedos-blinky/stm32f411re-nucleo-gcc?circle-token=29093fffa8e4086f715e03dd0e3a4c150ab09f9d)](http://yotta.mbed.com/#/target/stm32f411re-nucleo-gcc)

[![stm32f429i-disco-gcc](https://x1j4rqb9of.execute-api.us-west-2.amazonaws.com/badge/thegecko/example-mbedos-blinky/stm32f429i-disco-gcc?circle-token=29093fffa8e4086f715e03dd0e3a4c150ab09f9d)](http://yotta.mbed.com/#/target/stm32f429i-disco-gcc)

[![target-onsemi-ncs36510-gcc](https://x1j4rqb9of.execute-api.us-west-2.amazonaws.com/badge/thegecko/example-mbedos-blinky/target-onsemi-ncs36510-gcc?circle-token=29093fffa8e4086f715e03dd0e3a4c150ab09f9d)](http://yotta.mbed.com/#/target/target-onsemi-ncs36510-gcc)

[![tinyble-gcc](https://x1j4rqb9of.execute-api.us-west-2.amazonaws.com/badge/thegecko/example-mbedos-blinky/tinyble-gcc?circle-token=29093fffa8e4086f715e03dd0e3a4c150ab09f9d)](http://yotta.mbed.com/#/target/tinyble-gcc)

[![ublox-c029-gcc](https://x1j4rqb9of.execute-api.us-west-2.amazonaws.com/badge/thegecko/example-mbedos-blinky/ublox-c029-gcc?circle-token=29093fffa8e4086f715e03dd0e3a4c150ab09f9d)](http://yotta.mbed.com/#/target/ublox-c029-gcc)

[![ublox-odin-w2-evk-gcc](https://x1j4rqb9of.execute-api.us-west-2.amazonaws.com/badge/thegecko/example-mbedos-blinky/ublox-odin-w2-evk-gcc?circle-token=29093fffa8e4086f715e03dd0e3a4c150ab09f9d)](http://yotta.mbed.com/#/target/ublox-odin-w2-evk-gcc)

[![ublox-odin-w2-gcc](https://x1j4rqb9of.execute-api.us-west-2.amazonaws.com/badge/thegecko/example-mbedos-blinky/ublox-odin-w2-gcc?circle-token=29093fffa8e4086f715e03dd0e3a4c150ab09f9d)](http://yotta.mbed.com/#/target/ublox-odin-w2-gcc)

[![xdk110-gcc](https://x1j4rqb9of.execute-api.us-west-2.amazonaws.com/badge/thegecko/example-mbedos-blinky/xdk110-gcc?circle-token=29093fffa8e4086f715e03dd0e3a4c150ab09f9d)](http://yotta.mbed.com/#/target/xdk110-gcc)

## What Blinky does

This is a short review of the Blinky code. More information is available on the user guide, where we explain [how to write mbed OS applications](https://docs.mbed.com/docs/getting-started-mbed-os/en/latest/Full_Guide/app_on_mbed_os/) and how to [work with yotta](https://docs.mbed.com/docs/getting-started-mbed-os/en/latest/Full_Guide/app_on_yotta/).

1. The code begins with ``include``. The included header is ``mbed.h``, from the ``mbed-drivers`` library. It is a key library for mbed OS, and includes most of the functionality standard applications need. yotta, our build system, includes ``mbed-drivers`` during compilation because that library is listed as a dependency in Blinky's ``module.json`` file.

1. mbed OS applications start with ``app_start``, replacing ``main``.

1. MINAR is the mbed OS scheduler; we use it here to create a callback that will run every 500 milliseconds. The function we're running is ``blinky``.

1. ``blinky`` creates a DigitalOut using the LED1 on our board. It then turns the LED on and off and prints its status to the terminal using ``printf``.


**Tip:** To learn more about writing applications for mbed OS, see the [mbed OS user guide's review of Blinky](https://docs.mbed.com/docs/getting-started-mbed-os/en/latest/Full_Guide/app_on_mbed_os/).


## Building the example

### If you're using yotta as a command-line tool

**Tip:** If you need help setting up yotta or building a project, see our [quick guide](https://docs.mbed.com/docs/getting-started-mbed-os/en/latest/FirstProjectmbedOS/), which uses the same example.

To build Blinky with yotta as a command-line tool:

1. Clone the repository from GitHub:

	```
	$ git clone https://github.com/ARMmbed/example-mbedos-blinky.git
	$ cd example-mbedos-blinky
	```

2. Select a target platform:

	```
	$ yotta target frdm-k64f-gcc
	```

3. Build it:

	```
	$ yotta build
	... bunch of build messages ...
	[135/135] Linking CXX executable source/example-mbedos-blinky
	```

yotta will put the compiled binary in the project's `/build` folder. Copy the binary  `/build/frdm-k64f-gcc/source/example-mbedos-blinky.bin` to your mbed board over USB.

### If you're on the online IDE

**Tip:** If you need help getting started with the IDE, see our [quick guide](https://docs.mbed.com/docs/getting-started-mbed-os/en/latest/FirstProjectmbedOS/), which uses the same example.

To build Blinky in your IDE workspace:

1. The IDE needs to know which target to build for. Click *Target*:
 
 1. The list displays your recently used targets. If the target you need is listed, click it.
 
 1. If your target isn't in the drop-down list, click *Search in Registry*. A list of targets opens. Select your target and click *Set*.

1. Click *Build Project*.

The IDE will build the project as a binary file and ask you to download it. When the download finishes, copy the file to your mbed board over USB.
