/*************************************************************************************
Program Name: Elevator Project 1
Description:
Author: 3/C Grace Vandegrift & 3/C Tina Li
Date: 17 APR 19
**************************************************************************************/

/************** Libraries ******************************************/
#include "mbed.h"
#include "QEI.h"
#include "Motor.h"

/************** Declare Objects ******************************************/
Serial pc(USBTX, USBRX);
Motor mot(p25,p27,p28);
QEI encoder(p5,p6,NC,64,QEI::X4_ENCODING);
PwmOut dummyPwm(p23);       //[DO NOT MODIFY] Dummy variable used to set the PWM period of all signals

/************** Declare and Initialize Variables and Parameters ************/
//[Insert] For example: Define and initialize the coefficients of your polynomial fit, measurements,
//[Insert] Define duty cycle variable to be sent to the motor, error variables, etc...
//[Insert] Define control parameters, Pwm value to hold the elevator in place, Kp, Ki, etc....

/************** duration variables to regulate execution of code **************/
Timer t;                        //[DO NOT MODIFY] Timer to regulate control sequence
Timer tlog;                   //[DO NOT MODIFY] durationr to log data
float dt;                       //[DO NOT MODIFY] Variable to measure duration window left in program
float Fs = 20.0;           //[TO BE MODIFIED by USER using TERA TERM] Sampling Frequency (default of 20 Hz)
float height;
float duration;
float encoderReading;
float heighterror;
float dcHold1 = 0.4375;
float actualheight;
float dc = 0;
float value1 = 0.01943613;
float value2 = 5.86406040;

int main()
{

    pc.baud(115200);

    pc.printf(" choose from the following controllers: \n");
    pc.printf("a) Logic Controller \n");
    pc.printf("b) Proportional Controller \n");
    pc.printf("c) Proportional Integral Controller \n");
    pc.printf("d) Proportional Integral Derivative Controller \n");

    char userOption = pc.getc();

    if (userOption == 'a') {

        while(1) {                      //[DO NOT MODIFY WHILE LINE] Indefinite while loop
            dummyPwm.period(0.00005);       //[DO NOT MODIFY] This sets the period of all PWM signals to 0.00005 sec

            mot.speed(0);  //Set motor speed to zero. Always set the motor speed to zero before starting an experiment
            pc.printf("\n Enter Height: \n\r");
            pc.scanf("%f", &height);
            pc.printf("\n Enter Duration: \n\r");
            pc.scanf("%f", &duration);

            pc.printf("\n Enter Frequency:\n\r");
            pc.scanf("%f", &Fs);

            //[INSERT] Use the commands of your choice (printf, putc, scanf, getc, any other) to give/ask instructions to user
            //[INSERT] Obtain and save parameters enter by user: desired height (as a float), sampling frequency (as a float named Fs)
            // and duration of experiment (as a float)

            wait(0.5);          //Small wait... to give you some duration
            t.start();          //[DO NOT MODIFY] Start durationr that regulate control sequence
            tlog.start();       //[DO NOT MODIFY] Start durationr that you will use to log duration data

            while(tlog.read() <= duration) {  //[INSERT] Modify condition in while loop must execute as long as specified by user.

                encoderReading = (float)encoder.getPulses(); //[INSERT] Here you should read the encoder
                actualheight = ((value1)* pow(encoderReading,1)) + ((value2)* pow(encoderReading,0)); //[INSERT] Using your calibration equation, convert encoder counts to height

                heighterror = height - actualheight; //[INSERT] Compute error = desired height - measured height

                //[LOGIC CONTROLLER]   Compute Duty Cycle for motor speed using Logic Control Algorithm (a series of if-else statements)

                if (heighterror > 0) {
                    dc = 0.2;
                } else if (heighterror < 0) {
                    dc = -0.2;
                } else {
                    dc = 0;
                }

                dc = dc + dcHold1;

                if (dc >= -1 && dc <= 1 ) {
                    mot.speed(1*dc);
                } else {
                    exit(0);
                }

                //[INSERT] Set speed of motor with duty cycle computed

                pc.printf(" %.3f \t  %.3f \t  %.3f \t  %.3f \t\n",tlog.read(), actualheight, heighterror,  dc);

                //[DO NOT MODIFY the following lines of code] This code makes sure the control sequence is executed every "1/Fs" seconds
                float Ts = 1/Fs;        //[DO NOT MODIFY] Ts is the control period, inverse of control sampling frequency
                dt = Ts-t.read();       //[DO NOT MODIFY]
                t.stop();           //[DO NOT MODIFY]
                t.reset();          //[DO NOT MODIFY]
                if (dt >= 0) {          //[DO NOT MODIFY]
                    wait(dt);       //[DO NOT MODIFY]
                }               //[DO NOT MODIFY]
                t.start();          //[DO NOT MODIFY]
            }               //[DO NOT MODIFY] End of Control While Loop
            t.stop();           //[DO NOT MODIFY]
            t.reset();          //[DO NOT MODIFY]
            tlog.stop();            //[DO NOT MODIFY] Stop and reset durationr used when logging data
            tlog.reset();           //[DO NOT MODIFY]

            mot.speed(0);

            //[INSERT] Set speed of motor to zero
        }
    } //End of indefinite while loop for Logic Controller

    else if (userOption == 'b') {
        float kp = 0.075;
        float dcHoldProp = 0.50;

        while(1) {                      //[DO NOT MODIFY WHILE LINE] Indefinite while loop
            dummyPwm.period(0.00005);       //[DO NOT MODIFY] This sets the period of all PWM signals to 0.00005 sec

            mot.speed(0);  //Set motor speed to zero. Always set the motor speed to zero before starting an experiment
            pc.printf("\nEnter Height: \n\r");
            pc.scanf("%f", &height);
            pc.printf("\nEnter Duration: \n\r");
            pc.scanf("%f", &duration);

            pc.printf("\nEnter Frequency:\n\r");
            pc.scanf("%f", &Fs);

            //[INSERT] Use the commands of your choice (printf, putc, scanf, getc, any other) to give/ask instructions to user
            //[INSERT] Obtain and save parameters enter by user: desired height (as a float), sampling frequency (as a float named Fs)
            // and duration of experiment (as a float)

            wait(0.5);          //Small wait... to give you some duration
            t.start();          //[DO NOT MODIFY] Start durationr that regulate control sequence
            tlog.start();       //[DO NOT MODIFY] Start durationr that you will use to log duration data

            while(tlog.read() <= duration) {  //[INSERT] Modify condition in while loop must execute as long as specified by user.

                encoderReading = (float)encoder.getPulses(); //[INSERT] Here you should read the encoder
                actualheight = ((value1)* pow(encoderReading,1)) + ((value2)* pow(encoderReading,0)); //[INSERT] Using your calibration equation, convert encoder counts to height

                heighterror = height - actualheight; //[INSERT] Compute error = desired height - measured height

                //[LOGIC CONTROLLER]   Compute Duty Cycle for motor speed using Logic Control Algorithm (a series of if-else statements)
                dc = kp * heighterror;
                dc = dc + dcHoldProp;

                if (dc >= -1 && dc <= 1 ) {
                    mot.speed(1*dc);
                } else {
                    dc == 1;
                    mot.speed(dc);
                }

                //[INSERT] Set speed of motor with duty cycle computed

                pc.printf("duration: %.3f \t, Measured Height: %.3f \t, Error Height: %.3f \t, Duty Cycle: %.3f \t\n",tlog.read(), actualheight, heighterror,  dc);

                //[DO NOT MODIFY the following lines of code] This code makes sure the control sequence is executed every "1/Fs" seconds
                float Ts = 1/Fs;        //[DO NOT MODIFY] Ts is the control period, inverse of control sampling frequency
                dt = Ts-t.read();       //[DO NOT MODIFY]
                t.stop();           //[DO NOT MODIFY]
                t.reset();          //[DO NOT MODIFY]
                if (dt >= 0) {          //[DO NOT MODIFY]
                    wait(dt);       //[DO NOT MODIFY]
                }               //[DO NOT MODIFY]
                t.start();          //[DO NOT MODIFY]
            }               //[DO NOT MODIFY] End of Control While Loop
            t.stop();           //[DO NOT MODIFY]
            t.reset();          //[DO NOT MODIFY]
            tlog.stop();            //[DO NOT MODIFY] Stop and reset durationr used when logging data
            tlog.reset();           //[DO NOT MODIFY]

            mot.speed(0);

            //[INSERT] Set speed of motor to zero
        }
    }

    else if (userOption == 'c') {
        float KpIntControl = 0.03;
        float ki = 0.105;
        float dcHoldInt = 0.45;

        while(1) {                      //[DO NOT MODIFY WHILE LINE] Indefinite while loop
            dummyPwm.period(0.00005);       //[DO NOT MODIFY] This sets the period of all PWM signals to 0.00005 sec

            mot.speed(0);  //Set motor speed to zero. Always set the motor speed to zero before starting an experiment
            pc.printf("\nEnter Height: \n\r");
            pc.scanf("%f", &height);
            pc.printf("\nEnter Duration: \n\r");
            pc.scanf("%f", &duration);

            pc.printf("\nEnter Frequency:\n\r");
            pc.scanf("%f", &Fs);

            //[INSERT] Use the commands of your choice (printf, putc, scanf, getc, any other) to give/ask instructions to user
            //[INSERT] Obtain and save parameters enter by user: desired height (as a float), sampling frequency (as a float named Fs)
            // and duration of experiment (as a float)

            wait(0.5);          //Small wait... to give you some duration
            t.start();          //[DO NOT MODIFY] Start durationr that regulate control sequence
            tlog.start();       //[DO NOT MODIFY] Start durationr that you will use to log duration data

            float intError = 0.0;

            while(tlog.read() <= duration) {  //[INSERT] Modify condition in while loop must execute as long as specified by user.

                encoderReading = (float)encoder.getPulses(); //[INSERT] Here you should read the encoder
                actualheight = ((value1)* pow(encoderReading,1)) + ((value2)* pow(encoderReading,0)); //[INSERT] Using your calibration equation, convert encoder counts to height
                heighterror = height - actualheight;

                intError = intError + heighterror*(1/Fs); //[INSERT] Compute error = desired height - measured height

                //[LOGIC CONTROLLER]   Compute Duty Cycle for motor speed using Logic Control Algorithm (a series of if-else statements)
                dc = KpIntControl*heighterror + ki*intError;
                dc = dc + dcHoldInt;


                if (dc >= -1 && dc <= 1 ) {
                    mot.speed(1*dc);
                } else {
                    dc = 1;
                    mot.speed(dc);
                }

                //[INSERT] Set speed of motor with duty cycle computed

                pc.printf("duration: %.3f \t Measured Height: %.3f \t Error Height: %.3f \t Duty Cycle: %f\n\r",tlog.read(), actualheight, heighterror,  dc);

                //[DO NOT MODIFY the following lines of code] This code makes sure the control sequence is executed every "1/Fs" seconds
                float Ts = 1/Fs;        //[DO NOT MODIFY] Ts is the control period, inverse of control sampling frequency
                dt = Ts-t.read();       //[DO NOT MODIFY]
                t.stop();           //[DO NOT MODIFY]
                t.reset();          //[DO NOT MODIFY]
                if (dt >= 0) {          //[DO NOT MODIFY]
                    wait(dt);       //[DO NOT MODIFY]
                }               //[DO NOT MODIFY]
                t.start();          //[DO NOT MODIFY]
            }               //[DO NOT MODIFY] End of Control While Loop
            t.stop();           //[DO NOT MODIFY]
            t.reset();          //[DO NOT MODIFY]
            tlog.stop();            //[DO NOT MODIFY] Stop and reset durationr used when logging data
            tlog.reset();           //[DO NOT MODIFY]

            mot.speed(0);       //[INSERT] Set speed of motor to zero
        }
    }

    else if (userOption == 'd') {
        float KpPIDControl = 0.045;
        float kD = 0.1;
        float dcHoldPID = 0.45;

        while(1) {                      //[DO NOT MODIFY WHILE LINE] Indefinite while loop
            dummyPwm.period(0.00005);       //[DO NOT MODIFY] This sets the period of all PWM signals to 0.00005 sec

            mot.speed(0);  //Set motor speed to zero. Always set the motor speed to zero before starting an experiment
            pc.printf("\n Enter Height: \n\r");
            pc.scanf("%f", &height);
            pc.printf("\n Enter Duration: \n\r");
            pc.scanf("%f", &duration);
            pc.printf("\n Enter Frequency:\n\r");
            pc.scanf("%f", &Fs);

            //[INSERT] Use the commands of your choice (printf, putc, scanf, getc, any other) to give/ask instructions to user
            //[INSERT] Obtain and save parameters enter by user: desired height (as a float), sampling frequency (as a float named Fs)
            // and duration of experiment (as a float)

            wait(0.5);          //Small wait... to give you some duration
            t.start();          //[DO NOT MODIFY] Start durationr that regulate control sequence
            tlog.start();       //[DO NOT MODIFY] Start durationr that you will use to log duration data

            float lastHeight = 6.0;

            while(tlog.read() <= duration) {  //[INSERT] Modify condition in while loop must execute as long as specified by user.

                encoderReading = (float)encoder.getPulses(); //[INSERT] Here you should read the encoder
                actualheight = ((value1)* pow(encoderReading,1)) + ((value2)* pow(encoderReading,0)); //[INSERT] Using your calibration equation, convert encoder counts to height
                heighterror = height - actualheight;
                float derError = -(actualheight-lastHeight)*(Fs);
                lastHeight = actualheight;

                float intError = intError + heighterror*(1/Fs); //[INSERT] Compute error = desired height - measured height

                //[LOGIC CONTROLLER]   Compute Duty Cycle for motor speed using Logic Control Algorithm (a series of if-else statements)
                dc = KpPIDControl*heighterror + ki*intError + kD*derError;
                dc = dc + dcHoldPID;


                if (dc >= -1 && dc <= 1 ) {
                    mot.speed(1*dc);
                } else {
                    dc = 1;
                    mot.speed(dc);
                }

                //[INSERT] Set speed of motor with duty cycle computed

                pc.printf("duration: %.3f \t Measured Height: %.3f \t Error Height: %3f \t Duty Cycle: %f\t\n\r",tlog.read(), actualheight, heighterror,  dc);

                //[DO NOT MODIFY the following lines of code] This code makes sure the control sequence is executed every "1/Fs" seconds
                float Ts = 1/Fs;        //[DO NOT MODIFY] Ts is the control period, inverse of control sampling frequency
                dt = Ts-t.read();       //[DO NOT MODIFY]
                t.stop();           //[DO NOT MODIFY]
                t.reset();          //[DO NOT MODIFY]
                if (dt >= 0) {          //[DO NOT MODIFY]
                    wait(dt);       //[DO NOT MODIFY]
                }               //[DO NOT MODIFY]
                t.start();          //[DO NOT MODIFY]
            }               //[DO NOT MODIFY] End of Control While Loop
            t.stop();           //[DO NOT MODIFY]
            t.reset();          //[DO NOT MODIFY]
            tlog.stop();            //[DO NOT MODIFY] Stop and reset durationr used when logging data
            tlog.reset();           //[DO NOT MODIFY]

            mot.speed(0);       //[INSERT] Set speed of motor to zero
        }
    }

}
