//An embedded server sending sensor data to a client side process running on a PC for logging and analysis
//TODO: Add in error handling and timeouts to deal with dropped connections and compile flags for testing

#include "data_logger.h"

EthernetInterface eth; 
NTPClient ntp;
TimeInterface time_b;
Timer t;
time_t timestamp;                                                                                       //Built-in time class instance 
TCPSocketServer server;
TCPSocketConnection client;
EventQueue queue1; 
EventQueue queue2;
Thread t1; 
Thread t2;
Mutex m;

//setup
DigitalOut led1(LED1);
AnalogIn strainIn(A0);
InterruptIn sig(p5);

//RtosTimer Timer(send_payload,osTimerPeriodic); 

// main() runs in its own thread in the OS
// (note the calls to Thread::wait below for delays)

int main(void) 
{
    eth.init(); //Use DHCP
    eth.setName("DL-test");         					//set a hostname
    eth_cxn_status = eth.connect();						//Attempt an ethernet connection and save the status, add retries here in the future
    if(eth_cxn_status == 0) {
    	      //Bring up the ethernet interface
    	printf("Detected Ethernet connection, entering network logging mode \n Server IP Address is %s\n", eth.getIPAddress());
    	    server.bind(SERVER_PORT);
    	    server.listen();                                                                                          //Wait for the client to connect
    	    server.accept(client);
    	    printf("Connection from: %s\n", client.get_address());
    	    if (ntp.setTime("0.pool.ntp.org") == 0)                                                                  //If time retrieval is successful
    	    {
    	    printf("Set time successfully\r\n");

    	    }
    	    else
    	    {
    	    printf("Unable to set time, error\r\n");
    	    }
    	}
    else {
    	 printf("Entering USB logging mode");
    	 }
    
    timestamp = time(NULL);
    queue1.call_every(RATE,&idle_report); 
    t1.start(callback(&queue1, &EventQueue::dispatch_forever));                                          //Start the thread for periodic basline value reporting   
    sig.rise(queue2.event(&cycle_time_isr_rise));                                                                     
    sig.fall(queue2.event(&cycle_time_isr_fall));
    t2.start(callback(&queue2, &EventQueue::dispatch_forever));                                           //Start the cycle time and peak value calculation thread
                                                                                           
}

void cycle_time_isr_rise(void) { 
    t.start();                                              											  //Start the timer
    m.lock();                                               											  //Lock the mutex to prevent the baseline reporting thread from writing to the application buffer
    /*for(i=0;i<1023;i++) {
        samples[i] = pressureIn.read();
        //add a mean and peak pressure calculation here and you may want to slow down the sample rate
        i++;       
        }*/
    //p_press =  pressIn.read();
    p_strain = strainCalc();                                											   //Calculate strain while the machine is crushing
    }

void cycle_time_isr_fall(void) {
    t.stop();                                                                                              //Stop the timer
    cycle_time = t.read();
    t.reset();                                                                                             //reset the timer
    if(eth_cxn_status == 0) {
    	sprintf(appbuffer,"<payload><time>%s</time><cy_time>%f</cy_time><p_strain>%f</p_strain></payload>",time_b.ctime(&timestamp), cycle_time, p_strain);
    }
    else {
    	printf("Cycle time is: %f \n Strain detected during cycle is: %f% \r", cycle_time, p_strain);
    }
    sprintf(appbuffer,"\0");                                                                                //Nullify the string
    m.unlock();                                                                                             //Unlock the mutex
    };

void idle_report(void) {
    m.lock();                                                                                               //Attempt to lock the mutex here
    id_strain = strainCalc();                                                                               //Calculate strain while the machine is idle
    if (eth_cxn_status == 0) {																				//Log data based on the available connection
    	sprintf(appbuffer,"<payload><time>%s</time><id_strain>%f</id_strain></payload>",time_b.ctime(&timestamp), id_strain);
    }
    else {
    	printf("Strain while machine is idle: %f%",id_strain );
    }

    sprintf(appbuffer,"\0");                                                                                //Nullify the buffer
    m.unlock();                                                                                             //Unlock the mutex
    }
    
float strainCalc(void) {
    float deltaR = strainIn/CURRENT;                                                                        //Calculate Delta R
    float strain = (1/GAUGE_FACTOR)*(deltaR/NOMINAL_R);                                                     //Calculate strain, see equation reference in docs
    return strain;
    }

