#include "WakeupLight.h"

#include "Images/ic_date_range_white_48dp_1x.h"
extern BYTE ic_query_builder_white_48dp_1x[];

UI_STRUCT                       uiTimeAdjust;
bool                            isDateAdjust;
UI_BOX_LIST_ITEM_STRUCT         uiTimeItems[]=
{
    { "Date", ic_date_range_white_48dp_1x }, { "Time", ic_query_builder_white_48dp_1x }
};

void UI_TimeAdjustHandler(UI_REASON_ENUM reason,int32_t index,UI_STRUCT *ui)
{
    struct tm                   *tmStruct;

    switch (reason)
    {
        case UR_CLICK:
            DPrintf_("UI_WakeupAdjustHandler: %u.\r\n",index);
            if (index==-1)
            {
                if (isDateAdjust==true)
                {
                    RTC_Get(&tmStruct);

                    tmStruct->tm_mday=uiTimeAdjust.data.valueAdjust.values[0];
                    tmStruct->tm_mon=uiTimeAdjust.data.valueAdjust.values[1]-1;
                    tmStruct->tm_year=uiTimeAdjust.data.valueAdjust.values[2]+2000-1900;

                    RTC_Set(tmStruct);
                }
                else
                {
                    RTC_Get(&tmStruct);

                    tmStruct->tm_hour=uiTimeAdjust.data.valueAdjust.values[0];
                    tmStruct->tm_min=(uiTimeAdjust.data.valueAdjust.values[1]*10) + (uiTimeAdjust.data.valueAdjust.values[2]);

                    RTC_Set(tmStruct);
                }

                UI_TimeShow();
                break;
            }
            else if (index==0)
            {
                uiTimeAdjust.data.valueAdjust.values[0]++;
                if (isDateAdjust==true)
                {
                    if (uiTimeAdjust.data.valueAdjust.values[0]>=32)
                        uiTimeAdjust.data.valueAdjust.values[0]=1;
                }
                else
                {
                    if (uiTimeAdjust.data.valueAdjust.values[0]>=23)
                        uiTimeAdjust.data.valueAdjust.values[0]=0;
                }
            }   
            else if (index==1)
            {
                uiTimeAdjust.data.valueAdjust.values[1]++;
                if (isDateAdjust==true)
                {
                    if (uiTimeAdjust.data.valueAdjust.values[1]>=13)
                        uiTimeAdjust.data.valueAdjust.values[1]=1;
                }
                else
                {
                    if (uiTimeAdjust.data.valueAdjust.values[1]>=6)
                        uiTimeAdjust.data.valueAdjust.values[1]=0;
                }
            }
            else if (index==2)
            {
                uiTimeAdjust.data.valueAdjust.values[2]++;
                if (isDateAdjust==true)
                {
                    if (uiTimeAdjust.data.valueAdjust.values[2]>=31)
                        uiTimeAdjust.data.valueAdjust.values[2]=16;
                }
                else
                {
                    if (uiTimeAdjust.data.valueAdjust.values[2]>=10)
                        uiTimeAdjust.data.valueAdjust.values[2]=0;
                }
            }
            else if (index==3)
            {
                uiTimeAdjust.data.valueAdjust.values[0]--;
                if (isDateAdjust==true)
                {
                    if (uiTimeAdjust.data.valueAdjust.values[0]<1)
                        uiTimeAdjust.data.valueAdjust.values[0]=31;
                }
                else
                {
                    if (uiTimeAdjust.data.valueAdjust.values[0]<0)
                        uiTimeAdjust.data.valueAdjust.values[0]=23;
                }
            }
            else if (index==4)
            {
                uiTimeAdjust.data.valueAdjust.values[1]--;
                if (isDateAdjust==true)
                {
                    if (uiTimeAdjust.data.valueAdjust.values[1]<1)
                        uiTimeAdjust.data.valueAdjust.values[1]=12;
                }
                else
                {
                    if (uiTimeAdjust.data.valueAdjust.values[1]<0)
                        uiTimeAdjust.data.valueAdjust.values[1]=5;
                }
            }
            else if (index==5)
            {
                uiTimeAdjust.data.valueAdjust.values[2]--;
                if (isDateAdjust==true)
                {
                    if (uiTimeAdjust.data.valueAdjust.values[2]<16)
                        uiTimeAdjust.data.valueAdjust.values[2]=30;
                }
                else
                {
                    if (uiTimeAdjust.data.valueAdjust.values[2]<0)
                        uiTimeAdjust.data.valueAdjust.values[2]=9;
                }
            }
            break;

        case UR_SHOW:
            break;
    }
}

void UI_TimeHandler(UI_REASON_ENUM reason,int32_t index,UI_STRUCT *ui)
{
    struct tm                   *tmStruct;

    switch (reason)
    {
        case UR_CLICK:
            if (index==-1)
            {
                // back button
                UI_Show(&uiMain);
            }
            else if (index==0)
            {
                // date
                isDateAdjust=true;

                memset(&uiTimeAdjust,0,sizeof(uiTimeAdjust));
                uiTimeAdjust.flags=UI_FLAG_TYPE_VALUE_ADJUST;
                uiTimeAdjust.handler=UI_TimeAdjustHandler;
                uiTimeAdjust.data.valueAdjust.count=3;

                RTC_Get(&tmStruct);
                uiTimeAdjust.data.valueAdjust.values[0]=tmStruct->tm_mday;
                uiTimeAdjust.data.valueAdjust.values[1]=tmStruct->tm_mon+1;
                uiTimeAdjust.data.valueAdjust.values[2]=tmStruct->tm_year+1900-2000;

                UI_Show(&uiTimeAdjust);
            }
            else if (index==1)
            {
                // time
                isDateAdjust=false;

                memset(&uiTimeAdjust,0,sizeof(uiTimeAdjust));
                uiTimeAdjust.flags=UI_FLAG_TYPE_VALUE_ADJUST;
                uiTimeAdjust.handler=UI_TimeAdjustHandler;
                uiTimeAdjust.data.valueAdjust.count=3;
                uiTimeAdjust.data.valueAdjust.isTime=true;

                RTC_Get(&tmStruct);
                uiTimeAdjust.data.valueAdjust.values[0]=tmStruct->tm_hour;
                uiTimeAdjust.data.valueAdjust.values[1]=tmStruct->tm_min / 10;
                uiTimeAdjust.data.valueAdjust.values[2]=tmStruct->tm_min % 10;

                UI_Show(&uiTimeAdjust);
            }
            break;

        case UR_TIMER:
            break;
    }
}

void UI_TimeShow(void)
{
    uiWakeup.flags=UI_FLAG_TYPE_BOX_LIST | UI_FLAG_HAS_BACK_BUTTON;
    uiWakeup.handler=UI_TimeHandler;
    uiWakeup.data.boxList.items=uiTimeItems;
    uiWakeup.data.boxList.count=2;

    UI_Show(&uiWakeup);
}
