#include "WakeupLight.h"

#define LED_PERIOD                                          10

PwmOut                                                      ledBlue(PB_15);
PwmOut                                                      ledRed(PH_6);
PwmOut                                                      ledGreen(PB_4);
PwmOut                                                      ledWhite(PA_15);
Ticker                                                      ledTicker;
int32_t                                                     ledAnimationStep;
LED_ANIMATION_ENUM                                          ledAnimation;

void LED_SetColor(int32_t color)
{
    DPrintfCore("LED_SetColor: 0x%08X.\r\n",color);

    ledRed.write(1.0 * COLOR_RED(color) / 255.0);
    ledGreen.write(1.0 * COLOR_GREEN(color) / 255.0);
    ledBlue.write(1.0 * COLOR_BLUE(color) / 255.0);
    ledWhite.write(1.0 * COLOR_WHITE(color) / 255.0);
}

void LED_Callback()
{
    int32_t         color;

    DPrintfCore("LED_Callback: Animation: %u, Step: %u.\r\n",ledAnimation,ledAnimationStep);

    if (ledAnimation==LAE_WAKEUP)
    {
        if (ledAnimationStep<255)
        {
            ledAnimationStep++;
            color=COLOR_CREATE((ledAnimationStep/2),ledAnimationStep,0,0);
            LED_SetColor(color);
        }
        else if (ledAnimationStep<(255+180))
        {
            ledAnimationStep++;
    
            color=COLOR_CREATE(128,255,0,(ledAnimationStep-255));
            LED_SetColor(color);
        }
    }
    else if (ledAnimation==LAE_OFF)
    {
        double      red;
        double      green;
        double      blue;
        double      white;
        uint32_t    redInt;
        uint32_t    greenInt;
        uint32_t    blueInt;
        uint32_t    whiteInt;

        red=ledRed.read();
        if (red>0.0)
            red-=0.001;
        red=MAX(red,0.0);
        redInt=(int32_t)(red*255.0);

        green=ledGreen.read();
        if (green>0.0)
            green-=0.001;
        green=MAX(green,0.0);
        greenInt=(int32_t)(green*255.0);

        blue=ledBlue.read();
        if (blue>0)
            blue-=0.001;
        blue=MAX(blue,0.0);
        blueInt=(int32_t)(blue*255.0);

        white=ledWhite.read();
        if (white>0)
            white-=0.001;
        white=MAX(white,0.0);
        whiteInt=(int32_t)(white*255.0);

        color=COLOR_CREATE(redInt,greenInt,blueInt,whiteInt);
        LED_SetColor(color);
    }
}

void LED_StartAnimation(LED_ANIMATION_ENUM animation)
{
    ledAnimationStep=0;
    ledAnimation=animation;
}

void LED_Init(void)
{
    ledRed.period_ms(LED_PERIOD);
    ledGreen.period_ms(LED_PERIOD);
    ledBlue.period_ms(LED_PERIOD);
    ledWhite.period_ms(LED_PERIOD);

    LED_SetColor(COLOR_CREATE(0,0,0,0));

    LED_StartAnimation(LAE_NONE);

    ledTicker.attach(&LED_Callback,0.05);
}
