#include "WakeupLight.h"

extern BYTE ic_notifications_none_white_48dp_1x[];
#include "Images/ic_add_alert_white_48dp_1x.h"

#define ALARM_NAME_LENGTH       20

char                            alarm1[ALARM_NAME_LENGTH];
char                            alarm2[ALARM_NAME_LENGTH];
char                            alarm3[ALARM_NAME_LENGTH];
char                            alarm4[ALARM_NAME_LENGTH];
char                            alarm5[ALARM_NAME_LENGTH];
char                            alarm6[ALARM_NAME_LENGTH];
CONFIG_TYPE_ENUM                currentConfigTime;
CONFIG_TYPE_ENUM                currentConfigMask;
UI_STRUCT                       uiWakeupAdjust;
UI_BOX_LIST_ITEM_STRUCT         uiWakeupItems[]=
{
    { alarm1, NULL }, { alarm2, NULL }, { alarm3, NULL }, { alarm4, NULL }, { alarm5, NULL }, { alarm6, NULL }
};

void UI_WakeupAdjustHandler(UI_REASON_ENUM reason,int32_t index,UI_STRUCT *ui)
{
    switch (reason)
    {
        case UR_CLICK:
            DPrintf_("UI_WakeupAdjustHandler: %u.\r\n",index);
            if (index==-1)
            {
                uint32_t                    value;

                Config_Set(currentConfigTime,((uiWakeupAdjust.data.valueAdjust.values[0] << 8) | ((uiWakeupAdjust.data.valueAdjust.values[1] * 10) + uiWakeupAdjust.data.valueAdjust.values[2])));

                value=0;
                if (uiWakeupAdjust.data.valueAdjust.values[3]!=0)
                    value|=CONFIG_ALARM_MASK_MONDAY;
                if (uiWakeupAdjust.data.valueAdjust.values[4]!=0)
                    value|=CONFIG_ALARM_MASK_TUESDAY;
                if (uiWakeupAdjust.data.valueAdjust.values[5]!=0)
                    value|=CONFIG_ALARM_MASK_WEDNESDAY;
                if (uiWakeupAdjust.data.valueAdjust.values[6]!=0)
                    value|=CONFIG_ALARM_MASK_THURSDAY;
                if (uiWakeupAdjust.data.valueAdjust.values[7]!=0)
                    value|=CONFIG_ALARM_MASK_FRIDAY;
                if (uiWakeupAdjust.data.valueAdjust.values[8]!=0)
                    value|=CONFIG_ALARM_MASK_SATURDAY;
                if (uiWakeupAdjust.data.valueAdjust.values[9]!=0)
                    value|=CONFIG_ALARM_MASK_SUNDAY;
                Config_Set(currentConfigMask,value);

                UI_WakeupShow();
                break;
            }
            else if (index==0)
            {
                uiWakeupAdjust.data.valueAdjust.values[0]++;
                if (uiWakeupAdjust.data.valueAdjust.values[0]>=23)
                    uiWakeupAdjust.data.valueAdjust.values[0]=0;
            }   
            else if (index==1)
            {
                uiWakeupAdjust.data.valueAdjust.values[1]++;
                if (uiWakeupAdjust.data.valueAdjust.values[1]>=6)
                    uiWakeupAdjust.data.valueAdjust.values[1]=0;
            }
            else if (index==2)
            {
                uiWakeupAdjust.data.valueAdjust.values[2]++;
                if (uiWakeupAdjust.data.valueAdjust.values[2]>=10)
                    uiWakeupAdjust.data.valueAdjust.values[2]=0;
            }
            else if (index==3)
            {
                uiWakeupAdjust.data.valueAdjust.values[0]--;
                if (uiWakeupAdjust.data.valueAdjust.values[0]<0)
                    uiWakeupAdjust.data.valueAdjust.values[0]=23;
            }
            else if (index==4)
            {
                uiWakeupAdjust.data.valueAdjust.values[1]--;
                if (uiWakeupAdjust.data.valueAdjust.values[1]<0)
                    uiWakeupAdjust.data.valueAdjust.values[1]=5;
            }
            else if (index==5)
            {
                uiWakeupAdjust.data.valueAdjust.values[2]--;
                if (uiWakeupAdjust.data.valueAdjust.values[2]<0)
                    uiWakeupAdjust.data.valueAdjust.values[2]=9;
            }
            else if ((index>=6) && (index<=12))
            {
                if (uiWakeupAdjust.data.valueAdjust.values[index-3]==0)
                    uiWakeupAdjust.data.valueAdjust.values[index-3]=1;
                else
                    uiWakeupAdjust.data.valueAdjust.values[index-3]=0;
            }
            break;

        case UR_SHOW:
            break;
    }
}

void UI_WakeupHandler(UI_REASON_ENUM reason,int32_t index,UI_STRUCT *ui)
{
    switch (reason)
    {
        case UR_CLICK:
            if (index==-1)
            {
                // back button
                UI_Show(&uiMain);
            }
            else
            {
                // adjust timer
                uint32_t                value;

                switch (index)
                {
                    case 0:             currentConfigTime=CT_ALARM_1_TIME;      currentConfigMask=CT_ALARM_1_MASK;          break;
                    case 1:             currentConfigTime=CT_ALARM_2_TIME;      currentConfigMask=CT_ALARM_2_MASK;          break;
                    case 2:             currentConfigTime=CT_ALARM_3_TIME;      currentConfigMask=CT_ALARM_3_MASK;          break;
                    case 3:             currentConfigTime=CT_ALARM_4_TIME;      currentConfigMask=CT_ALARM_4_MASK;          break;
                    case 4:             currentConfigTime=CT_ALARM_5_TIME;      currentConfigMask=CT_ALARM_5_MASK;          break;
                    case 5:             currentConfigTime=CT_ALARM_6_TIME;      currentConfigMask=CT_ALARM_6_MASK;          break;
                }

                memset(&uiWakeupAdjust,0,sizeof(uiWakeupAdjust));
                uiWakeupAdjust.flags=UI_FLAG_TYPE_VALUE_ADJUST;
                uiWakeupAdjust.handler=UI_WakeupAdjustHandler;
                uiWakeupAdjust.data.valueAdjust.count=10;
                uiWakeupAdjust.data.valueAdjust.isTime=true;

                value=Config_Get(currentConfigTime);
                uiWakeupAdjust.data.valueAdjust.values[0]=((value >> 8) & 0xFF);
                uiWakeupAdjust.data.valueAdjust.values[1]=((value & 0xFF) / 10);
                uiWakeupAdjust.data.valueAdjust.values[2]=((value & 0xFF) % 10);

                value=Config_Get(currentConfigMask);
                if (value==0)
                    value=CONFIG_ALARM_MASK_MONDAY | CONFIG_ALARM_MASK_TUESDAY | CONFIG_ALARM_MASK_WEDNESDAY | CONFIG_ALARM_MASK_THURSDAY | CONFIG_ALARM_MASK_FRIDAY;
                if ((value & CONFIG_ALARM_MASK_MONDAY)!=0)
                    uiWakeupAdjust.data.valueAdjust.values[3]=1;
                if ((value & CONFIG_ALARM_MASK_TUESDAY)!=0)
                    uiWakeupAdjust.data.valueAdjust.values[4]=1;
                if ((value & CONFIG_ALARM_MASK_WEDNESDAY)!=0)
                    uiWakeupAdjust.data.valueAdjust.values[5]=1;
                if ((value & CONFIG_ALARM_MASK_THURSDAY)!=0)
                    uiWakeupAdjust.data.valueAdjust.values[6]=1;
                if ((value & CONFIG_ALARM_MASK_FRIDAY)!=0)
                    uiWakeupAdjust.data.valueAdjust.values[7]=1;
                if ((value & CONFIG_ALARM_MASK_SATURDAY)!=0)
                    uiWakeupAdjust.data.valueAdjust.values[8]=1;
                if ((value & CONFIG_ALARM_MASK_SUNDAY)!=0)
                    uiWakeupAdjust.data.valueAdjust.values[9]=1;

                UI_Show(&uiWakeupAdjust);
            }
            break;

        case UR_TIMER:
            break;
    }
}

void UI_WakeupAddAlarm(uint32_t index,CONFIG_TYPE_ENUM configTime,CONFIG_TYPE_ENUM configMask,bool *addAdded)
{
    uint32_t                    alarmTime;

    if ((Config_Get(configMask) & CONFIG_ALARM_MASK_DAYS)!=0)
    {
        // alarm enabled
        alarmTime=Config_Get(configTime);
        snprintf(uiWakeupItems[index].name,ALARM_NAME_LENGTH,"%u:%02u",((alarmTime >> 8) & 0xFF),(alarmTime & 0xFF));
        uiWakeupItems[index].image=ic_notifications_none_white_48dp_1x;
        uiWakeup.data.boxList.count++;
    }
    else
    {
        // alarm disabled
        if ((*addAdded)==false)
        {
            snprintf(uiWakeupItems[index].name,ALARM_NAME_LENGTH,"New");
            uiWakeupItems[index].image=ic_add_alert_white_48dp_1x;
            uiWakeup.data.boxList.count++;
            (*addAdded)=true;
        }
    }
}

void UI_WakeupShow(void)
{
    bool                addAdded;

    uiWakeup.flags=UI_FLAG_TYPE_BOX_LIST | UI_FLAG_HAS_BACK_BUTTON;
    uiWakeup.handler=UI_WakeupHandler;
    uiWakeup.data.boxList.items=uiWakeupItems;
    uiWakeup.data.boxList.count=0;

    addAdded=false;
    UI_WakeupAddAlarm(0,CT_ALARM_1_TIME,CT_ALARM_1_MASK,&addAdded);
    UI_WakeupAddAlarm(1,CT_ALARM_2_TIME,CT_ALARM_2_MASK,&addAdded);
    UI_WakeupAddAlarm(2,CT_ALARM_3_TIME,CT_ALARM_3_MASK,&addAdded);
    UI_WakeupAddAlarm(3,CT_ALARM_4_TIME,CT_ALARM_4_MASK,&addAdded);
    UI_WakeupAddAlarm(4,CT_ALARM_5_TIME,CT_ALARM_5_MASK,&addAdded);
    UI_WakeupAddAlarm(5,CT_ALARM_6_TIME,CT_ALARM_6_MASK,&addAdded);

    UI_Show(&uiWakeup);
}
