#include "WakeupLight.h"

#include "Images/ic_navigate_before_white_24dp_1x.h"
#include "Images/ic_notifications_none_white_48dp_1x.h"
#include "Images/ic_query_builder_white_48dp_1x.h"
#include "Images/ic_slideshow_white_48dp_1x.h"
#include "Images/ic_visibility_off_white_48dp_1x.h"
#include "Images/ic_visibility_white_48dp_1x.h"
#include "Images/ic_equalizer_white_48dp_1x.h"
#include "Images/ic_settings_white_48dp_1x.h"

#define DEFAULT_FONT                            &calibri_36ptFontInfo

#define CLIENT_COLOR_BG                         ((uint32_t)0xFF000000)
#define CLIENT_COLOR_FG                         ((uint32_t)0xFFD0D0D0)
#define CLIENT_FONT                             DEFAULT_FONT

#define HEADER_HEIGHT                           26
#define HEADER_COLOR_BG                         ((uint32_t)0xFF000000)
#define HEADER_LINE                             ((uint32_t)0xFF008ED8)
#define HEADER_COLOR_FG                         ((uint32_t)0xFFD3D3D3)
#define HEADER_FONT                             DEFAULT_FONT

#define CLOCK_COLOR_BG                          ((uint32_t)0xFF000000)
#define CLOCK_COLOR_FG                          ((uint32_t)0xFF7070A0)
#define CLOCK_FONT                              &trebuchetMS_270ptFontInfo

#define CLOCK_IN_WORDS_CELL_WIDTH               22
#define CLOCK_IN_WORDS_CELL_HEIGHT              22
#define CLOCK_IN_WORDS_COLOR_FG_ACTIVE          HEADER_COLOR_FG
#define CLOCK_IN_WORDS_COLOR_FG_INACTIVE        ((uint32_t)0xFF202020)

#define CLOCK_IN_WORDS_TYPE_ES                  0x000001
#define CLOCK_IN_WORDS_TYPE_IST                 0x000002
#define CLOCK_IN_WORDS_TYPE_FUENF_1             0x000004
#define CLOCK_IN_WORDS_TYPE_ZEHN_1              0x000008
#define CLOCK_IN_WORDS_TYPE_ZWANZIG             0x000010
#define CLOCK_IN_WORDS_TYPE_DREI_1              0x000020
#define CLOCK_IN_WORDS_TYPE_VIERTEL             0x000040
#define CLOCK_IN_WORDS_TYPE_VOR                 0x000080
#define CLOCK_IN_WORDS_TYPE_NACH                0x000100
#define CLOCK_IN_WORDS_TYPE_HALB                0x000200
#define CLOCK_IN_WORDS_TYPE_ELF                 0x000400
#define CLOCK_IN_WORDS_TYPE_FUENF_2             0x000800
#define CLOCK_IN_WORDS_TYPE_EINS                0x001000
#define CLOCK_IN_WORDS_TYPE_ZWEI                0x002000
#define CLOCK_IN_WORDS_TYPE_DREI_2              0x004000
#define CLOCK_IN_WORDS_TYPE_VIER                0x008000
#define CLOCK_IN_WORDS_TYPE_SECHS               0x010000
#define CLOCK_IN_WORDS_TYPE_ACHT                0x020000
#define CLOCK_IN_WORDS_TYPE_SIEBEN              0x040000
#define CLOCK_IN_WORDS_TYPE_ZWOELF              0x080000
#define CLOCK_IN_WORDS_TYPE_ZEHN_2              0x100000
#define CLOCK_IN_WORDS_TYPE_NEUN                0x200000
#define CLOCK_IN_WORDS_TYPE_UHR                 0x400000

#define SLIDESHOW_COLOR_BG                      ((uint32_t)0xFF000000)
#define SLIDESHOW_COLOR_FG                      ((uint32_t)0xFFAFAFAF)
#define SLIDESHOW_TRANSPARENCY                  128
#define SLIDESHOW_FADE_STEP                     5
#define SLIDESHOW_TIMEOUT                       15
#define SLIDESHOW_FONT                          &trebuchetMS_135ptFontInfo

#define BUTTON_WIDTH                            100
#define BUTTON_HEIGHT                           60
#define BUTTON_SMALL_WIDTH                      50
#define BUTTON_SMALL_HEIGHT                     40
#define BUTTON_COLOR_BG                         ((uint32_t)0x00000000)
#define BUTTON_COLOR_FG                         CLIENT_COLOR_FG
#define BUTTON_COLOR_BG_START                   0x008ED8                    // 0x0C2696
#define BUTTON_COLOR_BG_END                     0x004366                    // 0x07185E
#define BUTTON_COLOR_BG_START_INACTIVE          0x515151
#define BUTTON_COLOR_BG_END_INACTIVE            0x333333
#define BUTTON_FONT                             DEFAULT_FONT

#define COLOR_BG                                ((uint32_t)0xFF000000)

#define MAX_BOXES_PER_LINE                      3
#define BOX_SPACING                             10
#define BOX_TEXT_SPACING                        10
#define BOX_COLOR_BG                            BUTTON_COLOR_BG
#define BOX_COLOR_FG                            CLIENT_COLOR_FG
#define BOX_COLOR_BG_START                      BUTTON_COLOR_BG_START
#define BOX_COLOR_BG_END                        BUTTON_COLOR_BG_END
#define BOX_FONT                                DEFAULT_FONT

LCD_DISCO_F746NG                                uiLcd;
TS_DISCO_F746NG                                 uiTs;
uint16_t                                        uiLastTouchX;
uint16_t                                        uiLastTouchY;
int                                             lastSlideshowTick=0;
struct tm                                       lastClockUpdateTime;
UI_STRUCT                                       *uiCurrent=NULL;
UI_STRUCT                                       uiClock;
UI_STRUCT                                       uiClockInWords;
UI_STRUCT                                       uiColorTest;
UI_STRUCT                                       uiWakeup;
UI_STRUCT                                       uiSlideshow;
UI_STRUCT                                       uiMain;
static UI_BOX_LIST_ITEM_STRUCT                  uiMainItems[]=
{
    { "Clock", ic_query_builder_white_48dp_1x }, { "Clock\nIn Words", ic_query_builder_white_48dp_1x }, { "Slideshow", ic_slideshow_white_48dp_1x }, { "Adjust\nTimers", ic_notifications_none_white_48dp_1x }, { "Settings", ic_settings_white_48dp_1x }, { "Lights\nOn", ic_visibility_white_48dp_1x }, { "Lights\nOff", ic_visibility_off_white_48dp_1x }, { "My Color", ic_equalizer_white_48dp_1x }
};

//
// helper function
//
void UI_ShowClearClientRect(void)
{
    uiLcd.SetTextColor(CLIENT_COLOR_BG);
    uiLcd.FillRect(0,HEADER_HEIGHT,uiLcd.GetXSize(),uiLcd.GetYSize()-HEADER_HEIGHT);
}

void UI_ShowDisplayText(int16_t x,int16_t y,char *text,const FONT_INFO *pFont,uint32_t colorText,uint32_t colorBack)
{
    int16_t             xStart;

    xStart=x;

    while ((*text)!='\0')
    {
        if ((*text)=='\n')
        {
            y+=FontX_GetHeight(pFont);
            x=xStart;
        }
        else
        {
            x+=FontX_DisplayChar(x,y,*text,pFont,colorText,colorBack);
        }

        text++;
    }
}

void UI_ShowDisplayTextCenter(int16_t x,int16_t y,int16_t width,int16_t height,char *text,const FONT_INFO *pFont,uint32_t colorText,uint32_t colorBack)
{
    if (height!=-1)
        y+=(height-FontX_GetHeight(pFont))/2;

    FontX_DisplayStringAt(x,y,width,text,ALIGN_CENTER,pFont,colorText,colorBack);
}

void UI_ShowDrawGradientButton(uint16_t x,uint16_t y,uint16_t width,uint16_t height,uint32_t colorStart,uint32_t colorEnd)
{
    float       deltaRed;
    float       deltaGreen;
    float       deltaBlue;
    float       red;
    float       green;
    float       blue;
    uint16_t    offset;
    uint32_t    color;

    deltaRed=(float)((int32_t)(colorEnd & 0xFF) - (int32_t)(colorStart & 0xFF))/height;
    deltaGreen=(float)((int32_t)((colorEnd >> 8) & 0xFF) - (int32_t)((colorStart >> 8)& 0xFF))/height;
    deltaBlue=(float)((int32_t)((colorEnd >> 16) & 0xFF) - (int32_t)((colorStart >> 16)& 0xFF))/height;

    red=colorStart & 0xFF;
    green=((colorStart >> 8)& 0xFF);
    blue=((colorStart >> 16)& 0xFF);

    for (offset=0;offset<height;offset++)
    {
        color=(uint8_t)red | (((uint8_t)green)<<8) | (((uint8_t)blue)<<16) | (((uint32_t)0xFF)<<24);
        uiLcd.SetTextColor(color);

        if ((offset==0) || (offset==(height-1)))
            uiLcd.DrawHLine(x+1,y+offset,width-2);
        else
            uiLcd.DrawHLine(x,y+offset,width);

        red+=deltaRed;
        green+=deltaGreen;
        blue+=deltaBlue;
    }
}

void UI_ShowDrawButtonEx(uint16_t x,uint16_t y,uint16_t width,uint16_t height,char *text,bool active)
{
    // paint button background
    if (active==true)
        UI_ShowDrawGradientButton(x,y,width,height,BUTTON_COLOR_BG_START,BUTTON_COLOR_BG_END);
    else
        UI_ShowDrawGradientButton(x,y,width,height,BUTTON_COLOR_BG_START_INACTIVE,BUTTON_COLOR_BG_END_INACTIVE);

    // paint button text
    UI_ShowDisplayTextCenter(x,y,width,height,text,BUTTON_FONT,BUTTON_COLOR_FG,BUTTON_COLOR_BG);
}

void UI_ShowDrawButton(uint16_t x,uint16_t y,uint16_t width,uint16_t height,char *text)
{
    UI_ShowDrawButtonEx(x,y,width,height,text,true);
}

void UI_DrawBitmapWithAlpha(uint32_t Xpos,uint32_t Ypos,uint8_t *pbmp)
{
  uint32_t index = 0, width = 0, height = 0, bit_pixel = 0;
  uint32_t x;
  uint32_t part;
  uint32_t color[3];
  uint32_t value;

  /* Get bitmap data address offset */
  index = *(__IO uint16_t *) (pbmp + 10);
  index |= (*(__IO uint16_t *) (pbmp + 12)) << 16;
  
  /* Read bitmap width */
  width = *(uint16_t *) (pbmp + 18);
  width |= (*(uint16_t *) (pbmp + 20)) << 16;
  
  /* Read bitmap height */
  height = *(uint16_t *) (pbmp + 22);
  height |= (*(uint16_t *) (pbmp + 24)) << 16; 
  
  /* Read bit/pixel */
  bit_pixel = *(uint16_t *) (pbmp + 28);   
  
  /* Get the layer pixel format */    
  if ((bit_pixel/8) != 4)
  {
    DPrintf("UI_DrawBitmapWithAlpha: This is no alpha picture.\r\n");
    return;
  }

  /* Bypass the bitmap header */
  pbmp += (index + (width * (height - 1) * (bit_pixel/8)));  

  for(index=0; index < height; index++)
  {
    for (x=0;x<width;x++)
    {
      value=uiLcd.ReadPixel(Xpos+x,Ypos+index);

      color[0]=value & 0xFF;
      color[1]=(value >> 8) & 0xFF;
      color[2]=(value >> 16) & 0xFF;

      if (pbmp[3]>0)
      {
        // add red
        part=(color[0]+(pbmp[0]*pbmp[3]/255));
        if (part>255)
          part=255;
        color[0]=part;
    
        // add green
        part=(color[1]+(pbmp[1]*pbmp[3]/255));
        if (part>255)
          part=255;
        color[1]=part;
    
        // add blue
        part=(color[2]+(pbmp[2]*pbmp[3]/255));
        if (part>255)
          part=255;
        color[2]=part;

        // draw pixel
        uiLcd.DrawPixel(Xpos+x,Ypos+index,color[0] | (color[1] << 8) | (color[2] << 16) | ((uint32_t)0xFF << 24));
      }
      
      pbmp+=4;
    }

    /* Increment the source and destination buffers */
    pbmp -= 2*(width*(bit_pixel/8));
  } 
}

//
// box list
//
void UI_ShowBoxList(bool initial)
{
    if (initial==true)
    {
        int8_t          lines;
        int8_t          columns;
        int8_t          box;
        int16_t         width;
        int16_t         height;
        int16_t         startX;
        int16_t         startY;

        // fill background
        UI_ShowClearClientRect();

        // paint boxes
        if (uiCurrent->data.boxList.count<=MAX_BOXES_PER_LINE)
            lines=1;
        else
            lines=2;

        columns=((uiCurrent->data.boxList.count + (lines-1)) / lines);

        width=(uiLcd.GetXSize() - BOX_SPACING) / columns;
        height=(uiLcd.GetYSize() - HEADER_HEIGHT - BOX_SPACING) / lines;

        for (box=0;box<uiCurrent->data.boxList.count;box++)
        {
            startX=BOX_SPACING+(width*(box % columns));
            startY=HEADER_HEIGHT+BOX_SPACING+(height*(box/columns));

            // paint box background
            UI_ShowDrawGradientButton(startX,startY,width-BOX_SPACING,height-BOX_SPACING,BOX_COLOR_BG_START,BOX_COLOR_BG_END);

            // paint box text
            UI_ShowDisplayText(startX+BOX_TEXT_SPACING,startY+BOX_TEXT_SPACING,uiCurrent->data.boxList.items[box].name,BOX_FONT,BOX_COLOR_FG,BOX_COLOR_BG);

            // draw icon
            if (uiCurrent->data.boxList.items[box].image!=NULL)
                UI_DrawBitmapWithAlpha(startX+width-BOX_SPACING-48,startY+height-BOX_SPACING-48,uiCurrent->data.boxList.items[box].image);
        }
    }
}

void UI_ClickBoxList(uint16_t x,uint16_t y)
{
    int8_t          lines;
    int8_t          columns;
    int8_t          box;
    int16_t         width;
    int16_t         height;
    int16_t         startX;
    int16_t         startY;

    // detect at which box was clicked
    if (uiCurrent->data.boxList.count<=MAX_BOXES_PER_LINE)
        lines=1;
    else
        lines=2;

    columns=((uiCurrent->data.boxList.count + (lines-1)) / lines);

    width=(uiLcd.GetXSize() - BOX_SPACING) / columns;
    height=(uiLcd.GetYSize() - HEADER_HEIGHT - BOX_SPACING) / lines;

    for (box=0;box<uiCurrent->data.boxList.count;box++)
    {
        startX=BOX_SPACING+(width*(box % columns));
        startY=HEADER_HEIGHT+BOX_SPACING+(height*(box/columns));

        if (        (x>=startX) && (x<(startX+width-BOX_SPACING))
                &&
                    (y>=startY) && (y<(startY+height-BOX_SPACING))
           )
        {
            uiCurrent->handler(UR_CLICK,box,uiCurrent);
            break;
        }
    }
}

//
// clock
//
void UI_ShowClock(bool initial)
{
    char                        buffer[100];
    struct tm                   *tmStruct;

    RTC_Get(&tmStruct);

    if ((initial==true) || (tmStruct->tm_hour!=lastClockUpdateTime.tm_hour) || (tmStruct->tm_min!=lastClockUpdateTime.tm_min))
    {
        // fill background
        uiLcd.SetTextColor(CLOCK_COLOR_BG);
        uiLcd.FillRect(0,0,uiLcd.GetXSize(),uiLcd.GetYSize());
    
        // show clock
        if (tmStruct->tm_hour>=10)
            snprintf(buffer,sizeof(buffer),"%u    %u    :    %u    %u",tmStruct->tm_hour / 10,tmStruct->tm_hour % 10,tmStruct->tm_min / 10,tmStruct->tm_min % 10);
        else
            snprintf(buffer,sizeof(buffer),"%u    :    %u    %u",tmStruct->tm_hour,tmStruct->tm_min / 10,tmStruct->tm_min % 10);
    
        UI_ShowDisplayTextCenter(0,0,uiLcd.GetXSize(),uiLcd.GetYSize(),buffer,CLOCK_FONT,CLOCK_COLOR_FG,CLOCK_COLOR_BG);

        lastClockUpdateTime=*tmStruct;
    }
}

void UI_ClickClock(uint16_t x,uint16_t y)
{
    // exit view
    UI_Show(&uiMain);
}

//
// clock in words
//
void UI_ShowClockInWordsText(int16_t x,int16_t y,char *text,uint32_t type,uint32_t flags)
{
    char                        buffer[2];
    uint32_t                    colorText;

    if ((flags & type)!=0)
        colorText=CLOCK_IN_WORDS_COLOR_FG_ACTIVE;
    else
        colorText=CLOCK_IN_WORDS_COLOR_FG_INACTIVE;

    while ((*text)!='\0')
    {
        buffer[0]=*text;
        buffer[1]='\0';

        UI_ShowDisplayTextCenter(x+119,y+43,CLOCK_IN_WORDS_CELL_WIDTH,CLOCK_IN_WORDS_CELL_HEIGHT,buffer,CLIENT_FONT,colorText,CLOCK_COLOR_BG);

        text++;
        x+=CLOCK_IN_WORDS_CELL_WIDTH;
    }
}

void UI_ShowClockInWords(bool initial)
{
    struct tm                   *tmStruct;
    uint32_t                    flags;
    int8_t                      minutes;
    int8_t                      hour;

    RTC_Get(&tmStruct);

    if ((initial==true) || (tmStruct->tm_hour!=lastClockUpdateTime.tm_hour) || (tmStruct->tm_min!=lastClockUpdateTime.tm_min))
    {
        // fill background
        UI_ShowClearClientRect();
    
        // show clock

        /*
            ES K IST A FÜNF
            ZEHN ZWANZIG
            DREI VIERTEL
            VOR FUNK NACH
            HALB A ELFÜNF
            EINS XAM ZWEI
            DREI PMJ VIER
            SECHS NL ACHT
            SIEBEN ZWÖLF
            ZEHNEUN K UHR
        */

        flags=0;

        minutes=tmStruct->tm_min;
        hour=tmStruct->tm_hour;

        minutes=((minutes+2)/5)*5;
        if (minutes==5)
            flags|=CLOCK_IN_WORDS_TYPE_FUENF_1 | CLOCK_IN_WORDS_TYPE_NACH;
        else if (minutes==10)
            flags|=CLOCK_IN_WORDS_TYPE_ZEHN_1 | CLOCK_IN_WORDS_TYPE_NACH;
        else if (minutes==15)
            flags|=CLOCK_IN_WORDS_TYPE_VIERTEL | CLOCK_IN_WORDS_TYPE_NACH;
        else if (minutes==20)
            flags|=CLOCK_IN_WORDS_TYPE_ZWANZIG | CLOCK_IN_WORDS_TYPE_NACH;
        else if (minutes==25)
            flags|=CLOCK_IN_WORDS_TYPE_ZWANZIG | CLOCK_IN_WORDS_TYPE_NACH;
        else if (minutes==30)
            flags|=CLOCK_IN_WORDS_TYPE_HALB;
        else if (minutes==35)
            flags|=CLOCK_IN_WORDS_TYPE_HALB;
        else if (minutes==40)
        {
            flags|=CLOCK_IN_WORDS_TYPE_ZWANZIG | CLOCK_IN_WORDS_TYPE_VOR;
            hour++;
        }
        else if (minutes==45)
        {
            flags|=CLOCK_IN_WORDS_TYPE_VIERTEL | CLOCK_IN_WORDS_TYPE_VOR;
            hour++;
        }
        else if (minutes==50)
        {
            flags|=CLOCK_IN_WORDS_TYPE_ZEHN_1 | CLOCK_IN_WORDS_TYPE_VOR;
            hour++;
        }
        else if (minutes==55)
        {
            flags|=CLOCK_IN_WORDS_TYPE_FUENF_1 | CLOCK_IN_WORDS_TYPE_VOR;
            hour++;
        }

        hour=hour%12;
        if (hour==0)
            flags|=CLOCK_IN_WORDS_TYPE_ZWOELF;
        else if (hour==1)
            flags|=CLOCK_IN_WORDS_TYPE_EINS;
        else if (hour==2)
            flags|=CLOCK_IN_WORDS_TYPE_ZWEI;
        else if (hour==3)
            flags|=CLOCK_IN_WORDS_TYPE_DREI_2;
        else if (hour==4)
            flags|=CLOCK_IN_WORDS_TYPE_VIER;
        else if (hour==5)
            flags|=CLOCK_IN_WORDS_TYPE_FUENF_2;
        else if (hour==6)
            flags|=CLOCK_IN_WORDS_TYPE_SECHS;
        else if (hour==7)
            flags|=CLOCK_IN_WORDS_TYPE_SIEBEN;
        else if (hour==8)
            flags|=CLOCK_IN_WORDS_TYPE_ACHT;
        else if (hour==9)
            flags|=CLOCK_IN_WORDS_TYPE_NEUN;
        else if (hour==10)
            flags|=CLOCK_IN_WORDS_TYPE_ZEHN_2;
        else if (hour==11)
            flags|=CLOCK_IN_WORDS_TYPE_ELF;

        UI_ShowClockInWordsText(CLOCK_IN_WORDS_CELL_WIDTH*0,CLOCK_IN_WORDS_CELL_HEIGHT*0,"ES",1,1);
        UI_ShowClockInWordsText(CLOCK_IN_WORDS_CELL_WIDTH*2,CLOCK_IN_WORDS_CELL_HEIGHT*0,"K",0,1);
        UI_ShowClockInWordsText(CLOCK_IN_WORDS_CELL_WIDTH*3,CLOCK_IN_WORDS_CELL_HEIGHT*0,"IST",1,1);
        UI_ShowClockInWordsText(CLOCK_IN_WORDS_CELL_WIDTH*6,CLOCK_IN_WORDS_CELL_HEIGHT*0,"A",0,1);
        UI_ShowClockInWordsText(CLOCK_IN_WORDS_CELL_WIDTH*7,CLOCK_IN_WORDS_CELL_HEIGHT*0,"F\xDCNF",CLOCK_IN_WORDS_TYPE_FUENF_1,flags);
        UI_ShowClockInWordsText(CLOCK_IN_WORDS_CELL_WIDTH*0,CLOCK_IN_WORDS_CELL_HEIGHT*1,"ZEHN",CLOCK_IN_WORDS_TYPE_ZEHN_1,flags);
        UI_ShowClockInWordsText(CLOCK_IN_WORDS_CELL_WIDTH*4,CLOCK_IN_WORDS_CELL_HEIGHT*1,"ZWANZIG",CLOCK_IN_WORDS_TYPE_ZWANZIG,flags);
        UI_ShowClockInWordsText(CLOCK_IN_WORDS_CELL_WIDTH*0,CLOCK_IN_WORDS_CELL_HEIGHT*2,"DREI",CLOCK_IN_WORDS_TYPE_DREI_1,flags);
        UI_ShowClockInWordsText(CLOCK_IN_WORDS_CELL_WIDTH*4,CLOCK_IN_WORDS_CELL_HEIGHT*2,"VIERTEL",CLOCK_IN_WORDS_TYPE_VIERTEL,flags);
        UI_ShowClockInWordsText(CLOCK_IN_WORDS_CELL_WIDTH*0,CLOCK_IN_WORDS_CELL_HEIGHT*3,"VOR",CLOCK_IN_WORDS_TYPE_VOR,flags);
        UI_ShowClockInWordsText(CLOCK_IN_WORDS_CELL_WIDTH*3,CLOCK_IN_WORDS_CELL_HEIGHT*3,"FUNK",0,1);
        UI_ShowClockInWordsText(CLOCK_IN_WORDS_CELL_WIDTH*7,CLOCK_IN_WORDS_CELL_HEIGHT*3,"NACH",CLOCK_IN_WORDS_TYPE_NACH,flags);
        UI_ShowClockInWordsText(CLOCK_IN_WORDS_CELL_WIDTH*0,CLOCK_IN_WORDS_CELL_HEIGHT*4,"HALB",CLOCK_IN_WORDS_TYPE_HALB,flags);
        UI_ShowClockInWordsText(CLOCK_IN_WORDS_CELL_WIDTH*4,CLOCK_IN_WORDS_CELL_HEIGHT*4,"A",0,1);
        UI_ShowClockInWordsText(CLOCK_IN_WORDS_CELL_WIDTH*5,CLOCK_IN_WORDS_CELL_HEIGHT*4,"EL",CLOCK_IN_WORDS_TYPE_ELF,flags);
        UI_ShowClockInWordsText(CLOCK_IN_WORDS_CELL_WIDTH*7,CLOCK_IN_WORDS_CELL_HEIGHT*4,"F",CLOCK_IN_WORDS_TYPE_ELF | CLOCK_IN_WORDS_TYPE_FUENF_2,flags);
        UI_ShowClockInWordsText(CLOCK_IN_WORDS_CELL_WIDTH*8,CLOCK_IN_WORDS_CELL_HEIGHT*4,"\xDCNF",CLOCK_IN_WORDS_TYPE_FUENF_2,flags);
        UI_ShowClockInWordsText(CLOCK_IN_WORDS_CELL_WIDTH*0,CLOCK_IN_WORDS_CELL_HEIGHT*5,"EINS",CLOCK_IN_WORDS_TYPE_EINS,flags);
        UI_ShowClockInWordsText(CLOCK_IN_WORDS_CELL_WIDTH*4,CLOCK_IN_WORDS_CELL_HEIGHT*5,"XAM",0,1);
        UI_ShowClockInWordsText(CLOCK_IN_WORDS_CELL_WIDTH*7,CLOCK_IN_WORDS_CELL_HEIGHT*5,"ZWEI",CLOCK_IN_WORDS_TYPE_ZWEI,flags);
        UI_ShowClockInWordsText(CLOCK_IN_WORDS_CELL_WIDTH*0,CLOCK_IN_WORDS_CELL_HEIGHT*6,"DREI",CLOCK_IN_WORDS_TYPE_DREI_2,flags);
        UI_ShowClockInWordsText(CLOCK_IN_WORDS_CELL_WIDTH*4,CLOCK_IN_WORDS_CELL_HEIGHT*6,"PMJ",0,1);
        UI_ShowClockInWordsText(CLOCK_IN_WORDS_CELL_WIDTH*7,CLOCK_IN_WORDS_CELL_HEIGHT*6,"VIER",CLOCK_IN_WORDS_TYPE_VIER,flags);
        UI_ShowClockInWordsText(CLOCK_IN_WORDS_CELL_WIDTH*0,CLOCK_IN_WORDS_CELL_HEIGHT*7,"SECHS",CLOCK_IN_WORDS_TYPE_SECHS,flags);
        UI_ShowClockInWordsText(CLOCK_IN_WORDS_CELL_WIDTH*5,CLOCK_IN_WORDS_CELL_HEIGHT*7,"NL",0,1);
        UI_ShowClockInWordsText(CLOCK_IN_WORDS_CELL_WIDTH*7,CLOCK_IN_WORDS_CELL_HEIGHT*7,"ACHT",CLOCK_IN_WORDS_TYPE_ACHT,flags);
        UI_ShowClockInWordsText(CLOCK_IN_WORDS_CELL_WIDTH*0,CLOCK_IN_WORDS_CELL_HEIGHT*8,"SIEBEN",CLOCK_IN_WORDS_TYPE_SIEBEN,flags);
        UI_ShowClockInWordsText(CLOCK_IN_WORDS_CELL_WIDTH*6,CLOCK_IN_WORDS_CELL_HEIGHT*8,"ZW\xD6LF",CLOCK_IN_WORDS_TYPE_ZWOELF,flags);
        UI_ShowClockInWordsText(CLOCK_IN_WORDS_CELL_WIDTH*0,CLOCK_IN_WORDS_CELL_HEIGHT*9,"ZEH",CLOCK_IN_WORDS_TYPE_ZEHN_2,flags);
        UI_ShowClockInWordsText(CLOCK_IN_WORDS_CELL_WIDTH*3,CLOCK_IN_WORDS_CELL_HEIGHT*9,"N",CLOCK_IN_WORDS_TYPE_ZEHN_2 | CLOCK_IN_WORDS_TYPE_NEUN,flags);
        UI_ShowClockInWordsText(CLOCK_IN_WORDS_CELL_WIDTH*4,CLOCK_IN_WORDS_CELL_HEIGHT*9,"EUN",CLOCK_IN_WORDS_TYPE_NEUN,flags);
        UI_ShowClockInWordsText(CLOCK_IN_WORDS_CELL_WIDTH*7,CLOCK_IN_WORDS_CELL_HEIGHT*9,"K",0,1);
        UI_ShowClockInWordsText(CLOCK_IN_WORDS_CELL_WIDTH*8,CLOCK_IN_WORDS_CELL_HEIGHT*9,"UHR",1,1);

        lastClockUpdateTime=*tmStruct;
    }

    /*
    // draw charset
    int x;
    for (x=0x80;x<=0xff;x++)
    {
        FontX_DisplayChar(  1+(((x-0x80) % 16)*14),
                            30+(((x-0x80)/16)*20),
                            x,
                            CLIENT_FONT,
                            CLIENT_COLOR_FG,
                            CLIENT_COLOR_BG);
    }
    */
}

void UI_ClickClockInWords(uint16_t x,uint16_t y)
{
    // exit view
    UI_Show(&uiMain);
}

//
// slideshow
//
void UI_ShowSlideshowFade(uint8_t from,uint8_t to)
{
    if (from<to)
    {
        while (from<to)
        {
            uiLcd.SetTransparency(0,from);
            
            wait_ms(30);

            if ((to-from)<SLIDESHOW_FADE_STEP)
                break;

            from+=SLIDESHOW_FADE_STEP;
        }
    }
    else
    {
        while (from>to)
        {
            uiLcd.SetTransparency(0,from);

            wait_ms(30);
            
            if ((from-to)<SLIDESHOW_FADE_STEP)
                break;

            from-=SLIDESHOW_FADE_STEP;
        }
    }

    uiLcd.SetTransparency(0,to);
}

void UI_ShowSlideshow(bool initial)
{
    char                        buffer[100];
    struct tm                   *tmStruct;

    RTC_Get(&tmStruct);

    if (((tmStruct->tm_sec / SLIDESHOW_TIMEOUT)!=lastSlideshowTick) || (initial==true))
    {
        lastSlideshowTick=(tmStruct->tm_sec / SLIDESHOW_TIMEOUT);

        // fill background with transparent color
        uiLcd.SetTextColor(0x00000000);
        uiLcd.FillRect(0,0,uiLcd.GetXSize(),uiLcd.GetYSize());

        // show clock
        if (tmStruct->tm_hour>=10)
            snprintf(buffer,sizeof(buffer),"%u   %u   :   %u   %u",tmStruct->tm_hour / 10,tmStruct->tm_hour % 10,tmStruct->tm_min / 10,tmStruct->tm_min % 10);
        else
            snprintf(buffer,sizeof(buffer),"%u   :   %u   %u",tmStruct->tm_hour,tmStruct->tm_min / 10,tmStruct->tm_min % 10);
        FontX_DisplayStringAt(30,180,uiLcd.GetXSize(),buffer,ALIGN_RIGHT,SLIDESHOW_FONT,SLIDESHOW_COLOR_FG,0x00000001);

        // hide picture layer
        if (initial==true)
            uiLcd.SetTransparency(0,0);
        else
            UI_ShowSlideshowFade(SLIDESHOW_TRANSPARENCY,0);
        uiLcd.SelectLayer(0);
        // clear old picture
        uiLcd.Clear(LCD_COLOR_BLACK);

        // load picture
        SD_ShowRandomPicture();

        // show new picture
        if (initial==true)
            uiLcd.SetLayerVisible(0,ENABLE);
        UI_ShowSlideshowFade(0,SLIDESHOW_TRANSPARENCY);
        uiLcd.SelectLayer(1);
    }
}

void UI_ClickSlideshow(uint16_t x,uint16_t y)
{
    // exit view
    uiLcd.SetLayerVisible(0,DISABLE);
    UI_Show(&uiMain);
}

//
// value adjust
//
void UI_ShowValueAdjust(bool initial)
{
    char                        buffer[20];

    if (initial==true)
    {
        // fill background
        UI_ShowClearClientRect();

        if (uiCurrent->data.valueAdjust.count==10)
        {
            UI_ShowDrawButton(60+(0*(BUTTON_WIDTH+15)),40,BUTTON_WIDTH,BUTTON_HEIGHT,"+");
            UI_ShowDrawButton(205+(0*(BUTTON_WIDTH+15)),40,BUTTON_WIDTH,BUTTON_HEIGHT,"+");
            UI_ShowDrawButton(205+(1*(BUTTON_WIDTH+15)),40,BUTTON_WIDTH,BUTTON_HEIGHT,"+");

            if (uiCurrent->data.valueAdjust.isTime==true)
                UI_ShowDisplayTextCenter(132,92,BUTTON_WIDTH,BUTTON_HEIGHT,":",CLIENT_FONT,CLIENT_COLOR_FG,CLIENT_COLOR_BG);

            UI_ShowDrawButton(60+(0*(BUTTON_WIDTH+15)),140,BUTTON_WIDTH,BUTTON_HEIGHT,"-");
            UI_ShowDrawButton(205+(0*(BUTTON_WIDTH+15)),140,BUTTON_WIDTH,BUTTON_HEIGHT,"-");
            UI_ShowDrawButton(205+(1*(BUTTON_WIDTH+15)),140,BUTTON_WIDTH,BUTTON_HEIGHT,"-");
        }
        else if (uiCurrent->data.valueAdjust.count==4)
        {
            UI_ShowDrawButton(17+(0*(BUTTON_WIDTH+15)),40,BUTTON_WIDTH,BUTTON_HEIGHT,"+");
            UI_ShowDrawButton(17+(1*(BUTTON_WIDTH+15)),40,BUTTON_WIDTH,BUTTON_HEIGHT,"+");
            UI_ShowDrawButton(17+(2*(BUTTON_WIDTH+15)),40,BUTTON_WIDTH,BUTTON_HEIGHT,"+");
            UI_ShowDrawButton(17+(3*(BUTTON_WIDTH+15)),40,BUTTON_WIDTH,BUTTON_HEIGHT,"+");

            UI_ShowDrawButton(17+(0*(BUTTON_WIDTH+15)),205,BUTTON_WIDTH,BUTTON_HEIGHT,"-");
            UI_ShowDrawButton(17+(1*(BUTTON_WIDTH+15)),205,BUTTON_WIDTH,BUTTON_HEIGHT,"-");
            UI_ShowDrawButton(17+(2*(BUTTON_WIDTH+15)),205,BUTTON_WIDTH,BUTTON_HEIGHT,"-");
            UI_ShowDrawButton(17+(3*(BUTTON_WIDTH+15)),205,BUTTON_WIDTH,BUTTON_HEIGHT,"-");
        }
        else if (uiCurrent->data.valueAdjust.count==3)
        {
            if (uiCurrent->data.valueAdjust.isTime==true)
            {
                UI_ShowDrawButton(60+(0*(BUTTON_WIDTH+15)),40,BUTTON_WIDTH,BUTTON_HEIGHT,"+");
                UI_ShowDrawButton(205+(0*(BUTTON_WIDTH+15)),40,BUTTON_WIDTH,BUTTON_HEIGHT,"+");
                UI_ShowDrawButton(205+(1*(BUTTON_WIDTH+15)),40,BUTTON_WIDTH,BUTTON_HEIGHT,"+");

                UI_ShowDisplayTextCenter(132,125,BUTTON_WIDTH,BUTTON_HEIGHT,":",CLIENT_FONT,CLIENT_COLOR_FG,CLIENT_COLOR_BG);

                UI_ShowDrawButton(60+(0*(BUTTON_WIDTH+15)),205,BUTTON_WIDTH,BUTTON_HEIGHT,"-");
                UI_ShowDrawButton(205+(0*(BUTTON_WIDTH+15)),205,BUTTON_WIDTH,BUTTON_HEIGHT,"-");
                UI_ShowDrawButton(205+(1*(BUTTON_WIDTH+15)),205,BUTTON_WIDTH,BUTTON_HEIGHT,"-");
            }
            else
            {
                UI_ShowDrawButton(74+(0*(BUTTON_WIDTH+15)),40,BUTTON_WIDTH,BUTTON_HEIGHT,"+");
                UI_ShowDrawButton(74+(1*(BUTTON_WIDTH+15)),40,BUTTON_WIDTH,BUTTON_HEIGHT,"+");
                UI_ShowDrawButton(74+(2*(BUTTON_WIDTH+15)),40,BUTTON_WIDTH,BUTTON_HEIGHT,"+");

                UI_ShowDisplayTextCenter(130,125,BUTTON_WIDTH,BUTTON_HEIGHT,".",CLIENT_FONT,CLIENT_COLOR_FG,CLIENT_COLOR_BG);
                UI_ShowDisplayTextCenter(246,125,BUTTON_WIDTH,BUTTON_HEIGHT,".",CLIENT_FONT,CLIENT_COLOR_FG,CLIENT_COLOR_BG);

                UI_ShowDrawButton(74+(0*(BUTTON_WIDTH+15)),205,BUTTON_WIDTH,BUTTON_HEIGHT,"-");
                UI_ShowDrawButton(74+(1*(BUTTON_WIDTH+15)),205,BUTTON_WIDTH,BUTTON_HEIGHT,"-");
                UI_ShowDrawButton(74+(2*(BUTTON_WIDTH+15)),205,BUTTON_WIDTH,BUTTON_HEIGHT,"-");
            }
        }
    }

    if (uiCurrent->data.valueAdjust.count==10)
    {
        snprintf(buffer,sizeof(buffer),"  % 2u  ",uiCurrent->data.valueAdjust.values[0]);
        UI_ShowDisplayTextCenter(60+(0*(BUTTON_WIDTH+15)),92,BUTTON_WIDTH,BUTTON_HEIGHT,buffer,CLIENT_FONT,CLIENT_COLOR_FG,CLIENT_COLOR_BG);

        snprintf(buffer,sizeof(buffer),"  %u  ",uiCurrent->data.valueAdjust.values[1]);
        UI_ShowDisplayTextCenter(205+(0*(BUTTON_WIDTH+15)),92,BUTTON_WIDTH,BUTTON_HEIGHT,buffer,CLIENT_FONT,CLIENT_COLOR_FG,CLIENT_COLOR_BG);

        snprintf(buffer,sizeof(buffer),"  %u  ",uiCurrent->data.valueAdjust.values[2]);
        UI_ShowDisplayTextCenter(205+(1*(BUTTON_WIDTH+15)),92,BUTTON_WIDTH,BUTTON_HEIGHT,buffer,CLIENT_FONT,CLIENT_COLOR_FG,CLIENT_COLOR_BG);

        if (uiCurrent->data.valueAdjust.values[3]==1)
            UI_ShowDrawButton(17+(0*(BUTTON_SMALL_WIDTH+15)),215,BUTTON_SMALL_WIDTH,BUTTON_SMALL_HEIGHT,"Mo");
        else
            UI_ShowDrawButtonEx(17+(0*(BUTTON_SMALL_WIDTH+15)),215,BUTTON_SMALL_WIDTH,BUTTON_SMALL_HEIGHT,"Mo",false);

        if (uiCurrent->data.valueAdjust.values[4]==1)
            UI_ShowDrawButton(17+(1*(BUTTON_SMALL_WIDTH+15)),215,BUTTON_SMALL_WIDTH,BUTTON_SMALL_HEIGHT,"Di");
        else
            UI_ShowDrawButtonEx(17+(1*(BUTTON_SMALL_WIDTH+15)),215,BUTTON_SMALL_WIDTH,BUTTON_SMALL_HEIGHT,"Di",false);

        if (uiCurrent->data.valueAdjust.values[5]==1)
            UI_ShowDrawButton(17+(2*(BUTTON_SMALL_WIDTH+15)),215,BUTTON_SMALL_WIDTH,BUTTON_SMALL_HEIGHT,"Mi");
        else
            UI_ShowDrawButtonEx(17+(2*(BUTTON_SMALL_WIDTH+15)),215,BUTTON_SMALL_WIDTH,BUTTON_SMALL_HEIGHT,"Mi",false);

        if (uiCurrent->data.valueAdjust.values[6]==1)
            UI_ShowDrawButton(17+(3*(BUTTON_SMALL_WIDTH+15)),215,BUTTON_SMALL_WIDTH,BUTTON_SMALL_HEIGHT,"Do");
        else
            UI_ShowDrawButtonEx(17+(3*(BUTTON_SMALL_WIDTH+15)),215,BUTTON_SMALL_WIDTH,BUTTON_SMALL_HEIGHT,"Do",false);

        if (uiCurrent->data.valueAdjust.values[7]==1)
            UI_ShowDrawButton(17+(4*(BUTTON_SMALL_WIDTH+15)),215,BUTTON_SMALL_WIDTH,BUTTON_SMALL_HEIGHT,"Fr");
        else
            UI_ShowDrawButtonEx(17+(4*(BUTTON_SMALL_WIDTH+15)),215,BUTTON_SMALL_WIDTH,BUTTON_SMALL_HEIGHT,"Fr",false);

        if (uiCurrent->data.valueAdjust.values[8]==1)
            UI_ShowDrawButton(17+(5*(BUTTON_SMALL_WIDTH+15)),215,BUTTON_SMALL_WIDTH,BUTTON_SMALL_HEIGHT,"Sa");
        else
            UI_ShowDrawButtonEx(17+(5*(BUTTON_SMALL_WIDTH+15)),215,BUTTON_SMALL_WIDTH,BUTTON_SMALL_HEIGHT,"Sa",false);

        if (uiCurrent->data.valueAdjust.values[9]==1)
            UI_ShowDrawButton(17+(6*(BUTTON_SMALL_WIDTH+15)),215,BUTTON_SMALL_WIDTH,BUTTON_SMALL_HEIGHT,"So");
        else
            UI_ShowDrawButtonEx(17+(6*(BUTTON_SMALL_WIDTH+15)),215,BUTTON_SMALL_WIDTH,BUTTON_SMALL_HEIGHT,"So",false);
    }
    else if (uiCurrent->data.valueAdjust.count==4)
    {
        snprintf(buffer,sizeof(buffer),"  0x%02X  ",uiCurrent->data.valueAdjust.values[0]);
        UI_ShowDisplayTextCenter(17+(0*(BUTTON_WIDTH+15)),125,BUTTON_WIDTH,BUTTON_HEIGHT,buffer,CLIENT_FONT,CLIENT_COLOR_FG,CLIENT_COLOR_BG);

        snprintf(buffer,sizeof(buffer),"  0x%02X  ",uiCurrent->data.valueAdjust.values[1]);
        UI_ShowDisplayTextCenter(17+(1*(BUTTON_WIDTH+15)),125,BUTTON_WIDTH,BUTTON_HEIGHT,buffer,CLIENT_FONT,CLIENT_COLOR_FG,CLIENT_COLOR_BG);

        snprintf(buffer,sizeof(buffer),"  0x%02X  ",uiCurrent->data.valueAdjust.values[2]);
        UI_ShowDisplayTextCenter(17+(2*(BUTTON_WIDTH+15)),125,BUTTON_WIDTH,BUTTON_HEIGHT,buffer,CLIENT_FONT,CLIENT_COLOR_FG,CLIENT_COLOR_BG);

        snprintf(buffer,sizeof(buffer),"  0x%02X  ",uiCurrent->data.valueAdjust.values[3]);
        UI_ShowDisplayTextCenter(17+(3*(BUTTON_WIDTH+15)),125,BUTTON_WIDTH,BUTTON_HEIGHT,buffer,CLIENT_FONT,CLIENT_COLOR_FG,CLIENT_COLOR_BG);
    }
    else if (uiCurrent->data.valueAdjust.count==3)
    {
        if (uiCurrent->data.valueAdjust.isTime==true)
        {
            snprintf(buffer,sizeof(buffer),"  % 2u  ",uiCurrent->data.valueAdjust.values[0]);
            UI_ShowDisplayTextCenter(60+(0*(BUTTON_WIDTH+15)),125,BUTTON_WIDTH,BUTTON_HEIGHT,buffer,CLIENT_FONT,CLIENT_COLOR_FG,CLIENT_COLOR_BG);

            snprintf(buffer,sizeof(buffer),"  % 2u  ",uiCurrent->data.valueAdjust.values[1]);
            UI_ShowDisplayTextCenter(205+(0*(BUTTON_WIDTH+15)),125,BUTTON_WIDTH,BUTTON_HEIGHT,buffer,CLIENT_FONT,CLIENT_COLOR_FG,CLIENT_COLOR_BG);

            snprintf(buffer,sizeof(buffer),"  % 2u  ",uiCurrent->data.valueAdjust.values[2]);
            UI_ShowDisplayTextCenter(205+(1*(BUTTON_WIDTH+15)),125,BUTTON_WIDTH,BUTTON_HEIGHT,buffer,CLIENT_FONT,CLIENT_COLOR_FG,CLIENT_COLOR_BG);
        }
        else
        {
            snprintf(buffer,sizeof(buffer),"  % 2u  ",uiCurrent->data.valueAdjust.values[0]);
            UI_ShowDisplayTextCenter(74+(0*(BUTTON_WIDTH+15)),125,BUTTON_WIDTH,BUTTON_HEIGHT,buffer,CLIENT_FONT,CLIENT_COLOR_FG,CLIENT_COLOR_BG);

            snprintf(buffer,sizeof(buffer),"  % 2u  ",uiCurrent->data.valueAdjust.values[1]);
            UI_ShowDisplayTextCenter(74+(1*(BUTTON_WIDTH+15)),125,BUTTON_WIDTH,BUTTON_HEIGHT,buffer,CLIENT_FONT,CLIENT_COLOR_FG,CLIENT_COLOR_BG);

            snprintf(buffer,sizeof(buffer),"  %02u  ",uiCurrent->data.valueAdjust.values[2]);
            UI_ShowDisplayTextCenter(74+(2*(BUTTON_WIDTH+15)),125,BUTTON_WIDTH,BUTTON_HEIGHT,buffer,CLIENT_FONT,CLIENT_COLOR_FG,CLIENT_COLOR_BG);
        }
    }
}

void UI_ClickValueAdjust(uint16_t x,uint16_t y)
{
    int32_t                     index;

    // detect at which button was clicked
    index=-1;

    if (uiCurrent->data.valueAdjust.count==10)
    {
        if ((y>=40) && (y<(40+BUTTON_HEIGHT)))
        {
            if ((x>=(60+(0*(BUTTON_WIDTH+15)))) && (x<(60+(0*(BUTTON_WIDTH+15))+BUTTON_WIDTH)))
                index=0;
            else if ((x>=(205+(0*(BUTTON_WIDTH+15)))) && (x<(205+(0*(BUTTON_WIDTH+15))+BUTTON_WIDTH)))
                index=1;
            else if ((x>=(205+(1*(BUTTON_WIDTH+15)))) && (x<(205+(1*(BUTTON_WIDTH+15))+BUTTON_WIDTH)))
                index=2;
        }
        else if ((y>=140) && (y<(140+BUTTON_HEIGHT)))
        {
            if ((x>=(60+(0*(BUTTON_WIDTH+15)))) && (x<(60+(0*(BUTTON_WIDTH+15))+BUTTON_WIDTH)))
                index=3;
            else if ((x>=(205+(0*(BUTTON_WIDTH+15)))) && (x<(205+(0*(BUTTON_WIDTH+15))+BUTTON_WIDTH)))
                index=4;
            else if ((x>=(205+(1*(BUTTON_WIDTH+15)))) && (x<(205+(1*(BUTTON_WIDTH+15))+BUTTON_WIDTH)))
                index=5;
        }
        else if ((y>=215) && (y<(215+BUTTON_SMALL_HEIGHT)))
        {
            if ((x>=(17+(0*(BUTTON_SMALL_WIDTH+15)))) && (x<(17+(0*(BUTTON_SMALL_WIDTH+15))+BUTTON_SMALL_WIDTH)))
                index=6;
            else if ((x>=(17+(1*(BUTTON_SMALL_WIDTH+15)))) && (x<(17+(1*(BUTTON_SMALL_WIDTH+15))+BUTTON_SMALL_WIDTH)))
                index=7;
            else if ((x>=(17+(2*(BUTTON_SMALL_WIDTH+15)))) && (x<(17+(2*(BUTTON_SMALL_WIDTH+15))+BUTTON_SMALL_WIDTH)))
                index=8;
            else if ((x>=(17+(3*(BUTTON_SMALL_WIDTH+15)))) && (x<(17+(3*(BUTTON_SMALL_WIDTH+15))+BUTTON_SMALL_WIDTH)))
                index=9;
            else if ((x>=(17+(4*(BUTTON_SMALL_WIDTH+15)))) && (x<(17+(4*(BUTTON_SMALL_WIDTH+15))+BUTTON_SMALL_WIDTH)))
                index=10;
            else if ((x>=(17+(5*(BUTTON_SMALL_WIDTH+15)))) && (x<(17+(5*(BUTTON_SMALL_WIDTH+15))+BUTTON_SMALL_WIDTH)))
                index=11;
            else if ((x>=(17+(6*(BUTTON_SMALL_WIDTH+15)))) && (x<(17+(6*(BUTTON_SMALL_WIDTH+15))+BUTTON_SMALL_WIDTH)))
                index=12;
        }
    }
    else if (uiCurrent->data.valueAdjust.count==4)
    {
        if ((y>=40) && (y<(40+BUTTON_HEIGHT)))
        {
            if ((x>=(17+(0*(BUTTON_WIDTH+15)))) && (x<(17+(0*(BUTTON_WIDTH+15))+BUTTON_WIDTH)))
                index=0;
            else if ((x>=(17+(1*(BUTTON_WIDTH+15)))) && (x<(17+(1*(BUTTON_WIDTH+15))+BUTTON_WIDTH)))
                index=1;
            else if ((x>=(17+(2*(BUTTON_WIDTH+15)))) && (x<(17+(2*(BUTTON_WIDTH+15))+BUTTON_WIDTH)))
                index=2;
            else if ((x>=(17+(3*(BUTTON_WIDTH+15)))) && (x<(17+(3*(BUTTON_WIDTH+15))+BUTTON_WIDTH)))
                index=3;
        }
        else if ((y>=205) && (y<(205+BUTTON_HEIGHT)))
        {
            if ((x>=(17+(0*(BUTTON_WIDTH+15)))) && (x<(17+(0*(BUTTON_WIDTH+15))+BUTTON_WIDTH)))
                index=4;
            else if ((x>=(17+(1*(BUTTON_WIDTH+15)))) && (x<(17+(1*(BUTTON_WIDTH+15))+BUTTON_WIDTH)))
                index=5;
            else if ((x>=(17+(2*(BUTTON_WIDTH+15)))) && (x<(17+(2*(BUTTON_WIDTH+15))+BUTTON_WIDTH)))
                index=6;
            else if ((x>=(17+(3*(BUTTON_WIDTH+15)))) && (x<(17+(3*(BUTTON_WIDTH+15))+BUTTON_WIDTH)))
                index=7;
        }
    }
    else if (uiCurrent->data.valueAdjust.count==3)
    {
        if (uiCurrent->data.valueAdjust.isTime==true)
        {
            if ((y>=40) && (y<(40+BUTTON_HEIGHT)))
            {
                if ((x>=(60+(0*(BUTTON_WIDTH+15)))) && (x<(60+(0*(BUTTON_WIDTH+15))+BUTTON_WIDTH)))
                    index=0;
                else if ((x>=(205+(0*(BUTTON_WIDTH+15)))) && (x<(205+(0*(BUTTON_WIDTH+15))+BUTTON_WIDTH)))
                    index=1;
                else if ((x>=(205+(1*(BUTTON_WIDTH+15)))) && (x<(205+(1*(BUTTON_WIDTH+15))+BUTTON_WIDTH)))
                    index=2;
            }
            else if ((y>=205) && (y<(205+BUTTON_HEIGHT)))
            {
                if ((x>=(60+(0*(BUTTON_WIDTH+15)))) && (x<(60+(0*(BUTTON_WIDTH+15))+BUTTON_WIDTH)))
                    index=3;
                else if ((x>=(205+(0*(BUTTON_WIDTH+15)))) && (x<(205+(0*(BUTTON_WIDTH+15))+BUTTON_WIDTH)))
                    index=4;
                else if ((x>=(205+(1*(BUTTON_WIDTH+15)))) && (x<(205+(1*(BUTTON_WIDTH+15))+BUTTON_WIDTH)))
                    index=5;
            }
        }
        else
        {
            if ((y>=40) && (y<(40+BUTTON_HEIGHT)))
            {
                if ((x>=(74+(0*(BUTTON_WIDTH+15)))) && (x<(74+(0*(BUTTON_WIDTH+15))+BUTTON_WIDTH)))
                    index=0;
                else if ((x>=(74+(1*(BUTTON_WIDTH+15)))) && (x<(74+(1*(BUTTON_WIDTH+15))+BUTTON_WIDTH)))
                    index=1;
                else if ((x>=(74+(2*(BUTTON_WIDTH+15)))) && (x<(74+(2*(BUTTON_WIDTH+15))+BUTTON_WIDTH)))
                    index=2;
            }
            else if ((y>=205) && (y<(205+BUTTON_HEIGHT)))
            {
                if ((x>=(74+(0*(BUTTON_WIDTH+15)))) && (x<(74+(0*(BUTTON_WIDTH+15))+BUTTON_WIDTH)))
                    index=3;
                else if ((x>=(74+(1*(BUTTON_WIDTH+15)))) && (x<(74+(1*(BUTTON_WIDTH+15))+BUTTON_WIDTH)))
                    index=4;
                else if ((x>=(74+(2*(BUTTON_WIDTH+15)))) && (x<(74+(2*(BUTTON_WIDTH+15))+BUTTON_WIDTH)))
                    index=5;
            }
        }
    }

    if (index!=-1)
        uiCurrent->handler(UR_CLICK,index,uiCurrent);
}

//
// common
//
void UI_Init(void)
{
    uiCurrent=NULL;

    uiLastTouchX=0;
    uiLastTouchY=0;

    uiLcd.Init();
    // layer 0: slideshow pictures
    // layer 1: all other ui
    uiLcd.SelectLayer(1);
    uiLcd.Clear(COLOR_BG);

    if (uiTs.Init(uiLcd.GetXSize(),uiLcd.GetYSize())==TS_OK)
        DPrintf("UI_Init: Size: %ux%u.\r\n",uiLcd.GetXSize(),uiLcd.GetYSize());
    else
        DPrintf("UI_Init: Can't init touch screen.\r\n");

    // setup ui structs
    uiClock.flags=UI_FLAG_TYPE_CLOCK;
    uiClock.handler=NULL;

    uiClockInWords.flags=UI_FLAG_TYPE_CLOCK_IN_WORDS;
    uiClockInWords.handler=NULL;

    uiColorTest.flags=UI_FLAG_TYPE_VALUE_ADJUST;
    uiColorTest.handler=UI_ColorTestHandler;
    uiColorTest.data.valueAdjust.count=4;
    uiColorTest.data.valueAdjust.values[0]=0x80;
    uiColorTest.data.valueAdjust.values[1]=0x80;
    uiColorTest.data.valueAdjust.values[2]=0x80;
    uiColorTest.data.valueAdjust.values[3]=0x80;

    uiMain.flags=UI_FLAG_TYPE_BOX_LIST;
    uiMain.handler=UI_MainHandler;
    uiMain.data.boxList.items=uiMainItems;
    uiMain.data.boxList.count=COUNT_OF(uiMainItems);

    uiSlideshow.flags=UI_FLAG_TYPE_SLIDESHOW;

    UI_Show(&uiMain);
}

void UI_ShowChrome(bool initial)
{
    char                        buffer[100];
    struct tm                   *tmStruct;

    if (initial==true)
    {
        // fill background
        uiLcd.SetTextColor(HEADER_COLOR_BG);
        uiLcd.FillRect(0,0,uiLcd.GetXSize(),HEADER_HEIGHT);

        // draw line
        uiLcd.SetTextColor(HEADER_LINE);
        uiLcd.DrawHLine(10,HEADER_HEIGHT-1,uiLcd.GetXSize()-20);

        if ((uiCurrent->flags & UI_FLAG_HAS_BACK_BUTTON)!=0)
            UI_DrawBitmapWithAlpha(5,1,ic_navigate_before_white_24dp_1x);
    }

    // show clock
    RTC_Get(&tmStruct);
    snprintf(buffer,sizeof(buffer),"  %u:%02u  ",tmStruct->tm_hour,tmStruct->tm_min);
    UI_ShowDisplayTextCenter(0,2,uiLcd.GetXSize(),-1,buffer,HEADER_FONT,HEADER_COLOR_FG,HEADER_COLOR_BG);

    // show next alarm
    //XXX
}

void UI_Update(bool initial)
{
    uint8_t     typeFlag;

    if ((uiCurrent->flags & UI_FLAG_NEEDS_CHROME)!=0)
        UI_ShowChrome(initial);

    typeFlag=uiCurrent->flags & ~(UI_FLAG_NEEDS_CHROME | UI_FLAG_HAS_BACK_BUTTON);
    if ((typeFlag & UI_FLAG_TYPE_BOX_LIST)!=0)
        UI_ShowBoxList(initial);
    else if ((typeFlag & UI_FLAG_TYPE_CLOCK)!=0)
        UI_ShowClock(initial);
    else if ((typeFlag & UI_FLAG_TYPE_CLOCK_IN_WORDS)!=0)
        UI_ShowClockInWords(initial);
    else if ((typeFlag & UI_FLAG_TYPE_SLIDESHOW)!=0)
        UI_ShowSlideshow(initial);
    else if ((typeFlag & UI_FLAG_TYPE_VALUE_ADJUST)!=0)
        UI_ShowValueAdjust(initial);
}

void UI_Show(UI_STRUCT *ui)
{
    DPrintf_("UI_Show: 0x%X.\r\n",ui->flags);

    uiCurrent=ui;

    if (uiCurrent->handler!=NULL)
        uiCurrent->handler(UR_SHOW,0,uiCurrent);

    UI_Update(true);
}

void UI_Click(uint16_t x,uint16_t y)
{
    uint8_t     typeFlag;

    DPrintf_("UI_Click: %u x %u.\r\n",x,y);

    if ((uiCurrent->flags & UI_FLAG_HAS_BACK_BUTTON)!=0)
    {
        if ((y<40) && (x<40))
        {
            if (uiCurrent->handler!=NULL)
            {
                uiCurrent->handler(UR_CLICK,-1,uiCurrent);
                return;
            }
        }
    }

    typeFlag=uiCurrent->flags & ~(UI_FLAG_NEEDS_CHROME | UI_FLAG_HAS_BACK_BUTTON);
    if ((typeFlag & UI_FLAG_TYPE_BOX_LIST)!=0)
        UI_ClickBoxList(x,y);
    else if ((typeFlag & UI_FLAG_TYPE_CLOCK)!=0)
        UI_ClickClock(x,y);
    else if ((typeFlag & UI_FLAG_TYPE_CLOCK_IN_WORDS)!=0)
        UI_ClickClockInWords(x,y);
    else if ((typeFlag & UI_FLAG_TYPE_SLIDESHOW)!=0)
        UI_ClickSlideshow(x,y);
    else if ((typeFlag & UI_FLAG_TYPE_VALUE_ADJUST)!=0)
        UI_ClickValueAdjust(x,y);
}

void UI_Poll(void)
{
    TS_StateTypeDef             tsState;

    uiTs.GetState(&tsState);
    if (tsState.touchDetected>0)
    {
        if (        (ABS(uiLastTouchX-tsState.touchX[0])>4)
                ||
                    (ABS(uiLastTouchY-tsState.touchY[0])>4)
           )
        {
            DPrintf_("UI_Poll: #%u - %ux%u.\r\n",tsState.touchDetected,tsState.touchX[0],tsState.touchY[0]);

            uiLastTouchX=tsState.touchX[0];
            uiLastTouchY=tsState.touchY[0];
    
            if (uiCurrent!=NULL)
                UI_Click(tsState.touchX[0],tsState.touchY[0]);
        }
    }
    else
    {
        uiLastTouchX=0;
        uiLastTouchY=0;
    }
  
    if (uiCurrent!=NULL)
    {
        if (uiCurrent->handler!=NULL)
            uiCurrent->handler(UR_TIMER,0,uiCurrent);

        UI_Update(false);
    }
}
