#include "WakeupLight.h"

//#define USE_RTC

#define CT_MAGIC_VALUE              0x546865DF      // 'Theß'

#ifdef USE_RTC
    uint32_t                        *rtcBackupRegisters;
#else
    uint32_t                        configSpace[CT_MAX];
#endif

void Config_Init(void)
{
    uint32_t                index;

    #ifdef USE_RTC

        RTC_TypeDef             *rtc;
    
        rtc=(RTC_TypeDef *)RTC_BASE;
        rtcBackupRegisters=(uint32_t *)&rtc->BKP0R;
    
        if (rtcBackupRegisters[CT_MAGIC]!=CT_MAGIC_VALUE)
        {
            DPrintf("Config_Init: Reset config because of 0x%08X.\r\n",rtcBackupRegisters[CT_MAGIC]);
    
            for (index=0;index<=CT_MAX;index++)
                rtcBackupRegisters[index]=0;
    
            rtcBackupRegisters[CT_MAGIC]=CT_MAGIC_VALUE;
        }

    #else

        for (index=0;index<=CT_MAX;index++)
            configSpace[index]=0;

        configSpace[CT_MAGIC]=CT_MAGIC_VALUE;

    #endif
}

uint32_t Config_Get(CONFIG_TYPE_ENUM type)
{
    if (type>CT_MAX)
        return 0;

    DPrintf_("Config_Get: %u -> 0x%X.\r\n",type,configSpace[type]);

    #ifdef USE_RTC
        return rtcBackupRegisters[type];
    #else
        return configSpace[type];
    #endif
}

void Config_Set(CONFIG_TYPE_ENUM type,uint32_t value)
{
    if (type>CT_MAX)
        return;

    DPrintf_("Config_Set: %u -> 0x%X.\r\n",type,value);

    #ifdef USE_RTC

        RTC_TypeDef             *rtc;

        rtc=(RTC_TypeDef *)RTC_BASE;
        rtc->WPR=0xCA;
        rtc->WPR=0x53;

        rtcBackupRegisters[type]=value;

        rtc->WPR=0xFF;

    #else

        configSpace[type]=value;

    #endif
}
