#ifndef __WakeupLight_h
#define __WakeupLight_h

#include "mbed.h"
#include "stm32746g_discovery.h"
#include "stm32746g_discovery_sd.h"
#include "stm32746g_discovery_audio.h"
#include "TS_DISCO_F746NG.h"
#include "LCD_DISCO_F746NG.h"
#include "rtc_api.h"

#include <FATFileSystem.h>

#include <TinyJpgDec/TinyJpgDec.h>

#define COUNT_OF(__ARRAY__)                                 (sizeof(__ARRAY__)/sizeof(__ARRAY__[0]))
#define MIN(X,Y)                                            ((X) < (Y) ? (X) : (Y))
#define MAX(X,Y)                                            ((X) > (Y) ? (X) : (Y))
#define ABS(_VALUE_)                                        (((_VALUE_) < 0) ? -(_VALUE_) : (_VALUE_))

typedef uint8_t                                             BYTE;

#include "OnBoardLED.h"
#include "LED.h"
#include "SD.h"
#include "Sound.h"
#include "UI.h"
#include "Config.h"
#include "RTC.h"
#include "FontX/FontX.h"
#include "debug.h"

#include "STMLIBRARIES/tm_stm32_rng.h"

#endif
