#ifndef __UI_h
#define __UI_h

#define UI_FLAG_TYPE_BOX_LIST           (0x01 | UI_FLAG_NEEDS_CHROME)
#define UI_FLAG_TYPE_CLOCK              0x02
#define UI_FLAG_TYPE_CLOCK_IN_WORDS     (0x04 | UI_FLAG_NEEDS_CHROME)
#define UI_FLAG_TYPE_VALUE_ADJUST       (0x08 | UI_FLAG_NEEDS_CHROME | UI_FLAG_HAS_BACK_BUTTON)
#define UI_FLAG_NEEDS_CHROME            0x10
#define UI_FLAG_HAS_BACK_BUTTON         0x20
#define UI_FLAG_TYPE_SLIDESHOW          0x40

typedef enum
{
    UR_CLICK,
    UR_TIMER,
    UR_SHOW,

} UI_REASON_ENUM;

struct UI_STRUCT_;
typedef void (*UI_HANDLER_CALLBACK)(UI_REASON_ENUM reason,int32_t index,UI_STRUCT_ *ui);

typedef struct
{
    char                                *name;
    uint8_t                             *image;

} UI_BOX_LIST_ITEM_STRUCT;
    
typedef struct UI_STRUCT_
{
    int8_t                              flags;      // UI_FLAG_...
    UI_HANDLER_CALLBACK                 handler;

    union
    {
        struct
        {
            UI_BOX_LIST_ITEM_STRUCT     *items;
            uint8_t                     count;

        } boxList;

        struct
        {
            uint8_t                     count;
            bool                        isTime;
            int32_t                     values[10];

        } valueAdjust;

    } data;

} UI_STRUCT;

extern UI_STRUCT                        uiClock;
extern UI_STRUCT                        uiClockInWords;
extern UI_STRUCT                        uiColorTest;
extern UI_STRUCT                        uiWakeup;
extern UI_STRUCT                        uiSlideshow;
extern UI_STRUCT                        uiMain;

void UI_Init(void);
void UI_Poll(void);
void UI_Show(UI_STRUCT *ui);

void UI_MainHandler(UI_REASON_ENUM reason,int32_t index,UI_STRUCT *ui);

void UI_WakeupHandler(UI_REASON_ENUM reason,int32_t index,UI_STRUCT *ui);
void UI_WakeupShow(void);

void UI_TimeShow(void);

void UI_ColorTestHandler(UI_REASON_ENUM reason,int32_t index,UI_STRUCT *ui);

extern LCD_DISCO_F746NG                 uiLcd;

#endif
