#include "WakeupLight.h"

void RTC_Init(void)
{
    rtc_init();
}

time_t RTC_Get(struct tm **tmStruct)
{
    time_t              result;

    // rtc_read in IAR is buggy, it converts the rtc time to local time, sometimes with, sometimes without timezone
    result=time(NULL);
    localtime(&result);

    result=time(NULL);

    DPrintf_("RTC_Get: 0x%X.\r\n",result);

    if (tmStruct!=NULL)
        (*tmStruct)=localtime(&result);

    return result;
}

void RTC_Set(struct tm *tmStruct)
{
    time_t              result;

    result=mktime(tmStruct);

    set_time(result);
}
    