#ifndef __LED_h
#define __LED_h

#define COLOR_CREATE(_RED_,_GREEN_,_BLUE_,_WHITE_)          (_RED_ | (_GREEN_ << 8) | (_BLUE_ << 16) | (_WHITE_ <<24))
#define COLOR_RED(_COLOR_)                                  (_COLOR_ & 0xFF)
#define COLOR_GREEN(_COLOR_)                                ((_COLOR_ >> 8) & 0xFF)
#define COLOR_BLUE(_COLOR_)                                 ((_COLOR_ >> 16) & 0xFF)
#define COLOR_WHITE(_COLOR_)                                ((_COLOR_ >> 24) & 0xFF)

typedef enum
{
    LAE_NONE,
    LAE_WAKEUP,
    LAE_OFF,

} LED_ANIMATION_ENUM;
     
void LED_Init(void);
void LED_StartAnimation(LED_ANIMATION_ENUM animation);
void LED_SetColor(int32_t color);

#endif
