#ifndef __FontX_h
#define __FontX_h

#include "mbed.h"

#define uint_8              unsigned char
#define int8                char
#define int16               short
#define int32               long

typedef struct
{
    unsigned int16          Charwidth;
    unsigned int16          Charheight;
    unsigned int32          Offset;

} FONT_CHAR_INFO;

typedef struct
{
   char                     StartCharacter;
   char                     EndCharacter;
   const FONT_CHAR_INFO     *Descriptors;
   const unsigned int8      *Bitmaps;

} FONT_INFO;

#include "Calibri36pt.h"
#include "TrebuchetMS270pt.h"
#include "TrebuchetMS135pt.h"

typedef enum
{
  ALIGN_CENTER,
  ALIGN_RIGHT,
  ALIGN_LEFT

} FONTX_ALIGNMENT_ENUM;

uint32_t FontX_GetLength(char *Text,const FONT_INFO *pFont);
uint32_t FontX_GetHeight(const FONT_INFO *pFont);
void FontX_DisplayStringAt(uint16_t Xpos,uint16_t Ypos,uint16_t width,char *Text,FONTX_ALIGNMENT_ENUM Alignment,const FONT_INFO *pFont,uint32_t colorText,uint32_t colorBack);
uint32_t FontX_DisplayChar(uint16_t Xpos,uint16_t Ypos,char Ascii,const FONT_INFO *pFont,uint32_t colorText,uint32_t colorBack);

#endif

