#ifndef __Config_h
#define __Config_h

#define CONFIG_ALARM_MASK_MONDAY            0x0001
#define CONFIG_ALARM_MASK_TUESDAY           0x0002
#define CONFIG_ALARM_MASK_WEDNESDAY         0x0004
#define CONFIG_ALARM_MASK_THURSDAY          0x0008
#define CONFIG_ALARM_MASK_FRIDAY            0x0010
#define CONFIG_ALARM_MASK_SATURDAY          0x0020
#define CONFIG_ALARM_MASK_SUNDAY            0x0040
#define CONFIG_ALARM_MASK_DAYS              (CONFIG_ALARM_MASK_MONDAY | CONFIG_ALARM_MASK_TUESDAY | CONFIG_ALARM_MASK_WEDNESDAY | CONFIG_ALARM_MASK_THURSDAY | CONFIG_ALARM_MASK_FRIDAY | CONFIG_ALARM_MASK_SATURDAY | CONFIG_ALARM_MASK_SUNDAY)

typedef enum
{
    CT_MAGIC,

    CT_ALARM_1_TIME,
    CT_ALARM_1_MASK,

    CT_ALARM_2_TIME,
    CT_ALARM_2_MASK,

    CT_ALARM_3_TIME,
    CT_ALARM_3_MASK,

    CT_ALARM_4_TIME,
    CT_ALARM_4_MASK,

    CT_ALARM_5_TIME,
    CT_ALARM_5_MASK,

    CT_ALARM_6_TIME,
    CT_ALARM_6_MASK,

    CT_MAX=RTC_BKP_DR31

} CONFIG_TYPE_ENUM;

void Config_Init(void);
uint32_t Config_Get(CONFIG_TYPE_ENUM type);
void Config_Set(CONFIG_TYPE_ENUM type,uint32_t value);

#endif
