#include "WakeupLight.h"

int                             lastCheckedMinute=-1;

void checkForAlarmSpecified(struct tm *tmStruct,CONFIG_TYPE_ENUM typeTime,CONFIG_TYPE_ENUM typeFlags)
{
    uint32_t                    value;
    bool                        checkTime;

    value=Config_Get(typeFlags);
    if (value!=0)
    {
        checkTime=false;

        DPrintf("checkForAlarmSpecified: %u.\r\n",tmStruct->tm_wday);

        if (((value & CONFIG_ALARM_MASK_MONDAY)!=0) && (tmStruct->tm_wday==1))
            checkTime=true;
        if (((value & CONFIG_ALARM_MASK_TUESDAY)!=0) && (tmStruct->tm_wday==2))
            checkTime=true;
        if (((value & CONFIG_ALARM_MASK_WEDNESDAY)!=0) && (tmStruct->tm_wday==3))
            checkTime=true;
        if (((value & CONFIG_ALARM_MASK_THURSDAY)!=0) && (tmStruct->tm_wday==4))
            checkTime=true;
        if (((value & CONFIG_ALARM_MASK_FRIDAY)!=0) && (tmStruct->tm_wday==5))
            checkTime=true;
        if (((value & CONFIG_ALARM_MASK_SATURDAY)!=0) && (tmStruct->tm_wday==6))
            checkTime=true;
        if (((value & CONFIG_ALARM_MASK_SUNDAY)!=0) && (tmStruct->tm_wday==0))
            checkTime=true;
            
        if (checkTime==true)
        {
            value=Config_Get(typeTime);
            if (value==((tmStruct->tm_hour << 8) | (tmStruct->tm_min)))
            {
                DPrintf("checkForAlarmSpecified: Alarm detecetd.\r\n");
                LED_StartAnimation(LAE_WAKEUP);
            }
        }
    }
}
    
void checkForAlarm(void)
{
    struct tm                   *tmStruct;

    RTC_Get(&tmStruct);
    
    if (tmStruct->tm_min!=lastCheckedMinute)
    {
        lastCheckedMinute=tmStruct->tm_min;
        
        // check all alarm against current time
        checkForAlarmSpecified(tmStruct,CT_ALARM_1_TIME,CT_ALARM_1_MASK);
        checkForAlarmSpecified(tmStruct,CT_ALARM_2_TIME,CT_ALARM_2_MASK);
        checkForAlarmSpecified(tmStruct,CT_ALARM_3_TIME,CT_ALARM_3_MASK);
        checkForAlarmSpecified(tmStruct,CT_ALARM_4_TIME,CT_ALARM_4_MASK);
        checkForAlarmSpecified(tmStruct,CT_ALARM_5_TIME,CT_ALARM_5_MASK);
        checkForAlarmSpecified(tmStruct,CT_ALARM_6_TIME,CT_ALARM_6_MASK);
    }
}

int main()
{
    debug_Init();

    RTC_Init();

    DPrintf("WakeupLight - Hardware v%08X @ %u MHz.\r\n",BSP_GetVersion(),(HAL_RCC_GetSysClockFreq()/1000/1000));

    OnBoardLED_Init();

    TM_RNG_Init();

    LED_Init();

    Sound_Init();

    SD_Init();

    UI_Init();

    Config_Init();

    for (;;)
    {
        checkForAlarm();

        UI_Poll();
    }
}
